/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import ucar.netcdf.NetcdfFile;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.in.FileDataFactory;
import visad.data.netcdf.in.Merger;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.data.netcdf.in.Strategy;

public class FileStrategy
extends Strategy {
    private static FileStrategy instance = new FileStrategy();

    public static Strategy instance() {
        return instance;
    }

    protected FileStrategy() {
    }

    @Override
    public DataImpl getData(NetcdfAdapter adapter) throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        try {
            return NetcdfAdapter.importData(adapter.getView(), this.getMerger(), FileDataFactory.instance());
        }
        catch (OutOfMemoryError e) {
            throw new OutOfMemoryError(this.getClass().getName() + ".getData(): " + "Couldn't import netCDF dataset: " + e.getMessage());
        }
    }

    protected Merger getMerger() {
        return Merger.instance();
    }

    public static void main(String[] args) throws Exception {
        String[] pathnames = args.length == 0 ? new String[]{"test.nc"} : args;
        System.setProperty("visad.data.netcdf.in.Strategy", FileStrategy.class.getName());
        for (int i = 0; i < pathnames.length; ++i) {
            NetcdfFile file = new NetcdfFile(pathnames[i], true);
            NetcdfAdapter adapter = new NetcdfAdapter(file, QuantityDBManager.instance());
            DataImpl data = adapter.getData();
            System.out.println("data.getClass().getName() = " + data.getClass().getName());
            System.out.println("data.getType().prettyString():\n" + data.getType().prettyString());
        }
    }
}

