/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.util.Iterator;
import visad.RealType;
import visad.SI;
import visad.TypeException;
import visad.VisADError;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBImpl;
import visad.data.netcdf.UnsupportedOperationException;
import visad.data.units.ParseException;

public final class StandardQuantityDB
extends QuantityDBImpl {
    private static StandardQuantityDB db;

    public static StandardQuantityDB instance() {
        return db;
    }

    private StandardQuantityDB() throws VisADException {
        super(null);
        try {
            this.add(RealType.Generic);
            this.add(RealType.Radius);
            this.add(RealType.XAxis);
            this.add(RealType.YAxis);
            this.add(RealType.ZAxis);
            this.add(RealType.Latitude);
            this.add(RealType.Longitude);
            this.add(RealType.Altitude);
            this.add(RealType.Time);
            super.add(SI.ampere.quantityName(), "A");
            super.add(SI.candela.quantityName(), "cd");
            super.add(SI.kelvin.quantityName(), "K");
            super.add(SI.kilogram.quantityName(), "kg");
            super.add(SI.meter.quantityName(), "m");
            super.add(SI.mole.quantityName(), "mol");
            super.add(SI.radian.quantityName(), "rad");
            super.add("SolidAngle", "sr");
            super.add("Volume", "m3");
            super.add("VolumeFraction", "m3/m3");
            super.add("VolumeFlow", "m3/s");
            super.add("Acceleration", "m/s2");
            super.add("Area", "m2");
            super.add("Frequency", "Hz");
            super.add("WaveNumber", "m-1");
            super.add("Speed", "m/s");
            super.add("Velocity", "m/s");
            super.add("AngularVelocity", "rad/s");
            super.add("AngularAcceleration", "rad/s2");
            Quantity quantity = new Quantity("SurfaceMassDensity", "kg/m2");
            super.add("SurfaceMassDensity", quantity);
            super.add("AreicMass", quantity);
            super.add("MassPerArea", quantity);
            quantity = new Quantity("LinearMassDensity", "kg/m2");
            super.add("LinearMassDensity", quantity);
            super.add("LineicMass", quantity);
            super.add("MassPerLength", "kg/m");
            super.add("MassFraction", "kg/kg");
            quantity = new Quantity("MassFlow", "kg/s");
            super.add("MassFlux", quantity);
            super.add("MassFlow", quantity);
            quantity = new Quantity("Density", "kg/m3");
            super.add("MassDensity", quantity);
            super.add("Density", quantity);
            super.add("VolumicMass", quantity);
            quantity = new Quantity("SpecificVolume", "m3/kg");
            super.add("SpecificVolume", quantity);
            super.add("MassicVolume", quantity);
            super.add("Force", "N");
            super.add("MomentOfForce", "N.m");
            super.add("SurfaceTension", "N/m");
            quantity = new Quantity("LinearForceDensity", "N/m");
            super.add("LinearForceDensity", quantity);
            super.add("LineicForce", quantity);
            super.add("ForcePerLength", quantity);
            super.add("Torque", "N.m");
            quantity = new Quantity("LinearTorqueDensity", "N");
            super.add("LinearTorqueDensity", quantity);
            super.add("LineicTorque", quantity);
            super.add("TorquePerlength", quantity);
            super.add("Pressure", "Pa");
            super.add("Stress", "Pa");
            super.add("DynamicViscosity", "Pa.s");
            super.add("KinematicViscosity", "m2/s");
            super.add("Energy", "J");
            super.add("Work", "J");
            super.add("QuantityOfHeat", "J");
            super.add("Power", "W");
            quantity = new Quantity("SurfacePowerDensity", "J/(m2.s)");
            super.add("SurfacePowerDensity", quantity);
            super.add("AreicPower", quantity);
            super.add("EnergyPerAreaTime", quantity);
            super.add("SpecificAvailableEnergy", "J/kg");
            super.add("SpecificEnergy", "J/kg");
            quantity = new Quantity("AvailableEnergyDensity", "J/m3");
            super.add("AvailableEnergyDensity", quantity);
            super.add("VolumicAvailableEnergy", quantity);
            quantity = new Quantity("EnergyDensity", "J/m3");
            super.add("EnergyDensity", quantity);
            super.add("VolumicEnergy", quantity);
            super.add("ThermalConductivity", "W/(m.K)");
            super.add("ThermalDiffusivity", "m2/s");
            super.add("ThermalInsulance", "(m3.K)/W");
            super.add("ThermalResistance", "K/W");
            super.add("ThermalResistivity", "(m.K)/W");
            super.add("CoefficientOfHeatTransfer", "W/(m2.K)");
            quantity = new Quantity("SurfaceHeatDensity", "J/m2");
            super.add("SurfaceHeatDensity", quantity);
            super.add("AreicHeat", quantity);
            super.add("DensityOfHeat", quantity);
            quantity = new Quantity("SurfaceHeatFlowDensity", "W/m2");
            super.add("SurfaceHeatFlowDensity", quantity);
            super.add("SurfaceHeatFluxDensity", quantity);
            super.add("AreicHeatFlow", quantity);
            super.add("AreicHeatFlux", quantity);
            super.add("DensityOfHeatFlowRate", quantity);
            super.add("HeatCapacity", "J/K");
            super.add("Entropy", "J/K");
            super.add("HeatFlowRate", "W");
            super.add("SpecificHeatCapcity", "J/(kg.K)");
            super.add("SpecificHeat", "J/(kg.K)");
            super.add("SpecificEntropy", "J/(kg.K)");
            super.add("Capacitance", "F");
            quantity = new Quantity("Permittivity", "F/m");
            super.add("Permittivity", quantity);
            super.add("MagneticPermittivity", quantity);
            super.add("MagneticPermeability", "H/m");
            super.add("ElectricCharge", "C");
            quantity = new Quantity("ElectricChargeDensity", "C/m3");
            super.add("ElectricChargeDensity", quantity);
            super.add("VolumicElectricCharge", quantity);
            quantity = new Quantity("ElectricFluxDensity", "C/m2");
            super.add("ElectricFluxDensity", quantity);
            super.add("SurfaceElectricChargeDensity", quantity);
            super.add("AreicElectricCharge", quantity);
            super.add("ElectricResistance", "Ohm");
            super.add("ElectricConductance", "S");
            quantity = new Quantity("EMF", "V");
            super.add("ElectricPotentialDifference", quantity);
            super.add("ElectromotiveForce", quantity);
            super.add("EMF", quantity);
            quantity = new Quantity("CurrentDensity", "A/m2");
            super.add("CurrentDensity", quantity);
            super.add("SurfaceCurrentDensity", quantity);
            super.add("AreicCurrent", quantity);
            super.add("Inductance", "H");
            super.add("MagneticFlux", "Wb");
            super.add("MagneticFluxDensity", "T");
            super.add("MagneticFieldStrength", "A/m");
            super.add("ElectricFieldStrength", "V/m");
            super.add("Illuminance", "lx");
            super.add("Irradiance", "W/m2");
            super.add("RadiantEmittance", "W/m2");
            super.add("Radiance", "W/(m2.sr)");
            super.add("Luminance", "cd/m2");
            super.add("LuminousFlux", "lm");
            super.add("RadiantFlux", "W");
            super.add("RadiantIntensity", "W/sr");
            super.add("AmountOfSubstanceFraction", "mol/mol");
            super.add("MolarVolume", "m3/mol");
            super.add("MolarMass", "kg/mol");
            super.add("AmountOfSubstanceConcentration", "mol/m3");
            super.add("Molality", "mol/kg");
            super.add("MolarEnergy", "J/mol");
            super.add("MolarEntropy", "J/(mol K)");
            super.add("MolarHeatCapacity", "J/(mol K)");
            super.add("EquivalentPermeability", "m2");
            quantity = new Quantity("SurfaceFlowPermeabilityDensity", "kg/(Pa.s.m2)");
            super.add("SurfaceFlowPermeabilityDensity", quantity);
            super.add("AreicFlowPermeability", quantity);
            quantity = new Quantity("LinearFlowPermeabilityDensity", "kg/(Pa.s.m)");
            super.add("LinearFlowPermeabilityDensity", quantity);
            super.add("LineicFlowPermeability", quantity);
            super.add("AbsorbedDose", "Gy");
            super.add("AbsorbedDoseRate", "Gy/s");
            super.add("DoseEquivalent", "Sv");
            super.add("Activity", "Bq");
            super.add("Exposure", "C/kg");
            super.add("VolumePerWorkFuelConsumption", "m3/J");
            quantity = new Quantity("DistancePerVolumeFuelConsumption", "m/m3");
            super.add("DistancePerVolumeFuelConsumption", quantity);
            super.add("DistanceDensityFuelConsumption", quantity);
            super.add("VolumicDistanceFuelConsumption", quantity);
            super.add("MassPerWorkFuelConsumption", "kg/J");
            super.add("Direction", "deg");
            quantity = this.get("Latitude");
            super.add("GeodeticLatitude", quantity);
            super.add("lat", quantity);
            quantity = this.get("Longitude");
            super.add("GeodeticLongitude", quantity);
            super.add("Longitude", quantity);
            super.add("lon", quantity);
            quantity = this.get("Altitude");
            super.add("Elevation", quantity);
            super.add("Altitude", quantity);
            super.add("alt", quantity);
            super.add("Depth", "m");
        }
        catch (ParseException e) {
            throw new VisADException(e.getMessage());
        }
    }

    @Override
    public QuantityDB add(String[] definitions, String[] aliases) throws ParseException, TypeException, VisADException {
        return new QuantityDBImpl(this).add(definitions, aliases);
    }

    @Override
    public void add(String name, String unitSpec) {
        throw new UnsupportedOperationException("Standard Quantity database is unmodifiable");
    }

    private void add(RealType realType) throws VisADException {
        super.add(realType.getName(), new Quantity(realType));
    }

    public static void main(String[] args) throws Exception {
        StandardQuantityDB db = StandardQuantityDB.instance();
        if (args.length != 1 || !args[0].equals("list")) {
            System.out.println("LaTiTuDe=<" + db.get("LaTiTuDe") + ">");
        } else {
            Iterator iter = db.nameIterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Quantity quantity = db.get(name);
                System.out.println(name + " (" + quantity.getName() + ") in " + quantity.getDefaultUnitString());
            }
        }
    }

    static {
        try {
            db = new StandardQuantityDB();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new VisADError("visad.data.netcdf.StandardQuantityDB.<clinit>: Couldn't initialize class: " + e);
        }
    }
}

