/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueUnpacker;

public final class OffsetUnpacker
extends ValueUnpacker {
    private final float floatOffset;
    private final double doubleOffset;
    private static final WeakHashMap map = new WeakHashMap();

    private OffsetUnpacker(double offset) {
        this.floatOffset = (float)offset;
        this.doubleOffset = offset;
    }

    public static synchronized OffsetUnpacker offsetUnpacker(double offset) {
        OffsetUnpacker unpacker = new OffsetUnpacker(offset);
        WeakReference ref = (WeakReference)map.get(unpacker);
        if (ref == null) {
            map.put(unpacker, new WeakReference<OffsetUnpacker>(unpacker));
        } else {
            OffsetUnpacker oldUnpacker = (OffsetUnpacker)ref.get();
            if (oldUnpacker == null) {
                map.put(unpacker, new WeakReference<OffsetUnpacker>(unpacker));
            } else {
                unpacker = oldUnpacker;
            }
        }
        return unpacker;
    }

    @Override
    public float process(float value) {
        return this.floatOffset + value;
    }

    @Override
    public double process(double value) {
        return this.doubleOffset + value;
    }

    @Override
    public float[] process(float[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] + this.floatOffset;
        }
        return values;
    }

    @Override
    public double[] process(double[] values) {
        int i = 0;
        while (i < values.length) {
            int n = i++;
            values[n] = values[n] + this.doubleOffset;
        }
        return values;
    }

    public boolean equals(Object obj) {
        OffsetUnpacker that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (OffsetUnpacker)obj) || this.doubleOffset == that.doubleOffset;
        return equals;
    }

    public int hashCode() {
        return new Double(this.doubleOffset).hashCode();
    }
}

