/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.PrimitiveVector;
import java.rmi.RemoteException;
import visad.FieldImpl;
import visad.FlatField;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.NumericVectorAdapter;
import visad.data.dods.VariableAdapterFactory;
import visad.data.in.ArithProg;

public abstract class FloatVectorAdapter
extends NumericVectorAdapter {
    protected FloatVectorAdapter(PrimitiveVector vector, DAS das, VariableAdapterFactory factory) throws BadFormException, VisADException, RemoteException {
        super(vector, das, factory);
    }

    @Override
    public final void setField(PrimitiveVector vector, FieldImpl field, boolean copy) throws VisADException, RemoteException {
        if (field.isFlatField()) {
            ((FlatField)field).setSamples(new float[][]{this.getFloats(vector, copy)}, false);
        } else {
            field.setSamples(new float[][]{this.getFloats(vector, copy)});
        }
    }

    @Override
    public GriddedSet griddedSet(PrimitiveVector vector) throws VisADException, RemoteException {
        float[] vals = this.getFloats(vector, true);
        ArithProg ap = new ArithProg();
        ap.accumulate(vals);
        return ap.isConsistent() ? new Linear1DSet(this.getMathType(), ap.getFirst(), ap.getLast(), (int)ap.getNumber()) : Gridded1DSet.create(this.getMathType(), vals, null, null, null);
    }

    protected abstract float[] getFloats(PrimitiveVector var1, boolean var2);
}

