/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import visad.AnimationControl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.VisADException;
import visad.data.amanda.AmandaFile;
import visad.data.amanda.BaseTrack;
import visad.data.amanda.EventWidget;
import visad.data.amanda.F2000Util;
import visad.data.amanda.HistogramWidget;
import visad.data.amanda.Hit;
import visad.java3d.DisplayImplJ3D;
import visad.util.AnimationWidget;
import visad.util.CmdlineConsumer;
import visad.util.CmdlineParser;
import visad.util.Util;

public class NuView
extends WindowAdapter
implements CmdlineConsumer {
    private static HashMap colorHash = new HashMap();
    private String fileName;
    private int displayDim;
    private Color trackColor;
    private DisplayImpl display;
    private DisplayImpl display2;

    public NuView(String[] args) throws RemoteException, VisADException {
        CmdlineParser cmdline = new CmdlineParser(this);
        if (!cmdline.processArgs(args)) {
            System.exit(1);
            return;
        }
        AmandaFile file = NuView.openFile(this.fileName);
        this.display = new DisplayImplJ3D("amanda");
        JPanel widgetPanel = NuView.buildMainDisplay(this.display, file, this.trackColor);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.displayDim > screenSize.height) {
            this.displayDim = screenSize.height;
        }
        JPanel displayPanel = (JPanel)this.display.getComponent();
        Dimension dim = new Dimension(this.displayDim, this.displayDim);
        displayPanel.setPreferredSize(dim);
        displayPanel.setMinimumSize(dim);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(widgetPanel);
        panel.add(displayPanel);
        JFrame frame = new JFrame("VisAD AMANDA Viewer");
        frame.addWindowListener(this);
        frame.getContentPane().add(panel);
        frame.pack();
        panel.invalidate();
        Dimension fSize = frame.getSize();
        frame.setLocation((screenSize.width - fSize.width) / 2, (screenSize.height - fSize.height) / 2);
        frame.setVisible(true);
    }

    private static final Component buildHelp() {
        String text = "To rotate, hold down the left mouse button and move the mouse in the right-hand display window\n\nTo zoom, move the mouse while holding down the left mouse button and Shift key\n\nTo pan, move the mouse while holding down the left mouse button and Control key";
        JTextArea textArea = new JTextArea(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        return textArea;
    }

    private static final JPanel buildMainDisplay(DisplayImpl dpy, AmandaFile file, Color trackColor) throws RemoteException, VisADException {
        AnimationWidget animWidget;
        double halfRange = NuView.getMaxRange(file) / 2.0;
        ScalarMap xMap = new ScalarMap(RealType.XAxis, Display.XAxis);
        NuView.setRange(xMap, file.getXMin(), file.getXMax(), halfRange);
        dpy.addMap(xMap);
        ScalarMap yMap = new ScalarMap(RealType.YAxis, Display.YAxis);
        NuView.setRange(yMap, file.getYMin(), file.getYMax(), halfRange);
        dpy.addMap(yMap);
        ScalarMap zMap = new ScalarMap(RealType.ZAxis, Display.ZAxis);
        NuView.setRange(zMap, file.getZMin(), file.getZMax(), halfRange);
        dpy.addMap(zMap);
        ScalarMap shapeMap = new ScalarMap(Hit.amplitudeType, Display.Shape);
        dpy.addMap(shapeMap);
        ScalarMap trackMap = new ScalarMap(BaseTrack.indexType, Display.SelectValue);
        dpy.addMap(trackMap);
        ShapeControl sctl = (ShapeControl)shapeMap.getControl();
        sctl.setShapeSet(new Integer1DSet((MathType)Hit.amplitudeType, 1));
        sctl.setShapes(F2000Util.getCubeArray());
        ScalarMap shapeScaleMap = new ScalarMap(Hit.amplitudeType, Display.ShapeScale);
        dpy.addMap(shapeScaleMap);
        shapeScaleMap.setRange(-20.0, 50.0);
        ScalarMap colorMap = new ScalarMap(Hit.leadingEdgeTimeType, Display.RGB);
        dpy.addMap(colorMap);
        F2000Util.invertColorTable(colorMap);
        ScalarMap animMap = new ScalarMap(RealType.Time, Display.Animation);
        dpy.addMap(animMap);
        DisplayRenderer dpyRenderer = dpy.getDisplayRenderer();
        dpyRenderer.setBoxOn(false);
        dpyRenderer.setBackgroundColor(Color.white);
        dpyRenderer.setForegroundColor(Color.black);
        DataReferenceImpl eventRef = new DataReferenceImpl("event");
        dpy.addReference(eventRef);
        DataReferenceImpl trackRef = new DataReferenceImpl("track");
        dpy.addReference(trackRef, Util.getColorMaps(trackColor));
        DataReferenceImpl modulesRef = new DataReferenceImpl("modules");
        modulesRef.setData(file.makeModuleData());
        dpy.addReference(modulesRef, Util.getColorMaps(Color.black));
        AnimationControl animCtl = (AnimationControl)((Object)animMap.getControl());
        HistogramWidget histoWidget = new HistogramWidget(colorMap);
        EventWidget eventWidget = new EventWidget(file, eventRef, trackRef, animCtl, trackMap, histoWidget);
        Component helpText = NuView.buildHelp();
        try {
            animWidget = new AnimationWidget(animMap);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            animWidget = null;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setMaximumSize(new Dimension(400, 600));
        panel.add((Component)eventWidget, "North");
        if (animWidget != null) {
            panel.add((Component)animWidget, "Center");
        }
        panel.add(helpText, "South");
        return panel;
    }

    private static final Component buildText(String text) {
        JTextArea textArea = new JTextArea(text);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        return textArea;
    }

    @Override
    public int checkKeyword(String mainName, int thisArg, String[] args) {
        if (this.fileName == null) {
            this.fileName = args[thisArg];
            return 1;
        }
        return 0;
    }

    @Override
    public int checkOption(String mainName, char ch, String arg) {
        if (ch == 'd') {
            int tmpDim;
            try {
                tmpDim = Integer.parseInt(arg);
            }
            catch (NumberFormatException nfe) {
                System.err.println(mainName + ": Bad display dimension \"" + arg + "\"");
                return -1;
            }
            this.displayDim = tmpDim;
            return 2;
        }
        if (ch == 't') {
            String lName = arg.toLowerCase();
            if (!colorHash.containsKey(lName)) {
                System.err.println(mainName + ": Unknown color \"" + arg + "\". Valid colors are:");
                Iterator iter = colorHash.keySet().iterator();
                while (iter.hasNext()) {
                    System.err.println("  " + iter.next());
                }
                return -1;
            }
            this.trackColor = (Color)colorHash.get(lName);
            return 2;
        }
        return 0;
    }

    @Override
    public boolean finalizeArgs(String mainName) {
        if (this.fileName == null) {
            System.err.println(mainName + ": No file specified!");
            return false;
        }
        return true;
    }

    private static final double getMaxRange(AmandaFile file) {
        double xRange = file.getXMax() - file.getXMin();
        double yRange = file.getYMax() - file.getYMin();
        double zRange = file.getZMax() - file.getZMin();
        return -0.5 * Math.max(xRange, Math.max(yRange, zRange));
    }

    @Override
    public void initializeArgs() {
        this.displayDim = 800;
        this.fileName = null;
        this.trackColor = Color.darkGray;
    }

    @Override
    public String keywordUsage() {
        return " fileName";
    }

    private static final AmandaFile openFile(String fileName) throws VisADException {
        AmandaFile file;
        try {
            file = fileName.startsWith("http://") ? new AmandaFile(new URL(fileName)) : new AmandaFile(fileName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new VisADException(ioe.getMessage());
        }
        return file;
    }

    @Override
    public String optionUsage() {
        return " [-d displayDim] [-t trackColor]";
    }

    private static final void setRange(ScalarMap map, double min, double max, double halfRange) throws RemoteException, VisADException {
        double mid = (min + max) / 2.0;
        map.setRange(mid - halfRange, mid + halfRange);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        try {
            this.display.destroy();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.display2.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public static void main(String[] args) throws RemoteException, VisADException {
        new NuView(args);
    }

    static {
        colorHash.put("black", Color.black);
        colorHash.put("blue", Color.blue);
        colorHash.put("cyan", Color.cyan);
        colorHash.put("darkGray", Color.darkGray);
        colorHash.put("gray", Color.gray);
        colorHash.put("green", Color.green);
        colorHash.put("lightGray", Color.lightGray);
        colorHash.put("magenta", Color.magenta);
        colorHash.put("orange", Color.orange);
        colorHash.put("pink", Color.pink);
        colorHash.put("red", Color.red);
        colorHash.put("white", Color.white);
        colorHash.put("yellow", Color.yellow);
    }
}

