/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FormFamily;
import visad.data.FormFileInformer;
import visad.data.FormNode;

public class FunctionFormFamily
extends FormFamily {
    public FunctionFormFamily(String name) {
        super(name);
    }

    @Override
    public synchronized void save(String id, Data data, boolean replace) throws BadFormException, RemoteException, IOException, VisADException {
        SaveForm s = new SaveForm(id, data, replace);
        if (!s.run()) {
            throw new BadFormException("Data object not compatible with \"" + this.getName() + "\" data family");
        }
    }

    @Override
    public synchronized void add(String id, Data data, boolean replace) throws BadFormException {
        AddForm a = new AddForm(id, data, replace);
        try {
            if (a.run()) {
                return;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        throw new BadFormException("Data object not compatible with \"" + this.getName() + "\" data family");
    }

    @Override
    public synchronized DataImpl open(String id) throws BadFormException, VisADException {
        URL url;
        if (id == null) {
            return null;
        }
        try {
            url = new URL(id);
        }
        catch (MalformedURLException mue) {
            url = null;
        }
        DataImpl data = null;
        if (url != null) {
            OpenURLForm u = new OpenURLForm(url);
            try {
                data = !u.run() ? null : u.getData();
            }
            catch (Exception e) {
                data = null;
            }
        }
        String file = null;
        if (data == null) {
            if (url == null) {
                file = id;
            } else if (url.getProtocol() == "file" && (file = url.getFile()).length() > 2 && file.charAt(2) == ':' && file.charAt(0) == '/') {
                file = file.substring(1);
            }
        }
        if (file != null) {
            OpenStringForm o = new OpenStringForm(file);
            try {
                data = !o.run() ? null : o.getData();
            }
            catch (IOException ioe) {
                data = null;
            }
        }
        if (data == null) {
            if (file != null && !new File(file).exists()) {
                throw new BadFormException("No such data object \"" + id + "\"");
            }
            throw new BadFormException("Data object \"" + id + "\" not compatible with \"" + this.getName() + "\" data family");
        }
        return data;
    }

    @Override
    public synchronized DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        OpenURLForm o = new OpenURLForm(url);
        if (!o.run()) {
            throw new BadFormException("Data object \"" + url + "\" not compatible with \"" + this.getName() + "\" data family");
        }
        return o.getData();
    }

    class OpenURLForm
    extends URLFunction {
        private DataImpl data;

        public OpenURLForm(URL url) {
            this.url = url;
            this.data = null;
        }

        @Override
        boolean function(FormNode node) {
            try {
                this.data = node.open(this.url);
            }
            catch (Throwable t) {
                return false;
            }
            return true;
        }

        public DataImpl getData() {
            return this.data;
        }
    }

    abstract class URLFunction
    extends FormFunction {
        URL url;

        public URLFunction() {
            this.url = null;
        }

        @Override
        boolean check(FormFileInformer node) {
            return node.isThisType(this.url.getFile()) || node.isThisType(this.url.toString());
        }

        @Override
        InputStream getStream() throws IOException {
            return this.url.openStream();
        }
    }

    class OpenStringForm
    extends FileFunction {
        private DataImpl data;

        public OpenStringForm(String name) {
            this.name = name;
            this.data = null;
        }

        @Override
        boolean function(FormNode node) {
            try {
                this.data = node.open(this.name);
            }
            catch (OutOfMemoryError t) {
                throw t;
            }
            catch (Throwable t) {
                return false;
            }
            return true;
        }

        public DataImpl getData() {
            return this.data;
        }
    }

    class AddForm
    extends FileFunction {
        private Data data;
        private boolean replace;

        public AddForm(String name, Data data, boolean replace) {
            this.name = name;
            this.data = data;
            this.replace = replace;
        }

        @Override
        boolean function(FormNode node) {
            try {
                node.add(this.name, this.data, this.replace);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    class SaveForm
    extends FileFunction {
        private Data data;
        private boolean replace;

        public SaveForm(String name, Data data, boolean replace) {
            this.name = name;
            this.data = data;
            this.replace = replace;
        }

        @Override
        boolean function(FormNode node) {
            try {
                node.save(this.name, this.data, this.replace);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        @Override
        InputStream getStream() throws IOException {
            FileInputStream stream;
            try {
                stream = new FileInputStream(this.name);
            }
            catch (FileNotFoundException fnfe) {
                stream = null;
            }
            return stream;
        }
    }

    abstract class FileFunction
    extends FormFunction {
        String name;

        public FileFunction() {
            this.name = null;
        }

        @Override
        boolean check(FormFileInformer node) {
            return node.isThisType(this.name);
        }

        @Override
        InputStream getStream() throws IOException {
            return new FileInputStream(this.name);
        }
    }

    abstract class FormFunction {
        FormFunction() {
        }

        abstract boolean check(FormFileInformer var1);

        abstract InputStream getStream() throws IOException;

        abstract boolean function(FormNode var1);

        public boolean run() throws IOException {
            FormNode node;
            Enumeration en;
            Enumeration en2 = FunctionFormFamily.this.forms.elements();
            while (en2.hasMoreElements()) {
                FormNode node2 = (FormNode)en2.nextElement();
                if (!(node2 instanceof FormFileInformer)) continue;
                try {
                    if (!this.check((FormFileInformer)((Object)node2)) || !this.function(node2)) continue;
                    return true;
                }
                catch (Exception e) {
                }
                catch (Error e) {
                }
            }
            byte[] block = new byte[2048];
            InputStream is = this.getStream();
            if (is != null) {
                is.read(block);
                is.close();
                en = FunctionFormFamily.this.forms.elements();
                while (en.hasMoreElements()) {
                    node = (FormNode)en.nextElement();
                    if (!(node instanceof FormFileInformer)) continue;
                    try {
                        if (!((FormFileInformer)((Object)node)).isThisType(block) || !this.function(node)) continue;
                        return true;
                    }
                    catch (Exception e) {
                    }
                    catch (Error e) {
                    }
                }
            }
            en = FunctionFormFamily.this.forms.elements();
            while (en.hasMoreElements()) {
                node = (FormNode)en.nextElement();
                try {
                    if (!this.function(node)) continue;
                    return true;
                }
                catch (Exception e) {
                }
                catch (UnsatisfiedLinkError ule) {
                }
            }
            return false;
        }
    }
}

