/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import visad.data.BadRepositoryException;
import visad.data.Repository;

public class DirectoryRepository
extends Repository {
    protected File dir;
    protected String dirString;

    public DirectoryRepository(String name, String location) throws BadRepositoryException, IOException {
        super(name, location);
        try {
            this.dir = new File(this.getLocation());
        }
        catch (NullPointerException e) {
            throw new BadRepositoryException("Null repository name");
        }
        this.dirString = "\"" + this.getName() + "\" (path \"" + this.getLocation() + "\")";
        if (!this.dir.isDirectory()) {
            throw new BadRepositoryException("Repository " + this.dirString + " is not a directory");
        }
        if (!this.dir.canRead()) {
            throw new BadRepositoryException("Repository " + this.dirString + " is not readable");
        }
    }

    @Override
    public Enumeration getEnumeration() throws BadRepositoryException, SecurityException {
        return new Enumerator();
    }

    @Override
    protected String fullName(String id) {
        return this.getLocation() + File.separator + id;
    }

    public static void main(String[] args) throws BadRepositoryException, IOException {
        DirectoryRepository dir = new DirectoryRepository("Test", ".");
        Enumeration en = dir.getEnumeration();
        while (en.hasMoreElements()) {
            System.out.println((String)en.nextElement());
        }
        System.out.println("dir.fullName(\"foo.bar\") = " + dir.fullName("foo.bar"));
    }

    public class Enumerator
    implements Enumeration {
        protected int i;
        protected final String[] list;

        protected Enumerator() throws SecurityException {
            this.list = DirectoryRepository.this.dir.list();
            this.i = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.i < this.list.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.i == this.list.length) {
                throw new NoSuchElementException();
            }
            return this.list[this.i++];
        }
    }
}

