/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import visad.RemoteReferenceLink;
import visad.VisADException;
import visad.collab.MonitorEvent;

public class ReferenceMonitorEvent
extends MonitorEvent {
    private RemoteReferenceLink link;

    public ReferenceMonitorEvent(int type, RemoteReferenceLink link) throws VisADException {
        this(type, -1, link);
    }

    public ReferenceMonitorEvent(int type, int originator, RemoteReferenceLink link) throws VisADException {
        super(type, originator);
        if (type != 10 && type != 11) {
            throw new VisADException("Bad type for ReferenceMonitorEvent");
        }
        if (link == null) {
            throw new VisADException("Null link for ReferenceMonitorEvent");
        }
        this.link = link;
    }

    @Override
    public String getKey() {
        return this.link.toString();
    }

    public RemoteReferenceLink getLink() {
        return this.link;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReferenceMonitorEvent)) {
            return false;
        }
        ReferenceMonitorEvent evt = (ReferenceMonitorEvent)o;
        if (this.getType() != evt.getType()) {
            return false;
        }
        return this.link.equals(evt.link);
    }

    @Override
    public Object clone() {
        ReferenceMonitorEvent evt;
        try {
            evt = new ReferenceMonitorEvent(this.getType(), this.getOriginator(), this.link);
            evt.seqNum = this.seqNum;
        }
        catch (VisADException e) {
            evt = null;
        }
        return evt;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("ReferenceMonitorEvent[");
        buf.append('#');
        buf.append(this.getSequenceNumber());
        buf.append(' ');
        buf.append(this.getTypeName());
        int orig = this.getOriginator();
        if (orig == -1) {
            buf.append(" Lcl ");
        } else {
            buf.append(" Rmt ");
            buf.append(orig);
        }
        buf.append(' ');
        buf.append(this.link);
        buf.append(']');
        return buf.toString();
    }
}

