/*
 * Decompiled with CFR 0.152.
 */
package visad.collab;

import java.rmi.RemoteException;
import visad.FieldImpl;
import visad.MessageEvent;
import visad.RemoteData;
import visad.RemoteFieldImpl;
import visad.VisADException;
import visad.collab.MonitorEvent;

public class MessageMonitorEvent
extends MonitorEvent {
    private int id;
    private String str;
    private RemoteData data;

    public MessageMonitorEvent(MessageEvent msg) throws RemoteException, VisADException {
        this(22, -1, msg);
    }

    public MessageMonitorEvent(int type, MessageEvent msg) throws RemoteException, VisADException {
        this(type, -1, msg);
    }

    public MessageMonitorEvent(int type, int originator, MessageEvent msg) throws RemoteException, VisADException {
        super(type, originator);
        if (type != 22) {
            throw new VisADException("Bad type for MessageMonitorEvent");
        }
        this.id = msg.getId();
        this.str = msg.getString();
        RemoteData data = msg.getData();
        if (data == null) {
            this.data = null;
        } else if (data instanceof RemoteData) {
            this.data = data;
        } else if (data instanceof FieldImpl) {
            this.data = new RemoteFieldImpl((FieldImpl)((Object)data));
        } else {
            throw new VisADException("Don't know how to make " + data.getClass().getName() + " remote!");
        }
    }

    @Override
    public String getKey() {
        return Integer.toString(this.id) + this.str + (this.data == null ? "null" : this.data.toString());
    }

    public MessageEvent getMessage() {
        return new MessageEvent(this.id, this.getOriginator(), this.str, this.data);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MessageMonitorEvent)) {
            return false;
        }
        MessageMonitorEvent evt = (MessageMonitorEvent)o;
        if (this.getType() != evt.getType()) {
            return false;
        }
        if (this.id != evt.id) {
            return false;
        }
        if (this.str == null) {
            if (evt.str != null) {
                return false;
            }
        } else {
            if (evt.str == null) {
                return false;
            }
            if (!this.str.equals(evt.str)) {
                return false;
            }
        }
        if (this.data == null) {
            if (evt.data != null) {
                return false;
            }
        } else {
            if (evt.data == null) {
                return false;
            }
            if (!this.data.equals(evt.data)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object clone() {
        Object evt = null;
        return evt;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("MessageMonitorEvent[");
        buf.append('#');
        buf.append(this.getSequenceNumber());
        buf.append(' ');
        buf.append(this.getTypeName());
        int orig = this.getOriginator();
        if (orig == -1) {
            buf.append(" Lcl");
        } else {
            buf.append(" Rmt ");
            buf.append(orig);
        }
        buf.append(' ');
        buf.append(this.id);
        buf.append(' ');
        buf.append(this.str);
        if (this.data == null) {
            buf.append(" <null>");
        } else {
            buf.append(' ');
            buf.append(this.data.toString());
        }
        buf.append(']');
        return buf.toString();
    }
}

