/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import visad.ConstantMap;
import visad.Control;
import visad.DataShadow;
import visad.DisplayException;
import visad.ScalarMap;
import visad.VisADException;
import visad.cluster.DefaultNodeRendererAgent;
import visad.cluster.RemoteAgentContact;
import visad.cluster.RemoteClientAgentImpl;
import visad.cluster.RemoteClientData;
import visad.cluster.RemoteClientDataImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeData;
import visad.cluster.RemoteProxyAgent;

public class RemoteProxyAgentImpl
extends UnicastRemoteObject
implements RemoteProxyAgent {
    private RemoteClientDataImpl rcdi = null;
    private boolean sent_node_agents = false;
    private RemoteClientAgentImpl[] agents = null;
    private RemoteClientAgentImpl focus_agent = null;
    private RemoteAgentContact[] contacts = null;
    private int[] resolutions = null;
    private ConstantMap[] cmaps = null;
    private ScalarMap[] maps = null;
    private Control[] controls = null;

    public RemoteProxyAgentImpl(RemoteClientDataImpl r) throws RemoteException {
        this.rcdi = r;
    }

    @Override
    public RemoteClientData getRemoteClientData() throws RemoteException {
        return this.rcdi;
    }

    @Override
    public void setResolutions(int[] rs) {
        if (rs == null) {
            return;
        }
        int n = rs.length;
        this.resolutions = new int[n];
        for (int i = 0; i < n; ++i) {
            this.resolutions[i] = rs[i];
        }
    }

    @Override
    public Serializable[] prepareAction(boolean go, boolean initialize, DataShadow shadow, ConstantMap[] cms, ScalarMap[] ms, Control[] cos, String name, long time_out) throws VisADException, RemoteException {
        this.cmaps = cms;
        this.maps = ms;
        this.controls = cos;
        if (!this.sent_node_agents) {
            this.focus_agent = new RemoteClientAgentImpl(null, -1, time_out);
            RemoteClusterData[] jvmTable = this.rcdi.getTable();
            int nagents = jvmTable.length - 1;
            this.agents = new RemoteClientAgentImpl[nagents];
            this.contacts = new RemoteAgentContact[nagents];
            for (int i = 0; i < nagents; ++i) {
                this.agents[i] = new RemoteClientAgentImpl(this.focus_agent, i);
                DefaultNodeRendererAgent node_agent = new DefaultNodeRendererAgent(this.agents[i], name, this.cmaps);
                this.contacts[i] = ((RemoteNodeData)jvmTable[i]).sendAgent(node_agent);
            }
            this.sent_node_agents = true;
        }
        Vector<Cloneable> message = new Vector<Cloneable>();
        for (int i = 0; i < this.maps.length; ++i) {
            message.addElement(this.maps[i]);
            message.addElement(this.controls[i]);
        }
        Serializable[] responses = this.focus_agent.broadcastWithResponses(message, this.contacts);
        return responses;
    }

    @Override
    public Serializable[] doTransform() throws VisADException, RemoteException {
        int i;
        if (this.rcdi == null) {
            throw new DisplayException("Data is null");
        }
        int n = this.contacts.length;
        Serializable[] messages = new Vector[n];
        if (this.resolutions == null || this.resolutions.length != n) {
            this.resolutions = new int[n];
            for (i = 0; i < n; ++i) {
                this.resolutions[i] = 1;
            }
        }
        for (i = 0; i < n; ++i) {
            messages[i] = new Vector();
            ((Vector)messages[i]).addElement("transform");
            ((Vector)messages[i]).addElement(new Integer(this.resolutions[i]));
            int m = this.maps.length;
            for (int j = 0; j < m; ++j) {
                ((Vector)messages[i]).addElement(this.maps[j]);
            }
        }
        Serializable[] responses = this.focus_agent.broadcastWithResponses(messages, this.contacts);
        return responses;
    }

    @Override
    public Serializable[] computeRanges(Vector message) throws VisADException, RemoteException {
        Serializable[] responses = this.focus_agent.broadcastWithResponses(message, this.contacts);
        return responses;
    }
}

