/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.rmi.RemoteException;
import java.util.Enumeration;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataShadow;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.Function;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.Unit;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodePartitionedField;

public class RemoteNodePartitionedFieldImpl
extends RemoteNodeDataImpl
implements RemoteNodePartitionedField {
    private boolean flat;
    private FieldImpl adaptedField = null;
    private DataReferenceImpl adaptedFieldRef = null;
    private int length;

    public RemoteNodePartitionedFieldImpl(FunctionType type, Set set) throws VisADException, RemoteException {
        this(RemoteNodePartitionedFieldImpl.makeField(type, set));
    }

    public RemoteNodePartitionedFieldImpl(FieldImpl adapted) throws VisADException, RemoteException {
        this.adaptedField = adapted;
        this.flat = ((FunctionType)this.adaptedField.getType()).getFlat();
        this.adaptedFieldRef = new DataReferenceImpl("adaptedFieldRef");
        this.adaptedFieldRef.setData(this.adaptedField);
        CellImpl adaptedFieldCell = new CellImpl(){

            @Override
            public void doAction() throws VisADException, RemoteException {
                RemoteNodePartitionedFieldImpl.this.notifyReferences();
            }
        };
        adaptedFieldCell.addReference(this.adaptedFieldRef);
        this.length = this.adaptedField.getLength();
    }

    private static FieldImpl makeField(FunctionType type, Set set) throws VisADException, RemoteException {
        if (type == null) {
            throw new ClusterException("type cannot be null");
        }
        if (set == null) {
            throw new ClusterException("set cannot be null");
        }
        if (type.getFlat()) {
            return new FlatField(type, set);
        }
        return new FieldImpl(type, set);
    }

    public FieldImpl getAdaptedField() {
        return this.adaptedField;
    }

    @Override
    public void setSamples(Data[] range, boolean copy) throws VisADException, RemoteException {
        this.adaptedField.setSamples(range, copy);
    }

    @Override
    public void setSamples(double[][] range) throws VisADException, RemoteException {
        this.adaptedField.setSamples(range);
    }

    @Override
    public void setSamples(float[][] range) throws VisADException, RemoteException {
        this.adaptedField.setSamples(range);
    }

    @Override
    public MathType getType() throws VisADException, RemoteException {
        return this.adaptedField.getType();
    }

    @Override
    public boolean isMissing() throws VisADException, RemoteException {
        return this.adaptedField.isMissing();
    }

    @Override
    public int getDomainDimension() throws VisADException, RemoteException {
        return this.adaptedField.getDomainDimension();
    }

    @Override
    public Set getDomainSet() throws VisADException, RemoteException {
        return this.adaptedField.getDomainSet();
    }

    @Override
    public int getLength() throws RemoteException {
        return this.length;
    }

    @Override
    public Unit[] getDomainUnits() throws VisADException, RemoteException {
        return this.adaptedField.getDomainUnits();
    }

    @Override
    public CoordinateSystem getDomainCoordinateSystem() throws VisADException, RemoteException {
        return this.adaptedField.getDomainCoordinateSystem();
    }

    @Override
    public Data getSample(int index) throws VisADException, RemoteException {
        return this.adaptedField.getSample(index);
    }

    @Override
    public void setSample(RealTuple domain, Data range, boolean copy) throws VisADException, RemoteException {
        this.adaptedField.setSample(domain, range, copy);
    }

    @Override
    public void setSample(RealTuple domain, Data range) throws VisADException, RemoteException {
        this.adaptedField.setSample(domain, range);
    }

    @Override
    public void setSample(int index, Data range, boolean copy) throws VisADException, RemoteException {
        this.adaptedField.setSample(index, range, copy);
    }

    @Override
    public void setSample(int index, Data range) throws VisADException, RemoteException {
        this.adaptedField.setSample(index, range);
    }

    @Override
    public Field extract(int component) throws VisADException, RemoteException {
        return this.adaptedField.extract(component);
    }

    @Override
    public Field domainMultiply() throws VisADException, RemoteException {
        return this.adaptedField.domainMultiply();
    }

    @Override
    public Field domainMultiply(int depth) throws VisADException, RemoteException {
        return this.adaptedField.domainMultiply(depth);
    }

    @Override
    public Field domainFactor(RealType factor) throws VisADException, RemoteException {
        return this.adaptedField.domainFactor(factor);
    }

    @Override
    public double[][] getValues() throws VisADException, RemoteException {
        return this.adaptedField.getValues();
    }

    @Override
    public double[][] getValues(boolean copy) throws VisADException, RemoteException {
        return this.adaptedField.getValues(copy);
    }

    @Override
    public float[][] getFloats() throws VisADException, RemoteException {
        return this.adaptedField.getFloats();
    }

    @Override
    public float[][] getFloats(boolean copy) throws VisADException, RemoteException {
        return this.adaptedField.getFloats(copy);
    }

    @Override
    public String[][] getStringValues() throws VisADException, RemoteException {
        return this.adaptedField.getStringValues();
    }

    @Override
    public Unit[] getDefaultRangeUnits() throws VisADException, RemoteException {
        return this.adaptedField.getDefaultRangeUnits();
    }

    @Override
    public Unit[][] getRangeUnits() throws VisADException, RemoteException {
        return this.adaptedField.getRangeUnits();
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem() throws VisADException, RemoteException {
        return this.adaptedField.getRangeCoordinateSystem();
    }

    @Override
    public CoordinateSystem[] getRangeCoordinateSystem(int i) throws VisADException, RemoteException {
        return this.adaptedField.getRangeCoordinateSystem(i);
    }

    @Override
    public boolean isFlatField() throws VisADException, RemoteException {
        return false;
    }

    @Override
    public Enumeration domainEnumeration() throws VisADException, RemoteException {
        return this.adaptedField.domainEnumeration();
    }

    @Override
    public Data evaluate(Real domain) throws VisADException, RemoteException {
        return this.adaptedField.evaluate(domain);
    }

    @Override
    public Data evaluate(Real domain, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.evaluate(domain, sampling_mode, error_mode);
    }

    @Override
    public Data evaluate(RealTuple domain) throws VisADException, RemoteException {
        return this.adaptedField.evaluate(domain);
    }

    @Override
    public Data evaluate(RealTuple domain, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.evaluate(domain, sampling_mode, error_mode);
    }

    @Override
    public Field resample(Set set) throws VisADException, RemoteException {
        return this.adaptedField.resample(set);
    }

    @Override
    public Field resample(Set set, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.resample(set, sampling_mode, error_mode);
    }

    @Override
    public Data derivative(RealTuple location, RealType[] d_partial_s, MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.derivative(location, d_partial_s, derivType_s, error_mode);
    }

    @Override
    public Data derivative(int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.derivative(error_mode);
    }

    @Override
    public Data derivative(MathType[] derivType_s, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.derivative(derivType_s, error_mode);
    }

    @Override
    public Function derivative(RealType d_partial, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.derivative(d_partial, error_mode);
    }

    @Override
    public Function derivative(RealType d_partial, MathType derivType, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.derivative(d_partial, derivType, error_mode);
    }

    @Override
    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        return this.adaptedField.computeRanges(type, shadow);
    }

    @Override
    public DataShadow computeRanges(ShadowType type, int n) throws VisADException, RemoteException {
        return this.adaptedField.computeRanges(type, n);
    }

    @Override
    public double[][] computeRanges(RealType[] reals) throws VisADException, RemoteException {
        return this.adaptedField.computeRanges(reals);
    }

    @Override
    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        return this.adaptedField.adjustSamplingError(error, error_mode);
    }

    @Override
    public String longString() throws VisADException, RemoteException {
        return this.longString("");
    }

    @Override
    public String longString(String pre) throws VisADException, RemoteException {
        return pre + "RemoteNodePartitionedFieldImpl";
    }
}

