/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AVControl;
import visad.ConstantMap;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.GraphicsModeControl;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.SetType;
import visad.ShadowType;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADSceneGraphObject;
import visad.VisADSwitch;
import visad.cluster.ClientDisplayRendererJ3D;
import visad.cluster.ClusterException;
import visad.cluster.DefaultNodeRendererAgent;
import visad.cluster.RemoteAgentContact;
import visad.cluster.RemoteClientAgentImpl;
import visad.cluster.RemoteClientDataImpl;
import visad.cluster.RemoteClusterData;
import visad.cluster.RemoteNodeData;
import visad.collab.CollabUtil;
import visad.java3d.AVControlJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.ShadowTypeJ3D;

public class ClientRendererJ3D
extends DefaultRendererJ3D {
    private DisplayImpl display = null;
    private ConstantMap[] cmaps = null;
    private DataDisplayLink link = null;
    private Data data = null;
    private boolean cluster = true;
    private RemoteClientAgentImpl[] agents = null;
    private RemoteClientAgentImpl focus_agent = null;
    private RemoteAgentContact[] contacts = null;
    private long time_out = 10000L;
    private int[] resolutions = null;
    private boolean enable_spatial = true;

    public ClientRendererJ3D() {
        this(10000L);
    }

    public ClientRendererJ3D(long to) {
        this.time_out = to;
    }

    public void setResolutions(int[] rs) {
        if (rs == null) {
            return;
        }
        int n = rs.length;
        this.resolutions = new int[n];
        for (int i = 0; i < n; ++i) {
            this.resolutions[i] = rs[i];
        }
    }

    @Override
    public DataShadow prepareAction(boolean go, boolean initialize, DataShadow shadow) throws VisADException, RemoteException {
        Data old_data = this.data;
        DataDisplayLink[] Links = this.getLinks();
        if (Links != null && Links.length > 0) {
            this.link = Links[0];
            if (this.cmaps == null) {
                this.display = this.getDisplay();
                Vector cvector = this.link.getConstantMaps();
                if (cvector != null && cvector.size() > 0) {
                    int clength = cvector.size();
                    this.cmaps = new ConstantMap[clength];
                    for (int i = 0; i < clength; ++i) {
                        this.cmaps[i] = (ConstantMap)cvector.elementAt(i);
                    }
                }
            }
            try {
                this.data = this.link.getData();
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return null;
                }
                throw re;
            }
            if (this.data == null) {
                this.addException(new DisplayException("Data is null: ClientRendererJ3D.doTransform"));
            }
            this.cluster = this.data instanceof RemoteClientDataImpl;
            if (this.cluster && this.data != old_data) {
                RemoteClientDataImpl rcdi = (RemoteClientDataImpl)this.data;
                this.focus_agent = new RemoteClientAgentImpl(null, -1, this.time_out);
                RemoteClusterData[] jvmTable = rcdi.getTable();
                int nagents = jvmTable.length - 1;
                this.agents = new RemoteClientAgentImpl[nagents];
                this.contacts = new RemoteAgentContact[nagents];
                for (int i = 0; i < nagents; ++i) {
                    this.agents[i] = new RemoteClientAgentImpl(this.focus_agent, i);
                    DefaultNodeRendererAgent node_agent = new DefaultNodeRendererAgent(this.agents[i], this.display.getName(), this.cmaps);
                    this.contacts[i] = ((RemoteNodeData)jvmTable[i]).sendAgent(node_agent);
                }
            }
        }
        Vector<Cloneable> message = new Vector<Cloneable>();
        Vector map_vector = this.display.getMapVector();
        Enumeration maps = map_vector.elements();
        while (maps.hasMoreElements()) {
            ScalarMap map = (ScalarMap)maps.nextElement();
            message.addElement(map);
            message.addElement(map.getControl());
        }
        Serializable[] responses = this.focus_agent.broadcastWithResponses(message, this.contacts);
        return super.prepareAction(go, initialize, shadow);
    }

    @Override
    public BranchGroup doTransform() throws VisADException, RemoteException {
        int i;
        if (this.link == null || this.data == null) {
            this.addException(new DisplayException("Data is null: ClientRendererJ3D.doTransform"));
        }
        if (!this.cluster) {
            return super.doTransform();
        }
        int n = this.contacts.length;
        Serializable[] messages = new Vector[n];
        if (this.resolutions == null || this.resolutions.length != n) {
            this.resolutions = new int[n];
            for (i = 0; i < n; ++i) {
                this.resolutions[i] = 1;
            }
        }
        for (i = 0; i < n; ++i) {
            messages[i] = new Vector();
            ((Vector)messages[i]).addElement("transform");
            ((Vector)messages[i]).addElement(new Integer(this.resolutions[i]));
            Vector map_vector = this.display.getMapVector();
            Enumeration maps = map_vector.elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                ((Vector)messages[i]).addElement(map);
            }
        }
        Serializable[] responses = this.focus_agent.broadcastWithResponses(messages, this.contacts);
        BranchGroup branch = new BranchGroup();
        branch.setCapability(17);
        branch.setCapability(12);
        branch.setCapability(13);
        branch.setCapability(14);
        n = responses.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (responses[i2] == null) continue;
            VisADSceneGraphObject vsgo = (VisADSceneGraphObject)responses[i2];
            branch.addChild(this.convertSceneGraph(vsgo));
        }
        if (n == 0) {
            ShadowTypeJ3D.ensureNotEmpty(branch, this.display);
        }
        return branch;
    }

    @Override
    public synchronized void setSpatialValues(float[][] spatial_values) {
        if (this.enable_spatial) {
            super.setSpatialValues(spatial_values);
        }
    }

    public Node convertSceneGraph(VisADSceneGraphObject scene) throws VisADException {
        if (scene instanceof VisADSwitch) {
            VisADSwitch Vswit = (VisADSwitch)scene;
            BranchGroup branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(12);
            branch.setCapability(13);
            branch.setCapability(14);
            Switch swit = new Switch();
            swit.setCapability(17);
            swit.setCapability(18);
            swit.setCapability(17);
            swit.setCapability(12);
            swit.setCapability(13);
            int n = Vswit.numChildren();
            Set set = Vswit.getSet();
            if (set != null) {
                for (int i = 0; i < n; ++i) {
                    VisADSceneGraphObject vsgo = Vswit.getChild(i);
                    swit.addChild(this.convertSceneGraph(vsgo));
                }
                RealType real = (RealType)((SetType)set.getType()).getDomain().getComponent(0);
                AVControl control = null;
                Vector mapVector = this.display.getMapVector();
                Enumeration maps = mapVector.elements();
                while (maps.hasMoreElements()) {
                    DisplayRealType dreal;
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    if (!real.equals(map.getScalar()) || !(dreal = map.getDisplayScalar()).equals(Display.Animation) && !dreal.equals(Display.SelectValue)) continue;
                    control = (AVControl)((Object)map.getControl());
                    break;
                }
                if (control == null) {
                    throw new ClusterException("AVControl is null");
                }
                ((AVControlJ3D)control).addPair(swit, set, this);
                ((AVControlJ3D)control).init();
            } else {
                if (Vswit.numChildren() != 3) {
                    throw new ClusterException("VisADSwitch for volume render must have 3 children");
                }
                VisADGroup VbranchX = (VisADGroup)((VisADSwitch)scene).getChild(0);
                VisADGroup VbranchY = (VisADGroup)((VisADSwitch)scene).getChild(1);
                VisADGroup VbranchZ = (VisADGroup)((VisADSwitch)scene).getChild(2);
                int nX = VbranchX.numChildren();
                OrderedGroup branchX = new OrderedGroup();
                branchX.setCapability(12);
                VisADAppearance[] appearanceX = new VisADAppearance[nX];
                for (int i = 0; i < nX; ++i) {
                    VisADAppearance appearance = (VisADAppearance)VbranchX.getChild(i);
                    branchX.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                }
                OrderedGroup branchXrev = new OrderedGroup();
                branchXrev.setCapability(12);
                for (int i = nX - 1; i >= 0; --i) {
                    VisADAppearance appearance = (VisADAppearance)VbranchX.getChild(i);
                    branchXrev.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                }
                int nY = VbranchY.numChildren();
                OrderedGroup branchY = new OrderedGroup();
                branchY.setCapability(12);
                VisADAppearance[] appearanceY = new VisADAppearance[nY];
                for (int i = 0; i < nY; ++i) {
                    VisADAppearance appearance = (VisADAppearance)VbranchY.getChild(i);
                    branchY.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                }
                OrderedGroup branchYrev = new OrderedGroup();
                branchYrev.setCapability(12);
                for (int i = nY - 1; i >= 0; --i) {
                    VisADAppearance appearance = (VisADAppearance)VbranchY.getChild(i);
                    branchYrev.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                }
                int nZ = VbranchZ.numChildren();
                OrderedGroup branchZ = new OrderedGroup();
                branchZ.setCapability(12);
                VisADAppearance[] appearanceZ = new VisADAppearance[nZ];
                for (int i = 0; i < nZ; ++i) {
                    VisADAppearance appearance = (VisADAppearance)VbranchZ.getChild(i);
                    branchZ.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                }
                OrderedGroup branchZrev = new OrderedGroup();
                branchZrev.setCapability(12);
                for (int i = nZ - 1; i >= 0; --i) {
                    VisADAppearance appearance = (VisADAppearance)VbranchZ.getChild(i);
                    branchZrev.addChild((Node)((Shape3D)this.convertSceneGraph(appearance)));
                }
                swit.addChild((Node)branchX);
                swit.addChild((Node)branchY);
                swit.addChild((Node)branchZ);
                swit.addChild((Node)branchXrev);
                swit.addChild((Node)branchYrev);
                swit.addChild((Node)branchZrev);
                ProjectionControlJ3D control = (ProjectionControlJ3D)this.display.getProjectionControl();
                control.addPair(swit, this);
            }
            branch.addChild((Node)swit);
            return branch;
        }
        if (scene instanceof VisADGroup) {
            VisADGroup group = (VisADGroup)scene;
            BranchGroup branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(12);
            branch.setCapability(13);
            branch.setCapability(14);
            int n = group.numChildren();
            for (int i = 0; i < n; ++i) {
                VisADSceneGraphObject vsgo = group.getChild(i);
                branch.addChild(this.convertSceneGraph(vsgo));
            }
            ShadowTypeJ3D.ensureNotEmpty(branch, this.display);
            return branch;
        }
        if (scene instanceof VisADAppearance) {
            VisADAppearance appearance = (VisADAppearance)scene;
            GraphicsModeControl mode = this.display.getGraphicsModeControl();
            VisADGeometryArray vga = appearance.array;
            GeometryArray array = ((DisplayImplJ3D)this.display).makeGeometry(vga);
            if (array == null) {
                return null;
            }
            BufferedImage image = null;
            if (appearance.image_pixels != null) {
                image = new BufferedImage(appearance.image_width, appearance.image_height, appearance.image_type);
                image.setRGB(0, 0, appearance.image_width, appearance.image_height, appearance.image_pixels, 0, appearance.image_width);
            }
            if (image != null) {
                Appearance appearance_j3d = this.makeTextureAppearance(appearance, mode, array);
                TextureAttributes texture_attributes = new TextureAttributes();
                texture_attributes.setTextureMode(2);
                texture_attributes.setPerspectiveCorrectionMode(1);
                appearance_j3d.setTextureAttributes(texture_attributes);
                int transparencyMode = mode.getTransparencyMode();
                Texture2D texture = new Texture2D(1, 6, appearance.texture_width, appearance.texture_height);
                texture.setCapability(4);
                ImageComponent2D image2d = new ImageComponent2D(2, image);
                image2d.setCapability(2);
                texture.setImage(0, (ImageComponent)image2d);
                if (transparencyMode == 0) {
                    texture.setMinFilter(2);
                    texture.setMagFilter(2);
                } else {
                    texture.setBoundaryModeS(2);
                    texture.setBoundaryModeT(2);
                    texture.setMinFilter(3);
                    texture.setMagFilter(3);
                }
                texture.setEnable(true);
                appearance_j3d.setTexture((Texture)texture);
                appearance_j3d.setCapability(2);
                Shape3D shape = new Shape3D((Geometry)array, appearance_j3d);
                shape.setCapability(14);
                return shape;
            }
            Appearance appearance_j3d = this.makeAppearance(appearance, mode, array);
            Shape3D shape = new Shape3D((Geometry)array, appearance_j3d);
            return shape;
        }
        throw new VisADException("unknown scene " + scene);
    }

    private Appearance makeTextureAppearance(VisADAppearance appearance, GraphicsModeControl mode, GeometryArray array) {
        TransparencyAttributes c_alpha = null;
        if (appearance.alpha == 1.0f) {
            c_alpha = null;
        } else if (appearance.alpha == appearance.alpha) {
            c_alpha = new TransparencyAttributes(2, appearance.alpha);
        } else {
            c_alpha = new TransparencyAttributes();
            c_alpha.setTransparencyMode(2);
        }
        ColoringAttributes c_color = null;
        if (appearance.red == appearance.red && appearance.green == appearance.green && appearance.blue == appearance.blue) {
            c_color = new ColoringAttributes();
            c_color.setColor(appearance.red, appearance.green, appearance.blue);
        }
        return ShadowTypeJ3D.staticMakeAppearance(mode, c_alpha, null, array, false);
    }

    private Appearance makeAppearance(VisADAppearance appearance, GraphicsModeControl mode, GeometryArray array) {
        TransparencyAttributes c_alpha = null;
        c_alpha = appearance.alpha == 1.0f ? new TransparencyAttributes(4, 0.0f) : (appearance.alpha == appearance.alpha ? new TransparencyAttributes(mode.getTransparencyMode(), appearance.alpha) : new TransparencyAttributes(mode.getTransparencyMode(), 0.0f));
        ColoringAttributes c_color = null;
        if (appearance.red == appearance.red && appearance.green == appearance.green && appearance.blue == appearance.blue) {
            c_color = new ColoringAttributes();
            c_color.setColor(appearance.red, appearance.green, appearance.blue);
        }
        return ShadowTypeJ3D.staticMakeAppearance(mode, c_alpha, c_color, array, false);
    }

    @Override
    public DataShadow computeRanges(Data data, ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        if (!this.cluster) {
            return super.computeRanges(data, type, shadow);
        }
        Object shadows = null;
        Vector<Serializable> message = new Vector<Serializable>();
        message.addElement(type);
        if (shadow == null) {
            message.addElement(new Integer(this.getDisplay().getScalarCount()));
        } else {
            message.addElement(shadow);
        }
        Serializable[] responses = this.focus_agent.broadcastWithResponses(message, this.contacts);
        DataShadow new_shadow = null;
        int n = responses.length;
        for (int i = 0; i < n; ++i) {
            if (responses[i] == null) continue;
            if (new_shadow == null) {
                new_shadow = (DataShadow)responses[i];
                continue;
            }
            new_shadow.merge((DataShadow)responses[i]);
        }
        return new_shadow;
    }

    @Override
    public Object clone() {
        return new ClientRendererJ3D(this.time_out);
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        DisplayImplJ3D display = new DisplayImplJ3D("display", (DisplayRendererJ3D)new ClientDisplayRendererJ3D());
        JFrame frame = new JFrame("test ClientRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

