/*
 * Decompiled with CFR 0.152.
 */
package visad.bom.annotations;

import java.awt.Image;
import java.awt.Toolkit;
import visad.DisplayImpl;
import visad.VisADException;
import visad.bom.annotations.ScreenAnnotation;
import visad.bom.annotations.ScreenAnnotatorUtils;
import visad.java3d.DisplayImplJ3D;
import visad.util.ImageHelper;

public class ImageJ3D
implements ScreenAnnotation {
    public static final int TOP_LEFT = 20;
    public static final int TOP_RIGHT = 21;
    public static final int BOTTOM_RIGHT = 22;
    public static final int BOTTOM_LEFT = 23;
    public static final int CENTER = 24;
    private Image image;
    private int position;
    private int x;
    private int y;
    private int width = -1;
    private int height = -1;
    private double zValue;
    private double scaleFactor;

    public ImageJ3D(String filename, int position, int x, int y, double zValue, double scaleFactor) throws VisADException {
        this(Toolkit.getDefaultToolkit().getImage(filename), position, x, y, zValue, scaleFactor);
    }

    public ImageJ3D(Image image, int position, int x, int y, double zValue, double scaleFactor) throws VisADException {
        this.position = position;
        this.x = x;
        this.y = y;
        this.zValue = zValue;
        this.scaleFactor = scaleFactor;
        this.setImage(image);
    }

    public void setImage(Image image) throws VisADException {
        this.image = image;
        ImageHelper ih = new ImageHelper();
        while (true) {
            if (this.width < 0) {
                this.width = image.getWidth(ih);
            }
            if (this.height < 0) {
                this.height = image.getHeight(ih);
            }
            if (ih.badImage || this.width >= 0 && this.height >= 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new VisADException("ImageJ3D: Interrupted!!");
            }
        }
        if (ih.badImage) {
            throw new VisADException("ImageJ3D: not an image");
        }
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public void setImageJ3Ds(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setZValue(double zValue) {
        this.zValue = zValue;
    }

    @Override
    public Object toDrawable(DisplayImpl display) throws VisADException {
        return ScreenAnnotatorUtils.makeImageShape3D((DisplayImplJ3D)display, this.image, this.position, this.x, this.y, this.width, this.height, this.zValue, this.scaleFactor);
    }
}

