/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.BadDirectManipulationException;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public class PointManipulationRendererJ3D
extends DirectManipulationRendererJ3D {
    private RealType x = null;
    private RealType y = null;
    private RealTupleType xy = null;
    private int mouseModifiersMask = 0;
    private int mouseModifiersValue = 0;
    private BranchGroup branch = null;
    private BranchGroup group = null;
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private transient ScalarMap xmap = null;
    private transient ScalarMap ymap = null;
    float[] default_values;
    private float[] f = new float[1];
    private float[] d = new float[1];
    private String whyNotDirect = null;
    private int directManifoldDimension = 2;
    private DisplayTupleType tuple;
    private CoordinateSystem tuplecs;
    private int xindex = -1;
    private int yindex = -1;
    private int otherindex = -1;
    private float othervalue;
    private float[][] first_x;
    private static final String xandyNotMatch = "x and y spatial domains don't match";
    private static final String xandyNotSpatial = "x and y must be mapped to spatial";
    private static final int N = 64;

    public PointManipulationRendererJ3D(RealType xarg, RealType yarg) {
        this(xarg, yarg, 0, 0);
    }

    public PointManipulationRendererJ3D(RealType xarg, RealType yarg, int mmm, int mmv) {
        this.x = xarg;
        this.y = yarg;
        this.mouseModifiersMask = mmm;
        this.mouseModifiersValue = mmv;
    }

    @Override
    public synchronized BranchGroup doTransform() throws VisADException, RemoteException {
        this.branch = new BranchGroup();
        this.branch.setCapability(17);
        this.branch.setCapability(12);
        this.branch.setCapability(13);
        this.branch.setCapability(14);
        if (!this.getIsDirectManipulation()) {
            throw new BadDirectManipulationException(this.getWhyNotDirect() + ": DirectManipulationRendererJ3D.doTransform");
        }
        this.setBranch(this.branch);
        return this.branch;
    }

    @Override
    public void checkDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DisplayImpl display = this.getDisplay();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            this.link = null;
            return;
        }
        this.link = Links[0];
        this.ref = this.link.getDataReference();
        this.default_values = this.link.getDefaultValues();
        this.xmap = null;
        this.ymap = null;
        Vector scalar_map_vector = display.getMapVector();
        Enumeration en = scalar_map_vector.elements();
        while (en.hasMoreElements()) {
            DisplayRealType dreal;
            DisplayTupleType t;
            ScalarMap map = (ScalarMap)en.nextElement();
            ScalarType real = map.getScalar();
            if (real.equals(this.x) && (t = (dreal = map.getDisplayScalar()).getTuple()) != null && (t.equals(Display.DisplaySpatialCartesianTuple) || t.getCoordinateSystem() != null && t.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.xmap = map;
                this.xindex = dreal.getTupleIndex();
                if (this.tuple == null) {
                    this.tuple = t;
                } else if (!t.equals(this.tuple)) {
                    this.whyNotDirect = xandyNotMatch;
                    return;
                }
            }
            if (!real.equals(this.y) || (t = (dreal = map.getDisplayScalar()).getTuple()) == null || !t.equals(Display.DisplaySpatialCartesianTuple) && (t.getCoordinateSystem() == null || !t.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            this.ymap = map;
            this.yindex = dreal.getTupleIndex();
            if (this.tuple == null) {
                this.tuple = t;
                continue;
            }
            if (t.equals(this.tuple)) continue;
            this.whyNotDirect = xandyNotMatch;
            return;
        }
        if (this.xmap == null || this.ymap == null) {
            this.whyNotDirect = xandyNotSpatial;
            return;
        }
        this.xy = new RealTupleType(this.x, this.y);
        this.otherindex = 3 - (this.xindex + this.yindex);
        DisplayRealType dreal = (DisplayRealType)this.tuple.getComponent(this.otherindex);
        int index = this.getDisplay().getDisplayScalarIndex(dreal);
        float f = this.othervalue = index > 0 ? this.default_values[index] : (float)dreal.getDefaultValue();
        if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
            this.tuple = null;
            this.tuplecs = null;
        } else {
            this.tuplecs = this.tuple.getCoordinateSystem();
        }
        this.directManifoldDimension = 2;
        this.setIsDirectManipulation(true);
    }

    @Override
    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    @Override
    public void addPoint(float[] x) throws VisADException {
    }

    @Override
    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.tuplecs;
    }

    @Override
    public synchronized void setSpatialValues(float[][] spatial_values) {
    }

    @Override
    public synchronized float checkClose(double[] origin, double[] direction) {
        int mouseModifiers = this.getLastMouseModifiers();
        if ((mouseModifiers & this.mouseModifiersMask) != this.mouseModifiersValue) {
            return Float.MAX_VALUE;
        }
        try {
            float r = this.findRayManifoldIntersection(true, origin, direction, this.tuple, this.otherindex, this.othervalue);
            if (r == r) {
                return 0.0f;
            }
            return Float.MAX_VALUE;
        }
        catch (VisADException ex) {
            return Float.MAX_VALUE;
        }
    }

    @Override
    public void stop_direct() {
    }

    @Override
    public synchronized void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
        if (this.ref == null) {
            return;
        }
        if (!first) {
            return;
        }
        double[] origin = ray.position;
        double[] direction = ray.vector;
        try {
            float r = this.findRayManifoldIntersection(true, origin, direction, this.tuple, this.otherindex, this.othervalue);
            if (r != r) {
                if (this.group != null) {
                    this.group.detach();
                }
                return;
            }
            Object xx = new float[][]{{(float)(origin[0] + (double)r * direction[0])}, {(float)(origin[1] + (double)r * direction[1])}, {(float)(origin[2] + (double)r * direction[2])}};
            if (this.tuple != null) {
                xx = this.tuplecs.fromReference((float[][])xx);
            }
            this.first_x = xx;
            Vector<String> vect = new Vector<String>();
            this.f[0] = xx[this.xindex][0];
            this.d = this.xmap.inverseScaleValues(this.f);
            Real rr = new Real(this.x, (double)this.d[0]);
            Unit overrideUnit = this.xmap.getOverrideUnit();
            Unit rtunit = this.x.getDefaultUnit();
            if (overrideUnit != null && !overrideUnit.equals(rtunit) && !RealType.Time.equals(this.x)) {
                double dval = overrideUnit.toThis(this.d[0], rtunit);
                rr = new Real(this.x, dval, overrideUnit);
            }
            String valueString = rr.toValueString();
            vect.addElement(this.x.getName() + " = " + valueString);
            this.f[0] = xx[this.yindex][0];
            this.d = this.ymap.inverseScaleValues(this.f);
            rr = new Real(this.y, (double)this.d[0]);
            overrideUnit = this.ymap.getOverrideUnit();
            rtunit = this.y.getDefaultUnit();
            if (overrideUnit != null && !overrideUnit.equals(rtunit) && !RealType.Time.equals(this.y)) {
                double dval = overrideUnit.toThis(this.d[0], rtunit);
                rr = new Real(this.y, dval, overrideUnit);
            }
            valueString = rr.toValueString();
            valueString = new Real(this.y, (double)this.d[0]).toValueString();
            vect.addElement(this.y.getName() + " = " + valueString);
            double[] dd = new double[2];
            this.f[0] = this.first_x[this.xindex][0];
            this.d = this.xmap.inverseScaleValues(this.f);
            dd[0] = this.d[0];
            this.f[0] = this.first_x[this.yindex][0];
            this.d = this.ymap.inverseScaleValues(this.f);
            dd[1] = this.d[0];
            RealTuple rt = new RealTuple(this.xy, dd);
            this.ref.setData(rt);
        }
        catch (VisADException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
    }

    @Override
    public Object clone() {
        return new PointManipulationRendererJ3D(this.x, this.y, this.mouseModifiersMask, this.mouseModifiersValue);
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        RealTupleType xy = new RealTupleType(x, y);
        RealType c = RealType.getRealType("c");
        FunctionType ft = new FunctionType(xy, c);
        DisplayImplJ3D display = new DisplayImplJ3D("display1");
        if (args.length == 0 || args[0].equals("z")) {
            display.addMap(new ScalarMap(x, Display.XAxis));
            display.addMap(new ScalarMap(y, Display.YAxis));
        } else if (args[0].equals("x")) {
            display.addMap(new ScalarMap(x, Display.YAxis));
            display.addMap(new ScalarMap(y, Display.ZAxis));
        } else if (args[0].equals("y")) {
            display.addMap(new ScalarMap(x, Display.XAxis));
            display.addMap(new ScalarMap(y, Display.ZAxis));
        } else if (args[0].equals("radius")) {
            display.addMap(new ScalarMap(x, Display.Longitude));
            display.addMap(new ScalarMap(y, Display.Latitude));
        } else if (args[0].equals("lat")) {
            display.addMap(new ScalarMap(x, Display.Longitude));
            display.addMap(new ScalarMap(y, Display.Radius));
        } else if (args[0].equals("lon")) {
            display.addMap(new ScalarMap(x, Display.Latitude));
            display.addMap(new ScalarMap(y, Display.Radius));
        } else {
            display.addMap(new ScalarMap(x, Display.Longitude));
            display.addMap(new ScalarMap(y, Display.Latitude));
        }
        display.addMap(new ScalarMap(c, Display.RGB));
        Integer2DSet fset = new Integer2DSet((MathType)xy, 64, 64);
        FlatField field = new FlatField(ft, fset);
        float[][] values = new float[1][4096];
        int k = 0;
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                values[0][k++] = (i - 32) * (j - 32);
            }
        }
        field.setSamples(values);
        DataReferenceImpl field_ref = new DataReferenceImpl("field");
        field_ref.setData(field);
        display.addReference(field_ref);
        RealTuple dummy_rt = new RealTuple(xy, new double[]{Double.NaN, Double.NaN});
        final DataReferenceImpl ref = new DataReferenceImpl("rt");
        ref.setData(dummy_rt);
        int m = args.length > 1 ? 2 : 0;
        display.addReferences((DataRenderer)new PointManipulationRendererJ3D(x, y, m, m), ref);
        CellImpl cell = new CellImpl(){

            @Override
            public void doAction() throws VisADException, RemoteException {
                RealTuple rt = (RealTuple)ref.getData();
                double dx = ((Real)rt.getComponent(0)).getValue();
                double dy = ((Real)rt.getComponent(1)).getValue();
                if (dx == dx && dy == dy) {
                    System.out.println("point (" + dx + ", " + dy + ")");
                }
            }
        };
        cell.addReference(ref);
        JFrame frame = new JFrame("test PointManipulationRendererJ3D");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

