/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.Set;
import visad.ShadowType;
import visad.SphericalCoordinateSystem;
import visad.VisADException;
import visad.VisADGeometryArray;

public class VisADTriangleStripArray
extends VisADGeometryArray {
    public int[] stripVertexCounts;
    private static final float LIMIT = 1.0f;
    private static final double ALPHA = 0.01;

    public static VisADTriangleStripArray merge(VisADTriangleStripArray[] arrays) throws VisADException {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        VisADTriangleStripArray.merge(arrays, array);
        int n = arrays.length;
        int nstrips = 0;
        for (int i = 0; i < n; ++i) {
            if (arrays[i] == null) continue;
            nstrips += arrays[i].stripVertexCounts.length;
        }
        if (nstrips <= 0) {
            return null;
        }
        int[] stripVertexCounts = new int[nstrips];
        nstrips = 0;
        for (int i = 0; i < n; ++i) {
            if (arrays[i] == null) continue;
            int incnstrips = arrays[i].stripVertexCounts.length;
            for (int j = 0; j < incnstrips; ++j) {
                stripVertexCounts[nstrips + j] = arrays[i].stripVertexCounts[j];
            }
            nstrips += incnstrips;
        }
        array.stripVertexCounts = stripVertexCounts;
        return array;
    }

    @Override
    public VisADGeometryArray adjustSeam(DataRenderer renderer) throws VisADException {
        double limit_length;
        CoordinateSystem coord_sys = renderer.getDisplayCoordinateSystem();
        if (coord_sys == null || coord_sys instanceof SphericalCoordinateSystem || this.coordinates == null) {
            return this;
        }
        int len = this.coordinates.length / 3;
        double[][] cs = new double[3][len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            cs[0][i] = this.coordinates[j++];
            cs[1][i] = this.coordinates[j++];
            cs[2][i] = this.coordinates[j++];
        }
        double[][] rs = coord_sys.fromReference(Set.copyDoubles(cs));
        boolean[] test = new boolean[len];
        double[] lengths = new double[len];
        for (int i = 0; i < len; ++i) {
            lengths[i] = 0.0;
        }
        double mean_length = 0.0;
        double var_length = 0.0;
        double max_length = 0.0;
        int num_length = 0;
        boolean any_split = false;
        if (len < 2) {
            return this;
        }
        double[][] bs = new double[3][len - 1];
        double[][] ss = new double[3][len - 1];
        double ALPHA1 = 1.01;
        double ALPHA1m = 0.99;
        for (int i = 0; i < len - 1; ++i) {
            bs[0][i] = ALPHA1 * rs[0][i] - 0.01 * rs[0][i + 1];
            bs[1][i] = ALPHA1 * rs[1][i] - 0.01 * rs[1][i + 1];
            bs[2][i] = ALPHA1 * rs[2][i] - 0.01 * rs[2][i + 1];
            ss[0][i] = ALPHA1 * rs[0][i + 1] - 0.01 * rs[0][i];
            ss[1][i] = ALPHA1 * rs[1][i + 1] - 0.01 * rs[1][i];
            ss[2][i] = ALPHA1 * rs[2][i + 1] - 0.01 * rs[2][i];
        }
        double[][] ds = coord_sys.toReference(bs);
        double[][] es = coord_sys.toReference(ss);
        double IALPHA = 100.0;
        int last_i = 0;
        for (int i_svc = 0; i_svc < this.stripVertexCounts.length; ++i_svc) {
            for (int i = last_i; i < last_i + this.stripVertexCounts[i_svc] - 1; ++i) {
                double a0 = cs[0][i + 1] - cs[0][i];
                double a1 = cs[1][i + 1] - cs[1][i];
                double a2 = cs[2][i + 1] - cs[2][i];
                double b0 = IALPHA * (cs[0][i] - ds[0][i]);
                double b1 = IALPHA * (cs[1][i] - ds[1][i]);
                double b2 = IALPHA * (cs[2][i] - ds[2][i]);
                double aa = a0 * a0 + a1 * a1 + a2 * a2;
                double aminusb = (b0 - a0) * (b0 - a0) + (b1 - a1) * (b1 - a1) + (b2 - a2) * (b2 - a2);
                double abratio = aminusb / aa;
                double c0 = IALPHA * (cs[0][i + 1] - es[0][i]);
                double c1 = IALPHA * (cs[1][i + 1] - es[1][i]);
                double c2 = IALPHA * (cs[2][i + 1] - es[2][i]);
                double aminusc = (c0 + a0) * (c0 + a0) + (c1 + a1) * (c1 + a1) + (c2 + a2) * (c2 + a2);
                double acratio = aminusc / aa;
                test[i] = (double)0.01f < abratio || (double)0.01f < acratio;
                double cd = (cs[0][i + 1] - cs[0][i]) * (cs[0][i + 1] - cs[0][i]) + (cs[1][i + 1] - cs[1][i]) * (cs[1][i + 1] - cs[1][i]) + (cs[2][i + 1] - cs[2][i]) * (cs[2][i + 1] - cs[2][i]);
                if (test[i]) continue;
                lengths[i] = cd;
                ++num_length;
                mean_length += lengths[i];
                var_length += lengths[i] * lengths[i];
                if (!(lengths[i] > max_length)) continue;
                max_length = lengths[i];
            }
            last_i += this.stripVertexCounts[i_svc];
        }
        cs = null;
        rs = null;
        bs = null;
        ss = null;
        ds = null;
        es = null;
        if (num_length < 2) {
            return this;
        }
        if (max_length >= (limit_length = (mean_length /= (double)num_length) + 1.0 * (var_length = Math.sqrt((var_length - mean_length * mean_length) / (double)num_length)))) {
            last_i = 0;
            for (int i_svc = 0; i_svc < this.stripVertexCounts.length; ++i_svc) {
                for (int i = last_i; i < last_i + this.stripVertexCounts[i_svc] - 1; ++i) {
                    if (!test[i]) continue;
                    any_split = true;
                }
                last_i += this.stripVertexCounts[i_svc];
            }
        }
        if (!any_split) {
            return this;
        }
        float[] lastcoord = null;
        float[] lastno = null;
        byte[] lastcol = null;
        float[] lasttex = null;
        float[] earlycoord = null;
        float[] earlyno = null;
        byte[] earlycol = null;
        float[] earlytex = null;
        float[] coord = null;
        float[] no = null;
        byte[] col = null;
        float[] tex = null;
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        int worst = 6;
        float[] coords = new float[worst * this.coordinates.length];
        float[] nos = null;
        if (this.normals != null) {
            nos = new float[worst * this.normals.length];
        }
        int color_length = 0;
        byte[] cols = null;
        if (this.colors != null) {
            color_length = 3;
            cols = new byte[worst * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        float[] texs = null;
        if (this.texCoords != null) {
            texs = new float[worst * this.texCoords.length];
        }
        int[] svcs = new int[this.coordinates.length];
        int svc_index = 0;
        last_i = 0;
        int[] kmr = new int[]{0, 0, 0};
        int t = 0;
        j = 0;
        any_split = false;
        for (int i_svc = 0; i_svc < this.stripVertexCounts.length; ++i_svc) {
            boolean this_split = false;
            int accum = 0;
            j = color_length * last_i / 3 - color_length;
            t = 2 * last_i / 3 - 2;
            for (int i = last_i; i < last_i + this.stripVertexCounts[i_svc] * 3 - 3; i += 3) {
                j += color_length;
                t += 2;
                boolean last_split = this_split;
                if (test[i / 3]) {
                    this_split = true;
                    any_split = true;
                    if (accum >= 3) {
                        svcs[svc_index] = accum;
                        ++svc_index;
                    }
                    lastcoord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                    if (this.normals != null) {
                        lastno = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                    }
                    if (color_length == 3) {
                        lastcol = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                    } else if (color_length == 4) {
                        lastcol = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                    }
                    if (this.texCoords != null) {
                        lasttex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                    }
                    accum = 1;
                    continue;
                }
                this_split = false;
                if (this_split) continue;
                if (accum == 0) {
                    earlycoord = new float[]{this.coordinates[i], this.coordinates[i + 1], this.coordinates[i + 2]};
                    lastcoord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                    if (this.normals != null) {
                        earlyno = new float[]{this.normals[i], this.normals[i + 1], this.normals[i + 2]};
                        lastno = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                    }
                    if (color_length == 3) {
                        earlycol = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2]};
                        lastcol = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                    } else if (color_length == 4) {
                        earlycol = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2], this.colors[j + 3]};
                        lastcol = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                    }
                    if (this.texCoords != null) {
                        earlytex = new float[]{this.texCoords[t], this.texCoords[t + 1]};
                        lasttex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                    }
                    accum = 2;
                    continue;
                }
                coord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                if (this.normals != null) {
                    no = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                }
                if (color_length == 3) {
                    col = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                } else if (color_length == 4) {
                    col = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                }
                if (this.texCoords != null) {
                    tex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                }
                ++accum;
                if (earlycoord == null) {
                    earlycoord = new float[3];
                    if (this.normals != null) {
                        earlyno = new float[3];
                    }
                    if (color_length > 0) {
                        earlycol = new byte[color_length];
                    }
                    if (this.texCoords != null) {
                        earlytex = new float[2];
                    }
                }
                this.nextPoint(accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
            }
            if (accum >= 3) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc] * 3;
        }
        if (!any_split) {
            return this;
        }
        array.coordinates = new float[kmr[0]];
        System.arraycopy(coords, 0, array.coordinates, 0, kmr[0]);
        if (this.normals != null) {
            array.normals = new float[kmr[0]];
            System.arraycopy(nos, 0, array.normals, 0, kmr[0]);
        }
        if (this.colors != null) {
            array.colors = new byte[kmr[1]];
            System.arraycopy(cols, 0, array.colors, 0, kmr[1]);
        }
        if (this.texCoords != null) {
            array.texCoords = new float[kmr[2]];
            System.arraycopy(texs, 0, array.texCoords, 0, kmr[2]);
        }
        array.vertexCount = kmr[0] / 3;
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        return array;
    }

    @Override
    public VisADGeometryArray adjustLongitude(DataRenderer renderer) throws VisADException {
        float[] lons = this.getLongitudes(renderer);
        if (lons == null) {
            return this;
        }
        int[] axis = new int[1];
        float[] lon_coords = new float[2];
        float[] lon_range = this.getLongitudeRange(lons, axis, lon_coords);
        if (lon_range[0] != lon_range[0] || lon_range[1] != lon_range[1]) {
            return this;
        }
        float bottom = lon_range[0];
        float top = lon_range[1];
        float low = bottom + 30.0f;
        float hi = top - 30.0f;
        int lon_axis = axis[0];
        float coord_bottom = lon_coords[0];
        float coord_top = lon_coords[1];
        float[] midcoord_first = null;
        float[] midcoord_second = null;
        float[] midno = null;
        byte[] midcol = null;
        float[] midtex = null;
        float[] last_midcoord_first = null;
        float[] last_midcoord_second = null;
        float[] last_midno = null;
        byte[] last_midcol = null;
        float[] last_midtex = null;
        float[] sillymidcoord_first = null;
        float[] sillymidcoord_second = null;
        float[] sillymidno = null;
        byte[] sillymidcol = null;
        float[] sillymidtex = null;
        float[] lastcoord = null;
        float[] lastno = null;
        byte[] lastcol = null;
        float[] lasttex = null;
        float[] earlycoord = null;
        float[] earlyno = null;
        byte[] earlycol = null;
        float[] earlytex = null;
        float[] coord = null;
        float[] no = null;
        byte[] col = null;
        float[] tex = null;
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        int worst = 6;
        float[] coords = new float[worst * this.coordinates.length];
        float[] nos = null;
        if (this.normals != null) {
            nos = new float[worst * this.normals.length];
        }
        int color_length = 0;
        byte[] cols = null;
        if (this.colors != null) {
            color_length = 3;
            cols = new byte[worst * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        float[] texs = null;
        if (this.texCoords != null) {
            texs = new float[worst * this.texCoords.length];
        }
        int[] svcs = new int[this.coordinates.length];
        int svc_index = 0;
        int last_i = 0;
        int[] kmr = new int[]{0, 0, 0};
        int t = 0;
        int j = 0;
        boolean any_split = false;
        for (int i_svc = 0; i_svc < this.stripVertexCounts.length; ++i_svc) {
            boolean this_split = false;
            int accum = 0;
            j = color_length * last_i / 3 - color_length;
            t = 2 * last_i / 3 - 2;
            for (int i = last_i; i < last_i + this.stripVertexCounts[i_svc] * 3 - 3; i += 3) {
                float beta;
                float alpha;
                float coord_second;
                float coord_first;
                float b;
                float a;
                int i3;
                j += color_length;
                t += 2;
                boolean last_split = this_split;
                if (last_split) {
                    last_midcoord_first = midcoord_first;
                    last_midcoord_second = midcoord_second;
                    last_midno = midno;
                    last_midcol = midcol;
                    last_midtex = midtex;
                }
                if (lons[i3 = i / 3] < low && hi < lons[i3 + 1] || lons[i3 + 1] < low && hi < lons[i3]) {
                    this_split = true;
                    any_split = true;
                    if (lon_axis < 0) {
                        if (accum >= 3) {
                            svcs[svc_index] = accum;
                            ++svc_index;
                        }
                        lastcoord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                        if (this.normals != null) {
                            lastno = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                        }
                        if (color_length == 3) {
                            lastcol = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                        } else if (color_length == 4) {
                            lastcol = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                        }
                        if (this.texCoords != null) {
                            lasttex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                        }
                        accum = 1;
                        continue;
                    }
                    if (lons[i3] < low) {
                        a = lons[i3] - bottom;
                        b = top - lons[i3 + 1];
                        coord_first = coord_bottom;
                        coord_second = coord_top;
                    } else {
                        a = top - lons[i3];
                        b = lons[i3 + 1] - bottom;
                        coord_first = coord_top;
                        coord_second = coord_bottom;
                    }
                    alpha = b / (a + b);
                    alpha = alpha != alpha || alpha < 0.0f ? 0.0f : (1.0f < alpha ? 1.0f : alpha);
                    beta = 1.0f - alpha;
                    midcoord_first = new float[]{alpha * this.coordinates[i] + beta * this.coordinates[i + 3], alpha * this.coordinates[i + 1] + beta * this.coordinates[i + 4], alpha * this.coordinates[i + 2] + beta * this.coordinates[i + 5]};
                    midcoord_second = new float[]{midcoord_first[0], midcoord_first[1], midcoord_first[2]};
                    midcoord_first[lon_axis] = coord_first;
                    midcoord_second[lon_axis] = coord_second;
                    if (this.normals != null) {
                        midno = new float[]{alpha * this.normals[i] + beta * this.normals[i + 3], alpha * this.normals[i + 1] + beta * this.normals[i + 4], alpha * this.normals[i + 2] + beta * this.normals[i + 5]};
                    }
                    if (color_length == 3) {
                        midcol = new byte[]{ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j]) + beta * ShadowType.byteToFloat(this.colors[j + 3])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 1]) + beta * ShadowType.byteToFloat(this.colors[j + 4])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 2]) + beta * ShadowType.byteToFloat(this.colors[j + 5]))};
                    } else if (color_length == 4) {
                        midcol = new byte[]{ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j]) + beta * ShadowType.byteToFloat(this.colors[j + 4])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 1]) + beta * ShadowType.byteToFloat(this.colors[j + 5])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 2]) + beta * ShadowType.byteToFloat(this.colors[j + 6])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j + 3]) + beta * ShadowType.byteToFloat(this.colors[j + 7]))};
                    }
                    if (this.texCoords != null) {
                        midtex = new float[]{alpha * this.texCoords[t] + beta * this.texCoords[t + 2], alpha * this.texCoords[t + 1] + beta * this.texCoords[t + 3]};
                    }
                } else {
                    this_split = false;
                }
                if (accum > 0 && this_split != last_split && lon_axis >= 0) {
                    if (lons[i3 - 1] < low) {
                        a = lons[i3 - 1] - bottom;
                        b = top - lons[i3 + 1];
                        coord_first = coord_bottom;
                        coord_second = coord_top;
                    } else {
                        a = top - lons[i3 - 1];
                        b = lons[i3 + 1] - bottom;
                        coord_first = coord_top;
                        coord_second = coord_bottom;
                    }
                    alpha = b / (a + b);
                    alpha = alpha != alpha || alpha < 0.0f ? 0.0f : (1.0f < alpha ? 1.0f : alpha);
                    beta = 1.0f - alpha;
                    sillymidcoord_first = new float[]{alpha * this.coordinates[i - 3] + beta * this.coordinates[i + 3], alpha * this.coordinates[i - 2] + beta * this.coordinates[i + 4], alpha * this.coordinates[i - 1] + beta * this.coordinates[i + 5]};
                    sillymidcoord_second = new float[]{sillymidcoord_first[0], sillymidcoord_first[1], sillymidcoord_first[2]};
                    sillymidcoord_first[lon_axis] = coord_first;
                    sillymidcoord_second[lon_axis] = coord_second;
                    if (this.normals != null) {
                        sillymidno = new float[]{alpha * this.normals[i - 3] + beta * this.normals[i + 3], alpha * this.normals[i - 2] + beta * this.normals[i + 4], alpha * this.normals[i - 1] + beta * this.normals[i + 5]};
                    }
                    if (color_length == 3) {
                        sillymidcol = new byte[]{ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j - 3]) + beta * ShadowType.byteToFloat(this.colors[j + 3])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j - 2]) + beta * ShadowType.byteToFloat(this.colors[j + 4])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j - 1]) + beta * ShadowType.byteToFloat(this.colors[j + 5]))};
                    } else if (color_length == 4) {
                        sillymidcol = new byte[]{ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j - 4]) + beta * ShadowType.byteToFloat(this.colors[j + 4])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j - 3]) + beta * ShadowType.byteToFloat(this.colors[j + 5])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j - 2]) + beta * ShadowType.byteToFloat(this.colors[j + 6])), ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[j - 1]) + beta * ShadowType.byteToFloat(this.colors[j + 7]))};
                    }
                    if (this.texCoords != null) {
                        sillymidtex = new float[]{alpha * this.texCoords[t - 2] + beta * this.texCoords[t + 2], alpha * this.texCoords[t - 1] + beta * this.texCoords[t + 3]};
                    }
                }
                if (this_split) {
                    if (accum == 0) {
                        earlycoord = new float[]{midcoord_second[0], midcoord_second[1], midcoord_second[2]};
                        lastcoord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                        if (this.normals != null) {
                            earlyno = new float[]{midno[0], midno[1], midno[2]};
                            lastno = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                        }
                        if (color_length == 3) {
                            earlycol = new byte[]{midcol[0], midcol[1], midcol[2]};
                            lastcol = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                        } else if (color_length == 4) {
                            earlycol = new byte[]{midcol[0], midcol[1], midcol[2], midcol[3]};
                            lastcol = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                        }
                        if (this.texCoords != null) {
                            earlytex = new float[]{midtex[0], midtex[1]};
                            lasttex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                        }
                        accum = 2;
                        continue;
                    }
                    if (last_split) {
                        coord = midcoord_first;
                        no = midno;
                        col = midcol;
                        tex = midtex;
                        this.nextPoint(++accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                        svcs[svc_index] = accum;
                        ++svc_index;
                        earlycoord = last_midcoord_first;
                        earlyno = last_midno;
                        earlycol = last_midcol;
                        earlytex = last_midtex;
                        lastcoord = new float[]{this.coordinates[i - 3], this.coordinates[i - 2], this.coordinates[i - 1]};
                        if (this.normals != null) {
                            lastno = new float[]{this.normals[i - 3], this.normals[i - 2], this.normals[i - 1]};
                        }
                        if (color_length == 3) {
                            lastcol = new byte[]{this.colors[j - 3], this.colors[j - 2], this.colors[j - 1]};
                        } else if (color_length == 4) {
                            lastcol = new byte[]{this.colors[j - 4], this.colors[j - 3], this.colors[j - 2], this.colors[j - 1]};
                        }
                        if (this.texCoords != null) {
                            lasttex = new float[]{this.texCoords[t - 2], this.texCoords[t - 1]};
                        }
                        coord = midcoord_second;
                        no = midno;
                        col = midcol;
                        tex = midtex;
                        accum = 3;
                        this.nextPoint(accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                        coord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                        if (this.normals != null) {
                            no = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                        }
                        if (color_length == 3) {
                            col = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                        } else if (color_length == 4) {
                            col = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                        }
                        if (this.texCoords != null) {
                            tex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                        }
                        this.nextPoint(++accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                        continue;
                    }
                    coord = midcoord_first;
                    no = midno;
                    col = midcol;
                    tex = midtex;
                    this.nextPoint(++accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                    coord = new float[]{this.coordinates[i - 3], this.coordinates[i - 2], this.coordinates[i - 1]};
                    if (this.normals != null) {
                        no = new float[]{this.normals[i - 3], this.normals[i - 2], this.normals[i - 1]};
                    }
                    if (color_length == 3) {
                        col = new byte[]{this.colors[j - 3], this.colors[j - 2], this.colors[j - 1]};
                    } else if (color_length == 4) {
                        col = new byte[]{this.colors[j - 4], this.colors[j - 3], this.colors[j - 2], this.colors[j - 1]};
                    }
                    if (this.texCoords != null) {
                        tex = new float[]{this.texCoords[t - 2], this.texCoords[t - 1]};
                    }
                    this.nextPoint(++accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                    coord = sillymidcoord_first;
                    no = sillymidno;
                    col = sillymidcol;
                    tex = sillymidtex;
                    this.nextPoint(++accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                    svcs[svc_index] = accum;
                    ++svc_index;
                    earlycoord = sillymidcoord_second;
                    earlyno = sillymidno;
                    earlycol = sillymidcol;
                    earlytex = sillymidtex;
                    lastcoord = midcoord_second;
                    lastno = midno;
                    lastcol = midcol;
                    lasttex = midtex;
                    coord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                    if (this.normals != null) {
                        no = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                    }
                    if (color_length == 3) {
                        col = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                    } else if (color_length == 4) {
                        col = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                    }
                    if (this.texCoords != null) {
                        tex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                    }
                    accum = 3;
                    this.nextPoint(accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                    continue;
                }
                if (accum == 0) {
                    earlycoord = new float[]{this.coordinates[i], this.coordinates[i + 1], this.coordinates[i + 2]};
                    lastcoord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                    if (this.normals != null) {
                        earlyno = new float[]{this.normals[i], this.normals[i + 1], this.normals[i + 2]};
                        lastno = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                    }
                    if (color_length == 3) {
                        earlycol = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2]};
                        lastcol = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                    } else if (color_length == 4) {
                        earlycol = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2], this.colors[j + 3]};
                        lastcol = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                    }
                    if (this.texCoords != null) {
                        earlytex = new float[]{this.texCoords[t], this.texCoords[t + 1]};
                        lasttex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                    }
                    accum = 2;
                    continue;
                }
                if (last_split && lon_axis >= 0) {
                    if (accum >= 3) {
                        svcs[svc_index] = accum;
                        ++svc_index;
                    }
                    earlycoord = new float[]{this.coordinates[i - 3], this.coordinates[i - 2], this.coordinates[i - 1]};
                    if (this.normals != null) {
                        earlyno = new float[]{this.normals[i - 3], this.normals[i - 2], this.normals[i - 1]};
                    }
                    if (color_length == 3) {
                        earlycol = new byte[]{this.colors[j - 3], this.colors[j - 2], this.colors[j - 1]};
                    } else if (color_length == 4) {
                        earlycol = new byte[]{this.colors[j - 4], this.colors[j - 3], this.colors[j - 2], this.colors[j - 1]};
                    }
                    if (this.texCoords != null) {
                        earlytex = new float[]{this.texCoords[t - 2], this.texCoords[t - 1]};
                    }
                    lastcoord = last_midcoord_first;
                    lastno = last_midno;
                    lastcol = last_midcol;
                    lasttex = last_midtex;
                    coord = sillymidcoord_first;
                    no = sillymidno;
                    col = sillymidcol;
                    tex = sillymidtex;
                    accum = 3;
                    this.nextPoint(accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                    svcs[svc_index] = accum;
                    ++svc_index;
                    earlycoord = last_midcoord_second;
                    earlyno = last_midno;
                    earlycol = last_midcol;
                    earlytex = last_midtex;
                    lastcoord = sillymidcoord_second;
                    lastno = sillymidno;
                    lastcol = sillymidcol;
                    lasttex = sillymidtex;
                    coord = new float[]{this.coordinates[i], this.coordinates[i + 1], this.coordinates[i + 2]};
                    if (this.normals != null) {
                        no = new float[]{this.normals[i], this.normals[i + 1], this.normals[i + 2]};
                    }
                    if (color_length == 3) {
                        col = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2]};
                    } else if (color_length == 4) {
                        col = new byte[]{this.colors[j], this.colors[j + 1], this.colors[j + 2], this.colors[j + 3]};
                    }
                    if (this.texCoords != null) {
                        tex = new float[]{this.texCoords[t], this.texCoords[t + 1]};
                    }
                    accum = 3;
                    this.nextPoint(accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                    coord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                    if (this.normals != null) {
                        no = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                    }
                    if (color_length == 3) {
                        col = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                    } else if (color_length == 4) {
                        col = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                    }
                    if (this.texCoords != null) {
                        tex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                    }
                    this.nextPoint(++accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
                    continue;
                }
                if (earlycoord == null) {
                    earlycoord = new float[3];
                    if (this.normals != null) {
                        earlyno = new float[3];
                    }
                    if (color_length > 0) {
                        earlycol = new byte[color_length];
                    }
                    if (this.texCoords != null) {
                        earlytex = new float[2];
                    }
                }
                coord = new float[]{this.coordinates[i + 3], this.coordinates[i + 4], this.coordinates[i + 5]};
                if (this.normals != null) {
                    no = new float[]{this.normals[i + 3], this.normals[i + 4], this.normals[i + 5]};
                }
                if (color_length == 3) {
                    col = new byte[]{this.colors[j + 3], this.colors[j + 4], this.colors[j + 5]};
                } else if (color_length == 4) {
                    col = new byte[]{this.colors[j + 4], this.colors[j + 5], this.colors[j + 6], this.colors[j + 7]};
                }
                if (this.texCoords != null) {
                    tex = new float[]{this.texCoords[t + 2], this.texCoords[t + 3]};
                }
                this.nextPoint(++accum, color_length, coords, nos, cols, texs, coord, no, col, tex, lastcoord, lastno, lastcol, lasttex, earlycoord, earlyno, earlycol, earlytex, kmr);
            }
            if (accum >= 3) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc] * 3;
        }
        if (!any_split) {
            return this;
        }
        array.coordinates = new float[kmr[0]];
        System.arraycopy(coords, 0, array.coordinates, 0, kmr[0]);
        if (this.normals != null) {
            array.normals = new float[kmr[0]];
            System.arraycopy(nos, 0, array.normals, 0, kmr[0]);
        }
        if (this.colors != null) {
            array.colors = new byte[kmr[1]];
            System.arraycopy(cols, 0, array.colors, 0, kmr[1]);
        }
        if (this.texCoords != null) {
            array.texCoords = new float[kmr[2]];
            System.arraycopy(texs, 0, array.texCoords, 0, kmr[2]);
        }
        array.vertexCount = kmr[0] / 3;
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        return array;
    }

    private void nextPoint(int accum, int color_length, float[] coords, float[] nos, byte[] cols, float[] texs, float[] coord, float[] no, byte[] col, float[] tex, float[] lastcoord, float[] lastno, byte[] lastcol, float[] lasttex, float[] earlycoord, float[] earlyno, byte[] earlycol, float[] earlytex, int[] kmr) {
        if (accum == 2) {
            System.arraycopy(lastcoord, 0, earlycoord, 0, 3);
            System.arraycopy(coord, 0, lastcoord, 0, 3);
            if (this.normals != null) {
                System.arraycopy(lastno, 0, earlyno, 0, 3);
                System.arraycopy(no, 0, lastno, 0, 3);
            }
            if (this.colors != null) {
                System.arraycopy(lastcol, 0, earlycol, 0, color_length);
                System.arraycopy(col, 0, lastcol, 0, color_length);
            }
            if (this.texCoords != null) {
                System.arraycopy(lasttex, 0, earlytex, 0, 2);
                System.arraycopy(tex, 0, lasttex, 0, 2);
            }
            return;
        }
        if (accum == 3) {
            coords[kmr[0]] = earlycoord[0];
            coords[kmr[0] + 1] = earlycoord[1];
            coords[kmr[0] + 2] = earlycoord[2];
            if (this.normals != null) {
                nos[kmr[0]] = earlyno[0];
                nos[kmr[0] + 1] = earlyno[1];
                nos[kmr[0] + 2] = earlyno[2];
            }
            kmr[0] = kmr[0] + 3;
            if (this.colors != null) {
                cols[kmr[1]] = earlycol[0];
                cols[kmr[1] + 1] = earlycol[1];
                cols[kmr[1] + 2] = earlycol[2];
                kmr[1] = kmr[1] + 3;
                if (color_length == 4) {
                    int n = kmr[1];
                    kmr[1] = n + 1;
                    cols[n] = earlycol[3];
                }
            }
            if (this.texCoords != null) {
                texs[kmr[2]] = earlytex[0];
                texs[kmr[2] + 1] = earlytex[1];
                kmr[2] = kmr[2] + 2;
            }
            coords[kmr[0]] = lastcoord[0];
            coords[kmr[0] + 1] = lastcoord[1];
            coords[kmr[0] + 2] = lastcoord[2];
            if (this.normals != null) {
                nos[kmr[0]] = lastno[0];
                nos[kmr[0] + 1] = lastno[1];
                nos[kmr[0] + 2] = lastno[2];
            }
            kmr[0] = kmr[0] + 3;
            if (this.colors != null) {
                cols[kmr[1]] = lastcol[0];
                cols[kmr[1] + 1] = lastcol[1];
                cols[kmr[1] + 2] = lastcol[2];
                kmr[1] = kmr[1] + 3;
                if (color_length == 4) {
                    int n = kmr[1];
                    kmr[1] = n + 1;
                    cols[n] = lastcol[3];
                }
            }
            if (this.texCoords != null) {
                texs[kmr[2]] = lasttex[0];
                texs[kmr[2] + 1] = lasttex[1];
                kmr[2] = kmr[2] + 2;
            }
        }
        coords[kmr[0]] = coord[0];
        coords[kmr[0] + 1] = coord[1];
        coords[kmr[0] + 2] = coord[2];
        if (this.normals != null) {
            nos[kmr[0]] = no[0];
            nos[kmr[0] + 1] = no[1];
            nos[kmr[0] + 2] = no[2];
        }
        kmr[0] = kmr[0] + 3;
        if (this.colors != null) {
            cols[kmr[1]] = col[0];
            cols[kmr[1] + 1] = col[1];
            cols[kmr[1] + 2] = col[2];
            kmr[1] = kmr[1] + 3;
            if (color_length == 4) {
                int n = kmr[1];
                kmr[1] = n + 1;
                cols[n] = col[3];
            }
        }
        if (this.texCoords != null) {
            texs[kmr[2]] = tex[0];
            texs[kmr[2] + 1] = tex[1];
            kmr[2] = kmr[2] + 2;
        }
    }

    @Override
    public VisADGeometryArray removeMissing() {
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        float[] coords = new float[this.coordinates.length];
        float[] nos = null;
        if (this.normals != null) {
            nos = new float[this.normals.length];
        }
        int color_length = 3;
        byte[] cols = null;
        if (this.colors != null) {
            cols = new byte[this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        float[] texs = null;
        if (this.texCoords != null) {
            texs = new float[this.texCoords.length];
        }
        int[] svcs = new int[this.coordinates.length / 4];
        int svc_index = 0;
        int last_i = 0;
        int k = 0;
        int m = 0;
        int t = 0;
        int r = 0;
        int j = 0;
        boolean any_missing = false;
        for (int i_svc = 0; i_svc < this.stripVertexCounts.length; ++i_svc) {
            int accum = 0;
            j = color_length * last_i / 3;
            t = 2 * last_i / 3;
            for (int i = last_i; i < last_i + this.stripVertexCounts[i_svc] * 3; i += 3) {
                if (this.coordinates[i] == this.coordinates[i] && this.coordinates[i + 1] == this.coordinates[i + 1] && this.coordinates[i + 2] == this.coordinates[i + 2]) {
                    if (++accum >= 3) {
                        int iml = i;
                        int jml = j;
                        int tml = t;
                        if (accum == 3) {
                            iml = i - 6;
                            jml = j - 2 * color_length;
                            tml = t - 4;
                        }
                        int jm = jml;
                        int tm = tml;
                        for (int im = iml; im <= i; im += 3) {
                            coords[k] = this.coordinates[im];
                            coords[k + 1] = this.coordinates[im + 1];
                            coords[k + 2] = this.coordinates[im + 2];
                            if (this.normals != null) {
                                nos[k] = this.normals[im];
                                nos[k + 1] = this.normals[im + 1];
                                nos[k + 2] = this.normals[im + 2];
                            }
                            if (this.colors != null) {
                                cols[m] = this.colors[jm];
                                cols[m + 1] = this.colors[jm + 1];
                                cols[m + 2] = this.colors[jm + 2];
                                m += 3;
                                if (color_length == 4) {
                                    cols[m++] = this.colors[jm + 3];
                                }
                            }
                            if (this.texCoords != null) {
                                texs[r] = this.texCoords[tm];
                                texs[r + 1] = this.texCoords[tm + 1];
                                r += 2;
                            }
                            k += 3;
                            jm += color_length;
                            tm += 2;
                        }
                    }
                } else {
                    any_missing = true;
                    if (accum >= 3) {
                        svcs[svc_index] = accum;
                        ++svc_index;
                    }
                    accum = 0;
                }
                j += color_length;
                t += 2;
            }
            if (accum >= 3) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc] * 3;
        }
        if (!any_missing) {
            return this;
        }
        array.coordinates = new float[k];
        System.arraycopy(coords, 0, array.coordinates, 0, k);
        if (this.normals != null) {
            array.normals = new float[k];
            System.arraycopy(nos, 0, array.normals, 0, k);
        }
        if (this.colors != null) {
            array.colors = new byte[m];
            System.arraycopy(cols, 0, array.colors, 0, m);
        }
        if (this.texCoords != null) {
            array.texCoords = new float[r];
            System.arraycopy(texs, 0, array.texCoords, 0, r);
        }
        array.vertexCount = k / 3;
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        return array;
    }

    @Override
    public String toString() {
        String string = "VisADTriangleStripArray ";
        string = string + "\n stripVertexCounts = ";
        for (int i = 0; i < this.stripVertexCounts.length; ++i) {
            string = string + this.stripVertexCounts[i] + " ";
        }
        return string;
    }

    @Override
    public Object clone() {
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        this.copy(array);
        if (this.stripVertexCounts != null) {
            array.stripVertexCounts = new int[this.stripVertexCounts.length];
            System.arraycopy(this.stripVertexCounts, 0, array.stripVertexCounts, 0, this.stripVertexCounts.length);
        }
        return array;
    }
}

