/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.RealTupleType;

public class TrajectoryParams {
    double trajVisibilityTimeWindow = 86400.0;
    double trajRefreshInterval = 86400.0;
    int numIntrpPts = 6;
    int startSkip = 2;
    SmoothParams smoothParams = SmoothParams.MEDIUM;
    int direction = 1;
    boolean doIntrp = true;
    float markerSize = 1.0f;
    boolean markerEnabled = false;
    boolean manualIntrpPts = false;
    float[][] startPoints = null;
    RealTupleType startType = null;

    public TrajectoryParams() {
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, double trajRefreshInterval, int numIntrpPts, int startSkip, SmoothParams smoothParams) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajRefreshInterval;
        this.numIntrpPts = numIntrpPts;
        this.startSkip = startSkip;
        this.smoothParams = smoothParams;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, int numIntrpPts, int startSkip, SmoothParams smoothParams) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajVisibilityTimeWindow;
        this.numIntrpPts = numIntrpPts;
        this.startSkip = startSkip;
        this.smoothParams = smoothParams;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, int numIntrpPts, int startSkip) {
        this(trajVisibilityTimeWindow, numIntrpPts, startSkip, SmoothParams.MEDIUM);
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, double trajRefreshInterval) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajRefreshInterval;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajVisibilityTimeWindow;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, double trajRefreshInterval, int startSkip) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajRefreshInterval;
        this.startSkip = startSkip;
    }

    public TrajectoryParams(double trajVisibilityTimeWindow, int startSkip) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
        this.trajRefreshInterval = trajVisibilityTimeWindow;
        this.startSkip = startSkip;
    }

    public void setTrajVisibilityTimeWindow(double trajVisibilityTimeWindow) {
        this.trajVisibilityTimeWindow = trajVisibilityTimeWindow;
    }

    public void setTrajRefreshInterval(double trajRefreshInterval) {
        this.trajRefreshInterval = trajRefreshInterval;
    }

    public void setDoIntrp(boolean yesno) {
        this.doIntrp = yesno;
    }

    public void setNumIntrpPts(int numIntrpPts) {
        this.numIntrpPts = numIntrpPts;
        this.manualIntrpPts = true;
    }

    public void setManualIntrpPts(boolean isManual) {
        this.manualIntrpPts = isManual;
    }

    public boolean getManualIntrpPts() {
        return this.manualIntrpPts;
    }

    public void setMarkerSize(float size) {
        this.markerSize = size;
    }

    public void setMarkerEnabled(boolean yesno) {
        this.markerEnabled = yesno;
    }

    public double getTrajVisibilityTimeWindow() {
        return this.trajVisibilityTimeWindow;
    }

    public double getTrajRefreshInterval() {
        return this.trajRefreshInterval;
    }

    public int getNumIntrpPts() {
        return this.numIntrpPts;
    }

    public int getStartSkip() {
        return this.startSkip;
    }

    public SmoothParams getSmoothParams() {
        return this.smoothParams;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean getDoIntrp() {
        return this.doIntrp;
    }

    public float getMarkerSize() {
        return this.markerSize;
    }

    public boolean getMarkerEnabled() {
        return this.markerEnabled;
    }

    public void setStartPoints(RealTupleType startType, float[][] startPts) {
        this.startType = startType;
        this.startPoints = startPts;
    }

    public float[][] getStartPoints() {
        return this.startPoints;
    }

    public RealTupleType getStartType() {
        return this.startType;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TrajectoryParams)) {
            return false;
        }
        TrajectoryParams trajParams = (TrajectoryParams)obj;
        if (this.trajVisibilityTimeWindow != trajParams.trajVisibilityTimeWindow) {
            return false;
        }
        if (this.trajRefreshInterval != trajParams.trajRefreshInterval) {
            return false;
        }
        if (this.numIntrpPts != trajParams.numIntrpPts) {
            return false;
        }
        if (this.startSkip != trajParams.startSkip) {
            return false;
        }
        return this.smoothParams == trajParams.smoothParams;
    }

    public static enum SmoothParams {
        LIGHT(0.05f, 0.9f, 0.05f),
        MEDIUM(0.15f, 0.7f, 0.15f),
        HEAVY(0.25f, 0.5f, 0.25f),
        NONE(0.0f, 1.0f, 0.0f);

        public float w0;
        public float w1;
        public float w2;

        private SmoothParams(float w0, float w1, float w2) {
            this.w0 = w0;
            this.w1 = w1;
            this.w2 = w2;
        }
    }
}

