/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Font;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.UnimplementedException;
import visad.VisADException;
import visad.util.HersheyFont;
import visad.util.Util;

public class TextControl
extends Control {
    private Object font = null;
    private double size = 1.0;
    private double factor = 1.0;
    private double autoSizeFactor = 1.0;
    private boolean sphere = false;
    private NumberFormat format = null;
    private double rotation = 0.0;
    private double characterRotation = 0.0;
    private double scale = 1.0;
    private double[] offset = new double[]{0.0, 0.0, 0.0};
    private boolean autoSize = false;
    private ProjectionControlListener pcl = null;
    private Justification justification = Justification.LEFT;
    private Justification verticalJustification = Justification.BOTTOM;

    public TextControl(DisplayImpl d) {
        super(d);
    }

    public void setAutoSize(boolean auto) throws VisADException {
        if (auto == this.autoSize) {
            return;
        }
        DisplayImpl display = this.getDisplay();
        DisplayRenderer dr = display.getDisplayRenderer();
        MouseBehavior mouse = dr.getMouseBehavior();
        ProjectionControl pc = display.getProjectionControl();
        if (auto && this.pcl == null) {
            this.pcl = new ProjectionControlListener(mouse, this, pc);
            pc.addControlListener(this.pcl);
        }
        if (this.pcl != null) {
            this.pcl.setActive(auto);
        }
        this.autoSize = auto;
        try {
            this.changeControl(true);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public boolean getAutoSize() {
        return this.autoSize;
    }

    @Override
    public void nullControl() {
        try {
            this.setAutoSize(false);
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        super.nullControl();
    }

    public void setFont(Object f) throws VisADException, RemoteException {
        if (!(f instanceof Font) && !(f instanceof HersheyFont) && f != null) {
            throw new VisADException("Font must be java.awt.Font or HersheyFont");
        }
        this.font = f;
        this.changeControl(true);
    }

    public Font getFont() {
        if (this.font instanceof Font) {
            return (Font)this.font;
        }
        return null;
    }

    public HersheyFont getHersheyFont() {
        if (this.font instanceof HersheyFont) {
            return (HersheyFont)this.font;
        }
        return null;
    }

    public void setCenter(boolean c) throws VisADException, RemoteException {
        this.justification = Justification.CENTER;
        this.changeControl(true);
    }

    public boolean getCenter() {
        return this.justification == Justification.CENTER;
    }

    public void setJustification(Justification newJustification) throws VisADException, RemoteException {
        this.justification = newJustification;
        this.changeControl(true);
    }

    public Justification getJustification() {
        return this.justification;
    }

    public void setVerticalJustification(Justification newJustification) throws VisADException, RemoteException {
        this.verticalJustification = newJustification;
        this.changeControl(true);
    }

    public Justification getVerticalJustification() {
        return this.verticalJustification;
    }

    public void setSize(double s) throws VisADException, RemoteException {
        this.factor = s;
        this.size = this.factor * this.autoSizeFactor;
        this.changeControl(true);
    }

    private void setSizeForAuto(double autoSizeFactor) throws VisADException, RemoteException {
        this.autoSizeFactor = autoSizeFactor;
        this.size = this.factor * autoSizeFactor;
        this.changeControl(true);
    }

    public double getSize() {
        return this.size;
    }

    public void setSphere(boolean s) throws VisADException, RemoteException {
        this.sphere = s;
        this.changeControl(true);
    }

    public boolean getSphere() {
        return this.sphere;
    }

    public void setNumberFormat(NumberFormat f) throws VisADException, RemoteException {
        this.format = f;
        this.changeControl(true);
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    private boolean fontEquals(Object newFont) {
        if (this.font == null) {
            if (newFont != null) {
                return false;
            }
        } else {
            if (newFont == null) {
                return false;
            }
            if (!this.font.equals(newFont)) {
                return false;
            }
        }
        return true;
    }

    private boolean formatEquals(NumberFormat newFormat) {
        if (this.format == null) {
            if (newFormat != null) {
                return false;
            }
        } else {
            if (newFormat == null) {
                return false;
            }
            if (!this.format.equals(newFormat)) {
                return false;
            }
        }
        return true;
    }

    public void setRotation(double newRotation) throws VisADException, RemoteException {
        this.rotation = newRotation;
        this.changeControl(true);
    }

    public double getRotation() {
        return this.rotation;
    }

    @Override
    public String getSaveString() {
        return null;
    }

    @Override
    public void setSaveString(String save) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    @Override
    public void syncControl(Control rmt) throws VisADException {
        if (rmt == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(rmt instanceof TextControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + rmt.getClass().getName());
        }
        TextControl tc = (TextControl)rmt;
        boolean changed = false;
        if (!this.fontEquals(tc.font)) {
            changed = true;
            this.font = tc.font;
        }
        if (this.justification != tc.justification) {
            changed = true;
            this.justification = tc.justification;
        }
        if (this.verticalJustification != tc.verticalJustification) {
            changed = true;
            this.verticalJustification = tc.verticalJustification;
        }
        if (!Util.isApproximatelyEqual(this.size, tc.size)) {
            changed = true;
            this.size = tc.size;
        }
        if (this.sphere != tc.sphere) {
            changed = true;
            this.sphere = tc.sphere;
        }
        if (!this.formatEquals(tc.format)) {
            changed = true;
            this.format = tc.format;
        }
        if (!Util.isApproximatelyEqual(this.rotation, tc.rotation)) {
            changed = true;
            this.rotation = tc.rotation;
        }
        if (!Util.isApproximatelyEqual(this.characterRotation, tc.characterRotation)) {
            changed = true;
            this.characterRotation = tc.characterRotation;
        }
        if (this.autoSize != tc.autoSize) {
            this.setAutoSize(tc.autoSize);
        }
        if (!Util.isApproximatelyEqual(this.scale, tc.scale)) {
            changed = true;
            this.scale = tc.scale;
        }
        for (int i = 0; i < 3; ++i) {
            if (Util.isApproximatelyEqual(this.offset[i], tc.offset[i])) continue;
            changed = true;
            this.offset[i] = tc.offset[i];
        }
        if (changed) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException re) {
                throw new VisADException("Could not indicate that control changed: " + re.getMessage());
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TextControl tc = (TextControl)o;
        if (!this.fontEquals(this.font)) {
            return false;
        }
        if (this.justification != tc.justification) {
            return false;
        }
        if (this.verticalJustification != tc.verticalJustification) {
            return false;
        }
        if (this.sphere != tc.sphere) {
            return false;
        }
        if (!this.formatEquals(tc.format)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.rotation, tc.rotation)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.size, tc.size)) {
            return false;
        }
        if (this.autoSize != tc.autoSize) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.characterRotation, tc.characterRotation)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.scale, tc.scale)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (Util.isApproximatelyEqual(this.offset[i], tc.offset[i])) continue;
            return false;
        }
        return true;
    }

    public double getCharacterRotation() {
        return this.characterRotation;
    }

    public void setCharacterRotation(double argCharacterRotation) throws VisADException, RemoteException {
        this.characterRotation = argCharacterRotation;
        this.changeControl(true);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double argScale) throws VisADException, RemoteException {
        this.scale = argScale;
        this.changeControl(true);
    }

    public double[] getOffset() {
        double[] aOffset = new double[]{this.offset[0], this.offset[1], this.offset[2]};
        return aOffset;
    }

    public void setOffset(double[] argOffset) throws VisADException, RemoteException {
        this.offset[0] = argOffset[0];
        this.offset[1] = argOffset[1];
        this.offset[2] = argOffset[2];
        this.changeControl(true);
    }

    class ProjectionControlListener
    implements ControlListener {
        private boolean pfirst = true;
        private MouseBehavior mouse;
        private ProjectionControl pcontrol;
        private TextControl text_control;
        private double base_scale = 1.0;
        private float last_cscale = 1.0f;
        private boolean active = false;

        ProjectionControlListener(MouseBehavior m, TextControl t, ProjectionControl p) {
            this.mouse = m;
            this.text_control = t;
            this.pcontrol = p;
        }

        public void setActive(boolean onoroff) {
            this.active = onoroff;
        }

        @Override
        public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
            if (!this.active) {
                return;
            }
            double[] matrix = this.pcontrol.getMatrix();
            double[] rot = new double[3];
            double[] scale = new double[3];
            double[] trans = new double[3];
            this.mouse.instance_unmake_matrix(rot, scale, trans, matrix);
            if (this.pfirst) {
                this.pfirst = false;
                this.base_scale = scale[2];
                this.last_cscale = 1.0f;
            } else {
                float cscale = (float)(this.base_scale / scale[2]);
                float ratio = cscale / this.last_cscale;
                if (ratio < 0.95f || 1.05f < ratio) {
                    this.last_cscale = cscale;
                    this.text_control.setSizeForAuto(cscale);
                }
            }
        }
    }

    public static class Justification {
        private String name;
        public static final Justification LEFT = new Justification("Left");
        public static final Justification CENTER = new Justification("Center");
        public static final Justification RIGHT = new Justification("Right");
        public static final Justification TOP = new Justification("Top");
        public static final Justification BOTTOM = new Justification("Bottom");

        public Justification(String newName) {
            this.name = newName;
        }
    }
}

