/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Enumeration;
import visad.CoordinateSystem;
import visad.DataShadow;
import visad.Display;
import visad.ErrorEstimate;
import visad.MathType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowSetType;
import visad.ShadowType;
import visad.SimpleSetIface;
import visad.Unit;
import visad.VisADException;

public abstract class SimpleSet
extends Set
implements SimpleSetIface {
    int ManifoldDimension;

    public SimpleSet(MathType type, int manifold_dimension) throws VisADException {
        this(type, manifold_dimension, null, null, null);
    }

    public SimpleSet(MathType type, int manifold_dimension, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, coord_sys, units, errors);
        this.ManifoldDimension = manifold_dimension;
        if (this.ManifoldDimension > this.DomainDimension || this.ManifoldDimension < 0) {
            throw new SetException("SimpleSet: bad ManifoldDimension" + this.ManifoldDimension);
        }
    }

    public SimpleSet(MathType type) throws VisADException {
        this(type, null, null, null);
    }

    public SimpleSet(MathType type, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, coord_sys, units, errors);
        this.ManifoldDimension = this.DomainDimension;
    }

    @Override
    public int getManifoldDimension() {
        return this.ManifoldDimension;
    }

    @Override
    void setAnimationSampling(ShadowType type, DataShadow shadow, boolean domain) throws VisADException {
        ShadowRealType real;
        if (shadow.isAnimationSampling(domain)) {
            return;
        }
        if (this.DomainDimension != 1) {
            return;
        }
        if (type instanceof ShadowRealType) {
            real = (ShadowRealType)type;
        } else if (type instanceof ShadowSetType) {
            ShadowRealTupleType tuple = ((ShadowSetType)type).getDomain();
            if (tuple.getDimension() != 1) {
                return;
            }
            real = (ShadowRealType)tuple.getComponent(0);
        } else if (type instanceof ShadowRealTupleType) {
            if (((ShadowRealTupleType)type).getDimension() != 1) {
                return;
            }
            real = (ShadowRealType)((ShadowRealTupleType)type).getComponent(0);
        } else {
            return;
        }
        Enumeration maps = real.getSelectedMapVector().elements();
        while (maps.hasMoreElements()) {
            ScalarMap map = (ScalarMap)maps.nextElement();
            if (!map.getDisplayScalar().equals(Display.Animation)) continue;
            shadow.setAnimationSampling(this, domain);
            return;
        }
    }

    @Override
    public abstract void valueToInterp(float[][] var1, int[][] var2, float[][] var3) throws VisADException;
}

