/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.RemoteDataReference;
import visad.RemoteDataReferenceImpl;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteServer;
import visad.RemoteVisADException;
import visad.VisADException;

public class RemoteServerImpl
extends UnicastRemoteObject
implements RemoteServer {
    private RemoteDataReferenceImpl[] refs;
    private RemoteDisplayImpl[] dpys;

    public RemoteServerImpl() throws RemoteException {
        this(null, null);
    }

    public RemoteServerImpl(RemoteDataReferenceImpl[] rs) throws RemoteException {
        this(rs, null);
    }

    public RemoteServerImpl(RemoteDisplayImpl[] rd) throws RemoteException {
        this(null, rd);
    }

    public RemoteServerImpl(RemoteDataReferenceImpl[] rs, RemoteDisplayImpl[] rd) throws RemoteException {
        this.refs = rs;
        this.dpys = rd;
    }

    @Override
    public synchronized RemoteDataReference getDataReference(int index) throws RemoteException {
        if (this.refs != null && 0 <= index && index < this.refs.length) {
            return this.refs[index];
        }
        return null;
    }

    @Override
    public synchronized RemoteDataReference getDataReference(String name) throws VisADException, RemoteException {
        if (name != null && this.refs != null) {
            for (int i = 0; i < this.refs.length; ++i) {
                if (!name.equals(this.refs[i].getName())) continue;
                return this.refs[i];
            }
        }
        return null;
    }

    @Override
    public synchronized RemoteDataReference[] getDataReferences() throws RemoteException {
        if (this.refs == null || this.refs.length == 0) {
            return null;
        }
        RemoteDataReference[] rs = new RemoteDataReference[this.refs.length];
        for (int i = 0; i < this.refs.length; ++i) {
            rs[i] = this.refs[i];
        }
        return rs;
    }

    public synchronized void setDataReference(int index, RemoteDataReferenceImpl ref) throws VisADException {
        if (index < 0) {
            throw new RemoteVisADException("RemoteServerImpl.setDataReference: negative index");
        }
        if (this.refs == null || index >= this.refs.length) {
            RemoteDataReferenceImpl[] rs = new RemoteDataReferenceImpl[index + 1];
            for (int i = 0; i < index; ++i) {
                rs[i] = this.refs != null && i < this.refs.length ? this.refs[i] : null;
            }
            this.refs = rs;
        }
        this.refs[index] = ref;
    }

    public void addDataReference(DataReferenceImpl ref) throws RemoteException {
        this.addDataReference(new RemoteDataReferenceImpl(ref));
    }

    @Override
    public synchronized void addDataReference(RemoteDataReferenceImpl ref) {
        if (ref == null) {
            return;
        }
        int len = this.refs == null || this.refs.length == 0 ? 0 : this.refs.length;
        RemoteDataReferenceImpl[] nr = new RemoteDataReferenceImpl[len + 1];
        if (len > 0) {
            System.arraycopy(this.refs, 0, nr, 0, len);
        }
        nr[len] = ref;
        this.refs = nr;
    }

    @Override
    public synchronized void setDataReferences(RemoteDataReferenceImpl[] rs) {
        if (rs == null) {
            this.refs = null;
            return;
        }
        this.refs = new RemoteDataReferenceImpl[rs.length];
        for (int i = 0; i < this.refs.length; ++i) {
            this.refs[i] = rs[i];
        }
    }

    @Override
    public synchronized void removeDataReference(RemoteDataReferenceImpl ref) {
        int len = this.refs == null || this.refs.length == 0 ? 0 : this.refs.length;
        int index = -1;
        for (int i = 0; i < len; ++i) {
            if (this.refs[i] != ref) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        RemoteDataReferenceImpl[] nr = new RemoteDataReferenceImpl[len - 1];
        if (index > 0) {
            System.arraycopy(this.refs, 0, nr, 0, index);
        }
        if (index < len - 1) {
            System.arraycopy(this.refs, index + 1, nr, index, len - index - 1);
        }
        this.refs = nr;
    }

    @Override
    public RemoteDisplay[] getDisplays() throws RemoteException {
        if (this.dpys == null || this.dpys.length == 0) {
            return null;
        }
        RemoteDisplay[] rd = new RemoteDisplay[this.dpys.length];
        for (int i = 0; i < this.dpys.length; ++i) {
            rd[i] = this.dpys[i];
        }
        return rd;
    }

    @Override
    public RemoteDisplay getDisplay(int index) {
        if (this.dpys != null && index >= 0 && index < this.dpys.length) {
            return this.dpys[index];
        }
        return null;
    }

    @Override
    public RemoteDisplay getDisplay(String name) throws VisADException, RemoteException {
        if (this.dpys == null) {
            throw new RemoteException("No displays associated with this server");
        }
        for (int i = 0; i < this.dpys.length; ++i) {
            if (this.dpys[i] == null || !this.dpys[i].getName().equals(name)) continue;
            return this.dpys[i];
        }
        throw new RemoteException("Display \"" + name + "\" not found");
    }

    public void addDisplay(DisplayImpl di) throws RemoteException {
        this.addDisplay(new RemoteDisplayImpl(di));
    }

    @Override
    public synchronized void addDisplay(RemoteDisplayImpl rd) {
        if (rd == null) {
            return;
        }
        int len = this.dpys == null || this.dpys.length == 0 ? 0 : this.dpys.length;
        RemoteDisplayImpl[] nd = new RemoteDisplayImpl[len + 1];
        if (len > 0) {
            System.arraycopy(this.dpys, 0, nd, 0, len);
        }
        nd[len] = rd;
        this.dpys = nd;
    }

    @Override
    public synchronized void setDisplays(RemoteDisplayImpl[] rd) {
        if (rd == null) {
            this.dpys = null;
            return;
        }
        this.dpys = new RemoteDisplayImpl[rd.length];
        for (int i = 0; i < this.dpys.length; ++i) {
            this.dpys[i] = rd[i];
        }
    }

    @Override
    public synchronized void removeDisplay(RemoteDisplayImpl rd) {
        int len = this.dpys == null || this.dpys.length == 0 ? 0 : this.dpys.length;
        int index = -1;
        for (int i = 0; i < len; ++i) {
            if (this.dpys[i] != rd) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return;
        }
        RemoteDisplayImpl[] nd = new RemoteDisplayImpl[len - 1];
        if (index > 0) {
            System.arraycopy(this.dpys, 0, nd, 0, index);
        }
        if (index < len - 1) {
            System.arraycopy(this.dpys, index + 1, nd, index, len - index - 1);
        }
        this.dpys = nd;
    }
}

