/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CommonUnit;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.SI;
import visad.ScalarType;
import visad.Set;
import visad.SetException;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class RealType
extends ScalarType {
    private static final long serialVersionUID = 1L;
    private Unit DefaultUnit;
    private Set DefaultSet;
    private boolean DefaultSetEverAccessed;
    private final int attrMask;
    public static final int INTERVAL = 1;
    private static int count;
    public static final RealType XAxis;
    public static final RealType YAxis;
    public static final RealType ZAxis;
    public static final RealType Latitude;
    public static final RealType Longitude;
    public static final RealType Altitude;
    public static final RealType Radius;
    public static final RealType TimeInterval;
    public static final RealType Time;
    public static final RealType Declination;
    public static final RealType RightAscension;
    public static final RealType Generic;

    public RealType(String name) throws VisADException {
        this(name, 0);
    }

    public RealType(String name, int attrMask) throws VisADException {
        this(name, null, null, attrMask);
    }

    public RealType(String name, Unit u, Set set) throws VisADException {
        this(name, u, set, 0);
    }

    public RealType(String name, Unit u) throws VisADException {
        this(name, u, null, 0);
    }

    public RealType(String name, Unit u, Set set, int attrMask) throws VisADException {
        super(name);
        Unit[] us;
        if (set != null && set.getDimension() != 1) {
            throw new SetException("RealType: default set dimension != 1");
        }
        this.DefaultUnit = u != null && RealType.isSet(attrMask, 1) ? u.getAbsoluteUnit() : u;
        this.DefaultSet = set;
        this.DefaultSetEverAccessed = false;
        if (this.DefaultUnit != null && this.DefaultSet != null && !Unit.canConvertArray(us = new Unit[]{this.DefaultUnit}, this.DefaultSet.getSetUnits())) {
            throw new UnitException("RealType: default Unit must be convertable with Set default Unit");
        }
        this.attrMask = attrMask;
    }

    protected RealType(String name, Unit u, boolean b) {
        this(name, u, 0, b);
    }

    protected RealType(String name, Unit u, int attrMask, boolean b) {
        super(name, b);
        this.DefaultUnit = u != null && RealType.isSet(attrMask, 1) ? u.getAbsoluteUnit() : u;
        this.DefaultSet = null;
        this.DefaultSetEverAccessed = false;
        this.attrMask = attrMask;
    }

    protected RealType(String name, Unit u, Set s, int attrMask, boolean b) throws SetException {
        super(name, b);
        if (s != null && s.getDimension() != 1) {
            throw new SetException("RealType: default set dimension != 1");
        }
        this.DefaultUnit = u != null && RealType.isSet(attrMask, 1) ? u.getAbsoluteUnit() : u;
        this.DefaultSet = s;
        this.DefaultSetEverAccessed = false;
        this.attrMask = attrMask;
    }

    public final int getAttributeMask() {
        return this.attrMask;
    }

    public final boolean isInterval() {
        return RealType.isSet(this.getAttributeMask(), 1);
    }

    private static boolean isSet(int value, int mask) {
        return (value & mask) == mask;
    }

    public Unit getDefaultUnit() {
        return this.DefaultUnit;
    }

    public synchronized Set getDefaultSet() {
        this.DefaultSetEverAccessed = true;
        return this.DefaultSet;
    }

    public synchronized void setDefaultSet(Set sampling) throws VisADException {
        Unit[] us;
        if (sampling.getDimension() != 1) {
            throw new SetException("RealType.setDefaultSet: default set dimension != 1");
        }
        if (this.DefaultSetEverAccessed) {
            throw new TypeException("RealType: DefaultSet already accessed so cannot change");
        }
        this.DefaultSet = sampling;
        if (this.DefaultUnit != null && this.DefaultSet != null && !Unit.canConvertArray(us = new Unit[]{this.DefaultUnit}, this.DefaultSet.getSetUnits())) {
            throw new UnitException("RealType: default Unit must be convertable with Set default Unit");
        }
    }

    @Override
    public boolean equals(Object type) {
        if (!(type instanceof RealType)) {
            return false;
        }
        if (!this.Name.equals(((RealType)type).Name)) {
            return false;
        }
        if (this.DefaultUnit == null ? ((RealType)type).DefaultUnit != null : !Unit.canConvert(this.DefaultUnit, ((RealType)type).DefaultUnit)) {
            return false;
        }
        if (this.DefaultSet == null ? ((RealType)type).DefaultSet != null : !this.DefaultSet.equals(((RealType)type).DefaultSet)) {
            return false;
        }
        return this.attrMask == ((RealType)type).attrMask;
    }

    @Override
    public boolean equalsExceptName(MathType type) {
        if (type instanceof RealTupleType) {
            try {
                return ((RealTupleType)type).getDimension() == 1 && ((RealTupleType)type).getComponent(0) instanceof RealType;
            }
            catch (VisADException e) {
                return false;
            }
        }
        return type instanceof RealType;
    }

    @Override
    public boolean equalsExceptNameButUnits(MathType type) {
        try {
            if (type instanceof RealTupleType && ((RealTupleType)type).getDimension() == 1 && ((RealTupleType)type).getComponent(0) instanceof RealType) {
                RealType rt = (RealType)((RealTupleType)type).getComponent(0);
                return Unit.canConvert(this.getDefaultUnit(), rt.getDefaultUnit());
            }
        }
        catch (VisADException e) {
            return false;
        }
        if (!(type instanceof RealType)) {
            return false;
        }
        return Unit.canConvert(this.getDefaultUnit(), ((RealType)type).getDefaultUnit());
    }

    @Override
    public MathType cloneDerivative(RealType d_partial) throws VisADException {
        String newName = "d_" + this.getName() + "_" + "d_" + d_partial.getName();
        RealType newType = null;
        Unit R_unit = this.DefaultUnit;
        Unit D_unit = d_partial.getDefaultUnit();
        Unit u = null;
        if (R_unit != null && D_unit != null) {
            u = R_unit.divide(D_unit);
        }
        newType = RealType.getRealType(newName, u);
        return newType;
    }

    @Override
    public MathType binary(MathType type, int op, Vector names) throws VisADException {
        MathType newType;
        block34: {
            block33: {
                if (type == null) {
                    throw new TypeException("TupleType.binary: type may not be null");
                }
                Unit newUnit = null;
                newType = null;
                if (!(type instanceof RealType)) break block33;
                RealType that = (RealType)type;
                Unit unit = ((RealType)type).getDefaultUnit();
                Unit thisUnit = this.DefaultUnit;
                int newAttrMask = 0;
                switch (op) {
                    case 2: 
                    case 3: {
                        if (this.isInterval() == that.isInterval()) break;
                        newAttrMask |= 1;
                        break;
                    }
                    case 1: 
                    case 9: 
                    case 10: {
                        if (!this.isInterval() || !that.isInterval()) break;
                        newAttrMask |= 1;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 15: 
                    case 16: {
                        if (this.isInterval() == that.isInterval()) break;
                        newAttrMask |= 1;
                        break;
                    }
                    case 7: {
                        newAttrMask = this.getAttributeMask();
                        break;
                    }
                    case 8: {
                        newAttrMask = that.getAttributeMask();
                        break;
                    }
                }
                switch (op) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        String newName;
                        if (CommonUnit.promiscuous.equals(unit)) {
                            newType = this;
                            break;
                        }
                        if (CommonUnit.promiscuous.equals(thisUnit)) {
                            newType = type;
                            break;
                        }
                        if (thisUnit == null || unit == null) {
                            newUnit = null;
                            newName = thisUnit == null && unit == null ? this.Name : RealType.getUniqueGenericName(names, newUnit);
                        } else {
                            if (!thisUnit.isConvertible(unit)) {
                                throw new UnitException();
                            }
                            newUnit = thisUnit;
                            newName = this.Name;
                        }
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        if (newType == null) {
                            newType = RealType.getRealType(RealType.newName(newUnit), newUnit, newAttrMask);
                            break;
                        }
                        break block34;
                    }
                    case 4: {
                        if (CommonUnit.promiscuous.equals(unit) || CommonUnit.dimensionless.isConvertible(unit)) {
                            newType = this;
                            break;
                        }
                        if (CommonUnit.promiscuous.equals(thisUnit) || CommonUnit.dimensionless.isConvertible(thisUnit)) {
                            newType = type;
                            break;
                        }
                        newUnit = unit != null && thisUnit != null ? thisUnit.multiply(unit) : null;
                        String newName = RealType.getUniqueGenericName(names, newUnit);
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        break;
                    }
                    case 5: {
                        if (CommonUnit.promiscuous.equals(unit) || CommonUnit.dimensionless.isConvertible(unit)) {
                            newType = this;
                            break;
                        }
                        newUnit = unit != null && thisUnit != null ? thisUnit.divide(unit) : null;
                        String newName = RealType.getUniqueGenericName(names, newUnit);
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        break;
                    }
                    case 6: {
                        if (CommonUnit.promiscuous.equals(thisUnit) || CommonUnit.dimensionless.isConvertible(thisUnit)) {
                            newType = type;
                            break;
                        }
                        newUnit = unit != null && thisUnit != null ? unit.divide(thisUnit) : null;
                        String newName = RealType.getUniqueGenericName(names, newUnit);
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        break;
                    }
                    case 7: {
                        newUnit = thisUnit != null && CommonUnit.dimensionless.equals(thisUnit) ? CommonUnit.dimensionless : CommonUnit.promiscuous;
                        String newName = RealType.getUniqueGenericName(names, newUnit);
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        break;
                    }
                    case 8: {
                        newUnit = unit != null && unit.equals(CommonUnit.dimensionless) ? CommonUnit.dimensionless : CommonUnit.promiscuous;
                        String newName = RealType.getUniqueGenericName(names, newUnit);
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        break;
                    }
                    case 11: 
                    case 13: {
                        newUnit = CommonUnit.radian;
                        String newName = RealType.getUniqueGenericName(names, newUnit);
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        break;
                    }
                    case 12: 
                    case 14: {
                        newUnit = CommonUnit.degree;
                        String newName = RealType.getUniqueGenericName(names, newUnit);
                        newType = RealType.getRealType(newName, newUnit, newAttrMask);
                        break;
                    }
                    case 15: {
                        newType = this;
                        break;
                    }
                    case 16: {
                        newType = type;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("RealType.binary: illegal operation");
                    }
                }
                break block34;
            }
            if (type instanceof TextType) {
                throw new TypeException("RealType.binary: types don't match");
            }
            if (type instanceof TupleType) {
                return type.binary(this, DataImpl.invertOp(op), names);
            }
            if (type instanceof FunctionType) {
                return type.binary(this, DataImpl.invertOp(op), names);
            }
        }
        return newType;
    }

    private static String newName(Unit unit) {
        return "RealType_" + Integer.toString(++count) + "_" + (unit == null ? "nullUnit" : unit.toString());
    }

    @Override
    public MathType unary(int op, Vector names) throws VisADException {
        RealType newType;
        int newAttrMask;
        switch (op) {
            case 21: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 41: 
            case 42: {
                newAttrMask = this.getAttributeMask();
                break;
            }
            default: {
                newAttrMask = 0;
            }
        }
        switch (op) {
            case 21: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 41: 
            case 42: {
                newType = this;
                break;
            }
            case 22: 
            case 24: 
            case 26: {
                Unit newUnit = CommonUnit.radian;
                String newName = RealType.getUniqueGenericName(names, newUnit);
                newType = RealType.getRealType(newName, newUnit, newAttrMask);
                break;
            }
            case 23: 
            case 25: 
            case 27: {
                Unit newUnit = CommonUnit.degree;
                String newName = RealType.getUniqueGenericName(names, newUnit);
                newType = RealType.getRealType(newName, newUnit, newAttrMask);
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                Unit newUnit = Unit.canConvert(CommonUnit.dimensionless, this.DefaultUnit) ? CommonUnit.dimensionless : null;
                String newName = RealType.getUniqueGenericName(names, newUnit);
                newType = RealType.getRealType(newName, newUnit, newAttrMask);
                break;
            }
            case 38: {
                Unit newUnit = Unit.canConvert(CommonUnit.dimensionless, this.DefaultUnit) ? CommonUnit.dimensionless : (this.DefaultUnit == null ? null : this.DefaultUnit.sqrt());
                String newName = RealType.getUniqueGenericName(names, newUnit);
                newType = RealType.getRealType(newName, newUnit, newAttrMask);
                break;
            }
            default: {
                throw new ArithmeticException("RealType.unary: illegal operation");
            }
        }
        return newType;
    }

    private static String getUniqueGenericName(Vector names, String ext) {
        String name = null;
        if (ext.indexOf(".") > -1) {
            ext = ext.replace('.', '_');
        }
        if (ext.indexOf(" ") > -1) {
            ext = ext.replace(' ', '_');
        }
        if (ext.indexOf("(") > -1) {
            ext = ext.replace('(', '_');
        }
        if (ext.indexOf(")") > -1) {
            ext = ext.replace(')', '_');
        }
        int ii = 1;
        while (true) {
            if (!names.contains(name = "Generic_" + ii + "_" + ext)) break;
            ++ii;
        }
        names.addElement(name);
        return name;
    }

    private static String getUniqueGenericName(Vector names, Unit unit) {
        return RealType.getUniqueGenericName(names, unit == null ? "nullUnit" : unit.toString());
    }

    @Override
    public Data missingData() throws VisADException {
        return new Real(this);
    }

    public static final RealType getRealType(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        RealType rt = RealType.getRealTypeByName(name);
        if (rt == null) {
            try {
                rt = new RealType(name);
            }
            catch (VisADException e) {
                rt = RealType.getRealTypeByName(name);
            }
        }
        return rt;
    }

    public static final RealType getRealType(String name, Unit u) {
        RealType rt;
        block6: {
            if (name == null) {
                throw new NullPointerException();
            }
            rt = RealType.getRealTypeByName(name);
            if (rt != null) {
                if (!Unit.canConvert(u, rt.DefaultUnit)) {
                    rt = null;
                }
            } else {
                try {
                    rt = new RealType(name, u);
                }
                catch (VisADException e) {
                    rt = RealType.getRealTypeByName(name);
                    if (rt == null || Unit.canConvert(u, rt.DefaultUnit)) break block6;
                    rt = null;
                }
            }
        }
        return rt;
    }

    public static RealType getRealType(String name, int attrMask) {
        RealType rt;
        block6: {
            if (name == null) {
                throw new NullPointerException();
            }
            rt = RealType.getRealTypeByName(name);
            if (rt != null) {
                if (attrMask != rt.attrMask) {
                    rt = null;
                }
            } else {
                try {
                    rt = new RealType(name, attrMask);
                }
                catch (VisADException e) {
                    rt = RealType.getRealTypeByName(name);
                    if (rt == null || attrMask == rt.attrMask) break block6;
                    rt = null;
                }
            }
        }
        return rt;
    }

    public static RealType getRealType(String name, Unit u, Set set) {
        RealType rt;
        block6: {
            if (name == null) {
                throw new NullPointerException();
            }
            rt = RealType.getRealTypeByName(name);
            if (rt != null) {
                if (!Unit.canConvert(u, rt.DefaultUnit) || (set == null ? rt.DefaultSet != null : !set.equals(rt.DefaultSet))) {
                    rt = null;
                }
            } else {
                try {
                    rt = new RealType(name, u, set);
                }
                catch (VisADException e) {
                    rt = RealType.getRealTypeByName(name);
                    if (rt == null || Unit.canConvert(u, rt.DefaultUnit) && !(set == null ? rt.DefaultSet != null : !set.equals(rt.DefaultSet))) break block6;
                    rt = null;
                }
            }
        }
        return rt;
    }

    public static final RealType getRealType(String name, Unit u, int attrMask) {
        RealType rt;
        block6: {
            if (name == null) {
                throw new NullPointerException();
            }
            rt = RealType.getRealTypeByName(name);
            if (rt != null) {
                if (!Unit.canConvert(u, rt.DefaultUnit) || rt.attrMask != attrMask) {
                    rt = null;
                }
            } else {
                try {
                    rt = new RealType(name, u, null, attrMask);
                }
                catch (VisADException e) {
                    rt = RealType.getRealTypeByName(name);
                    if (rt == null || Unit.canConvert(u, rt.DefaultUnit) && rt.attrMask == attrMask) break block6;
                    rt = null;
                }
            }
        }
        return rt;
    }

    public static final RealType getRealType(String name, Unit u, Set set, int attrMask) {
        RealType rt;
        block6: {
            if (name == null) {
                throw new NullPointerException();
            }
            rt = RealType.getRealTypeByName(name);
            if (rt != null) {
                if (!Unit.canConvert(u, rt.DefaultUnit) || (set != null ? !set.equals(rt.DefaultSet) : rt.DefaultSet != null) || rt.attrMask != attrMask) {
                    rt = null;
                }
            } else {
                try {
                    rt = new RealType(name, u, set, attrMask);
                }
                catch (VisADException e) {
                    rt = RealType.getRealTypeByName(name);
                    if (rt == null || Unit.canConvert(u, rt.DefaultUnit) && !(set != null ? !set.equals(rt.DefaultSet) : rt.DefaultSet != null) && rt.attrMask == attrMask) break block6;
                    rt = null;
                }
            }
        }
        return rt;
    }

    public static RealType getRealTypeByName(String name) {
        ScalarType real = ScalarType.getScalarTypeByName(name);
        if (!(real instanceof RealType)) {
            return null;
        }
        return (RealType)real;
    }

    @Override
    public ShadowType buildShadowType(DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return link.getRenderer().makeShadowRealType(this, link, parent);
    }

    @Override
    public String prettyString(int indent) {
        return this.getName();
    }

    public static void main(String[] args) throws VisADException {
        RealType real_R = new RealType("Red_Brightness", null, null);
        RealType real_G = new RealType("Green_Brightness", null, null);
        RealType real_B = new RealType("Blue_Brightness", null, null);
        RealType[] reals = new RealType[]{real_R, real_G, real_B};
        RealTupleType RGBtuple = new RealTupleType(reals);
        MathType m_type = RGBtuple.unary(29, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.unary(30, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.unary(21, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.unary(22, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.unary(23, new Vector());
        System.out.println(m_type.toString());
        RealType real_A = new RealType("distance", (Unit)SI.meter, null);
        m_type = real_A.unary(31, new Vector());
        System.out.println(m_type.toString());
        real_A = Generic;
        m_type = RGBtuple.binary(real_A, 1, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.binary(real_A, 4, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.binary(real_A, 7, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.binary(real_A, 11, new Vector());
        System.out.println(m_type.toString());
        m_type = RGBtuple.binary(real_A, 12, new Vector());
        System.out.println(m_type.toString());
        System.out.println("force a TypeException:");
        RealType r = new RealType("a.b");
    }

    static {
        XAxis = new RealType("XAxis", null, true);
        YAxis = new RealType("YAxis", null, true);
        ZAxis = new RealType("ZAxis", null, true);
        Latitude = new RealType("Latitude", CommonUnit.degree, true);
        Longitude = new RealType("Longitude", CommonUnit.degree, true);
        Altitude = new RealType("Altitude", CommonUnit.meter, true);
        Radius = new RealType("Radius", null, true);
        TimeInterval = new RealType("TimeInterval", CommonUnit.second, 1, true);
        Time = new RealType("Time", CommonUnit.secondsSinceTheEpoch, true);
        Declination = new RealType("Declination", CommonUnit.degree, true);
        RightAscension = new RealType("RightAscension", CommonUnit.degree, true);
        Generic = new RealType("GENERIC_REAL", CommonUnit.promiscuous, true);
    }
}

