/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.OffsetUnit;
import visad.PromiscuousUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class LogarithmicUnit
extends Unit
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Unit ONE = new DerivedUnit();
    private final Unit reference;
    private final double base;
    private final transient double lnBase;

    private LogarithmicUnit(double base, Unit reference) {
        this(reference, base, "");
    }

    private LogarithmicUnit(Unit reference, double base, String identifier) {
        super(identifier);
        if (reference == null) {
            throw new NullPointerException("Null reference level");
        }
        if (base != 2.0 && base != Math.E && base != 10.0) {
            throw new IllegalArgumentException("Invalid logarithmic base: " + base);
        }
        this.reference = reference;
        this.base = base;
        this.lnBase = base == Math.E ? 1.0 : Math.log(base);
    }

    static Unit getInstance(double base, Unit reference) {
        return new LogarithmicUnit(base, reference);
    }

    @Override
    public boolean isDimensionless() {
        return true;
    }

    protected boolean isTime() {
        return SI.second.isConvertible(this.reference);
    }

    @Override
    protected Unit protectedClone(String identifier) {
        return new LogarithmicUnit(this.reference, this.base, identifier);
    }

    @Override
    public Unit scale(double scale) throws UnitException {
        return ScaledUnit.getInstance(scale, this);
    }

    @Override
    public Unit shift(double offset) throws UnitException {
        return OffsetUnit.getInstance(offset, this);
    }

    @Override
    public Unit log(double base) throws UnitException {
        throw new UnitException("Can't form logarithmic unit from logarithmic unit: " + this);
    }

    @Override
    public Unit pow(int power) {
        Unit result;
        if (power == 0) {
            result = ONE;
        } else if (power == 1) {
            result = this;
        } else {
            throw new IllegalArgumentException("Invalid power: " + power);
        }
        return result;
    }

    @Override
    public Unit pow(double power) {
        if (power != 0.0 || power != 1.0) {
            throw new IllegalArgumentException("Invalid power: " + power);
        }
        return this.pow((int)Math.round(power));
    }

    @Override
    public Unit root(int root) throws IllegalArgumentException {
        if (root != 1) {
            throw new IllegalArgumentException("Invalid root: " + root);
        }
        return this;
    }

    @Override
    public String getDefinition() {
        StringBuilder buf = new StringBuilder(40);
        if (this.base == 2.0) {
            buf.append("lb");
        } else if (this.base == Math.E) {
            buf.append("ln");
        } else if (this.base == 10.0) {
            buf.append("lg");
        } else {
            throw new AssertionError((Object)("Invalid base: " + this.base));
        }
        buf.append("(re ");
        buf.append(this.reference.toString());
        buf.append(")");
        return buf.toString();
    }

    @Override
    public Unit multiply(Unit that) throws UnitException {
        Unit result;
        if (!that.isDimensionless()) {
            throw new IllegalArgumentException("Not dimensionless: " + that);
        }
        if (that.equals(ONE)) {
            result = this;
        } else {
            if (that instanceof LogarithmicUnit) {
                throw new UnitException("Can't multiply by: " + that);
            }
            result = that.multiply(this);
        }
        return result;
    }

    @Override
    public Unit divide(Unit that) throws UnitException {
        Unit result;
        if (!that.isDimensionless()) {
            throw new IllegalArgumentException("Not dimensionless: " + that);
        }
        if (that.equals(ONE)) {
            result = this;
        } else {
            if (that instanceof LogarithmicUnit) {
                throw new UnitException("Can't divide by: " + that);
            }
            result = that.divideInto(this);
        }
        return result;
    }

    @Override
    protected Unit divideInto(Unit that) throws UnitException {
        throw new UnitException("Can't divide into: " + that);
    }

    @Override
    public double[] toThis(double[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public float[] toThis(float[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public double[] toThis(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (double[])values.clone() : values;
        } else {
            newValues = that.toThat(values, this.reference, copy);
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = Math.log(newValues[i]) / this.lnBase;
            }
        }
        return newValues;
    }

    @Override
    public float[] toThis(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        if (this.equals(that) || that instanceof PromiscuousUnit) {
            newValues = copy ? (float[])values.clone() : values;
        } else {
            newValues = that.toThat(values, this.reference, copy);
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = (float)(Math.log(newValues[i]) / this.lnBase);
            }
        }
        return newValues;
    }

    @Override
    public double[] toThat(double[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    @Override
    public float[] toThat(float[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    @Override
    public double[] toThat(double[] values, Unit that, boolean copy) throws UnitException {
        double[] newValues;
        double[] dArray = newValues = copy ? (double[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = Math.exp(newValues[i] * this.lnBase);
            }
            newValues = that.toThis(newValues, this.reference, copy);
        }
        return newValues;
    }

    @Override
    public float[] toThat(float[] values, Unit that, boolean copy) throws UnitException {
        float[] newValues;
        float[] fArray = newValues = copy ? (float[])values.clone() : values;
        if (!this.equals(that) && !(that instanceof PromiscuousUnit)) {
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = (float)Math.exp((double)newValues[i] * this.lnBase);
            }
            newValues = that.toThis(newValues, this.reference, copy);
        }
        return newValues;
    }

    @Override
    public Unit getAbsoluteUnit() {
        return this.reference.getAbsoluteUnit();
    }

    @Override
    public boolean isConvertible(Unit unit) {
        return this.reference.isConvertible(unit);
    }

    private static void myAssert(boolean bool) {
        if (!bool) {
            throw new AssertionError();
        }
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit meter = SI.meter;
        ScaledUnit micron = new ScaledUnit(1.0E-6, meter);
        Unit cubicMicron = micron.pow(3);
        LogarithmicUnit Bz = new LogarithmicUnit(10.0, cubicMicron);
        LogarithmicUnit.myAssert(Bz.isDimensionless());
        LogarithmicUnit.myAssert(Bz.equals(Bz));
        LogarithmicUnit.myAssert(Bz.getAbsoluteUnit().equals(cubicMicron));
        LogarithmicUnit.myAssert(!Bz.equals(cubicMicron));
        LogarithmicUnit.myAssert(!Bz.equals(micron));
        LogarithmicUnit.myAssert(!Bz.equals(meter));
        try {
            Bz.multiply(meter);
            LogarithmicUnit.myAssert(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Bz.divide(meter);
            LogarithmicUnit.myAssert(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Bz.pow(2);
            LogarithmicUnit.myAssert(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        double value = Bz.toThat(0.0, Bz.getAbsoluteUnit());
        LogarithmicUnit.myAssert(0.9 < value && value < 1.1);
        value = Bz.toThat(1.0, Bz.getAbsoluteUnit());
        LogarithmicUnit.myAssert(9.0 < value && value < 11.0);
        value = Bz.toThis(1.0, Bz.getAbsoluteUnit());
        LogarithmicUnit.myAssert(-0.1 < value && value < 0.1);
        value = Bz.toThis(10.0, Bz.getAbsoluteUnit());
        LogarithmicUnit.myAssert(0.9 < value && value < 1.1);
        String string = Bz.toString();
        LogarithmicUnit.myAssert(string.equals("lg(re 9.999999999999999E-19 m3)"));
        System.out.println("Done");
    }

    @Override
    public boolean equals(Unit unit) {
        if (this == unit) {
            return true;
        }
        if (!(unit instanceof LogarithmicUnit)) {
            return false;
        }
        LogarithmicUnit that = (LogarithmicUnit)unit;
        return this.base == that.base && this.reference.equals(that.reference);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.reference.hashCode() ^ Double.valueOf(this.base).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        return this.reference.getDerivedUnit();
    }
}

