/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.LinearSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class IrregularSet
extends SampledSet {
    public Delaunay Delan = null;
    int[] oldToNew;
    int[] newToOld;

    public IrregularSet(MathType type, float[][] samples) throws VisADException {
        this(type, samples, samples.length, null, null, null, null, true);
    }

    public IrregularSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, samples.length, coord_sys, units, errors, null, true);
    }

    public IrregularSet(MathType type, float[][] samples, Delaunay delan) throws VisADException {
        this(type, samples, samples.length, null, null, null, delan, true);
    }

    public IrregularSet(MathType type, float[][] samples, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan) throws VisADException {
        this(type, samples, samples.length, coord_sys, units, errors, delan, true);
    }

    public IrregularSet(MathType type, float[][] samples, int manifold_dimension, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan) throws VisADException {
        this(type, samples, manifold_dimension, coord_sys, units, errors, delan, true);
    }

    public IrregularSet(MathType type, float[][] samples, int manifold_dimension, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Delaunay delan, boolean copy) throws VisADException {
        super(type, manifold_dimension, coord_sys, units, errors);
        if (samples == null) {
            throw new SetException("IrregularSet: samples cannot be null");
        }
        this.init_samples(samples, copy);
        if (this.ManifoldDimension > 1) {
            this.Delan = delan != null ? (copy ? (Delaunay)delan.clone() : delan) : Delaunay.factory(samples, false);
        }
    }

    @Override
    public float[][] indexToValue(int[] index) throws VisADException {
        float[][] value = new float[this.DomainDimension][index.length];
        float[][] mySamples = this.getMySamples();
        for (int i = 0; i < index.length; ++i) {
            int j;
            if (index[i] >= 0 && index[i] < this.Length) {
                for (j = 0; j < this.DomainDimension; ++j) {
                    value[j][i] = mySamples[j][index[i]];
                }
                continue;
            }
            for (j = 0; j < this.DomainDimension; ++j) {
                value[j][i] = Float.NaN;
            }
        }
        return value;
    }

    @Override
    public int[] valueToIndex(float[][] value) throws VisADException {
        throw new UnimplementedException("IrregularSet.valueToIndex");
    }

    @Override
    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        throw new UnimplementedException("IrregularSet.valueToInterp");
    }

    @Override
    public void getNeighbors(int[][] neighbors) throws VisADException {
        if (this.ManifoldDimension == 1) {
            neighbors[0] = new int[2];
            neighbors[this.Length - 1] = new int[2];
            neighbors[0][0] = 1;
            neighbors[this.Length - 1][0] = this.Length - 2;
            for (int ii = 1; ii < this.Length - 1; ++ii) {
                neighbors[ii] = new int[2];
                neighbors[ii][0] = ii - 1;
                neighbors[ii][0] = ii + 1;
            }
        } else if (this.ManifoldDimension < 4) {
            int[][] Vertices = this.Delan.Vertices;
            int[][] Tri = this.Delan.Tri;
            int n_samples = Vertices.length;
            for (int ii = 0; ii < n_samples; ++ii) {
                int tt;
                int[] indeces = new int[n_samples];
                int n_triangles = Vertices[ii].length;
                for (int jj = 0; jj < n_triangles; ++jj) {
                    for (int kk = 0; kk < Tri[Vertices[ii][jj]].length; ++kk) {
                        int index = Tri[Vertices[ii][jj]][kk];
                        if (index == ii) continue;
                        int n = index;
                        indeces[n] = indeces[n] + 1;
                    }
                }
                int cnt = 0;
                for (tt = 0; tt < n_samples; ++tt) {
                    if (indeces[tt] <= 0) continue;
                    ++cnt;
                }
                neighbors[ii] = new int[cnt];
                cnt = 0;
                for (tt = 0; tt < n_samples; ++tt) {
                    if (indeces[tt] <= 0) continue;
                    neighbors[ii][cnt] = tt;
                    ++cnt;
                }
                indeces = null;
            }
        } else {
            throw new UnimplementedException("getNeighbors(): ManifoldDimension > 3 ");
        }
    }

    @Override
    public boolean equals(Object set) {
        if (!(set instanceof IrregularSet) || set == null || set instanceof LinearSet) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (this.testNotEqualsCache((Set)set)) {
            return false;
        }
        if (this.testEqualsCache((Set)set)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((IrregularSet)set).getDimension() || this.ManifoldDimension != ((IrregularSet)set).getManifoldDimension() || this.Length != ((IrregularSet)set).getLength()) {
                return false;
            }
            float[][] mySamples = this.getMySamples();
            float[][] samples = ((IrregularSet)set).getSamples(false);
            for (int j = 0; j < this.DomainDimension; ++j) {
                for (int i = 0; i < this.Length; ++i) {
                    if (mySamples[j][i] == samples[j][i]) continue;
                    this.addNotEqualsCache((Set)set);
                    return false;
                }
            }
            this.addEqualsCache((Set)set);
            return true;
        }
        catch (VisADException e) {
            return false;
        }
    }

    @Override
    public Object clone() {
        IrregularSet clone = (IrregularSet)super.clone();
        if (this.Delan != null) {
            clone.Delan = (Delaunay)this.Delan.clone();
        }
        return clone;
    }

    @Override
    public Object cloneButType(MathType type) throws VisADException {
        return new IrregularSet(type, this.getMySamples(), this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
    }

    @Override
    public String longString(String pre) throws VisADException {
        String s;
        if (this.DomainDimension == this.ManifoldDimension) {
            s = pre + this.getClass().getName() + ": Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
            for (int j = 0; j < this.DomainDimension; ++j) {
                s = s + pre + "  Dimension " + j + ":" + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
            }
        } else {
            s = pre + this.getClass().getName() + ": DomainDimension = " + this.DomainDimension + " ManifoldDimension = " + this.ManifoldDimension + " Length = " + this.Length + "\n";
            for (int j = 0; j < this.DomainDimension; ++j) {
                s = s + pre + "  DomainDimension " + j + ":" + " Range = " + this.Low[j] + " to " + this.Hi[j] + "\n";
            }
        }
        return s;
    }
}

