/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Integer1DSet;
import visad.IntegerSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class Integer3DSet
extends Linear3DSet
implements IntegerSet {
    public Integer3DSet(MathType type, Integer1DSet[] sets) throws VisADException {
        this(type, sets, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public Integer3DSet(int length1, int length2, int length3) throws VisADException {
        this((MathType)RealTupleType.Generic3D, Integer3DSet.get_integer1d_array(RealTupleType.Generic3D, length1, length2, length3, null), (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public Integer3DSet(MathType type, int length1, int length2, int length3) throws VisADException {
        this(type, Integer3DSet.get_integer1d_array(type, length1, length2, length3, null), (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public Integer3DSet(MathType type, Integer1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        super(type, sets, coord_sys, units, errors);
    }

    public Integer3DSet(MathType type, int length1, int length2, int length3, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Integer3DSet.get_integer1d_array(type, length1, length2, length3, units), coord_sys, units, errors);
    }

    private static Integer1DSet[] get_integer1d_array(MathType type, int length1, int length2, int length3, Unit[] units) throws VisADException {
        type = Set.adjustType(type);
        Integer1DSet[] sets = new Integer1DSet[3];
        RealType[] types = new RealType[1];
        Unit[] us = new Unit[]{null};
        types[0] = (RealType)((SetType)type).getDomain().getComponent(0);
        SetType set_type = new SetType(new RealTupleType(types));
        if (units != null && units.length > 0) {
            us[0] = units[0];
        }
        sets[0] = new Integer1DSet(set_type, length1, null, us, null);
        types[0] = (RealType)((SetType)type).getDomain().getComponent(1);
        set_type = new SetType(new RealTupleType(types));
        if (units != null && units.length > 1) {
            us[0] = units[1];
        }
        sets[1] = new Integer1DSet(set_type, length2, null, us, null);
        types[0] = (RealType)((SetType)type).getDomain().getComponent(2);
        set_type = new SetType(new RealTupleType(types));
        if (units != null && units.length > 2) {
            us[0] = units[2];
        }
        sets[2] = new Integer1DSet(set_type, length3, null, us, null);
        return sets;
    }

    @Override
    public Object cloneButType(MathType type) throws VisADException {
        Integer1DSet[] sets = new Integer1DSet[]{(Integer1DSet)this.X.clone(), (Integer1DSet)this.Y.clone(), (Integer1DSet)this.Z.clone()};
        return new Integer3DSet(type, sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    @Override
    public String longString(String pre) throws VisADException {
        String s = pre + "Integer3DSet: Length = " + this.Length + "\n";
        s = s + pre + "  Dimension 1: Length = " + this.X.getLength() + "\n";
        s = s + pre + "  Dimension 2: Length = " + this.Y.getLength() + "\n";
        s = s + pre + "  Dimension 3: Length = " + this.Z.getLength() + "\n";
        return s;
    }
}

