/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import visad.CommonUnit;
import visad.Data;
import visad.DataImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.util.DataUtility;
import visad.util.Util;

public class DoubleTuple
extends RealTuple {
    private Data[] prototypes;
    double[] doubles;
    RealTupleType tt;
    Unit[] units;
    Data[] components;

    public DoubleTuple(double[] doubles) throws VisADException {
        this(DoubleTuple.makeGenericTypes(doubles.length), doubles, null);
    }

    public DoubleTuple(RealTupleType type, double[] doubles) {
        this(type, doubles, null);
    }

    public DoubleTuple(RealTupleType type, double[] doubles, Unit[] units) {
        this(type, null, doubles, units);
    }

    public DoubleTuple(RealTupleType type, Data[] prototypes, double[] doubles, Unit[] units) {
        super(type);
        this.tt = type;
        this.prototypes = prototypes;
        this.doubles = doubles;
        this.units = units;
        if (units == null) {
            this.units = type.getDefaultUnits();
        }
    }

    private static RealTupleType makeGenericTypes(int num) throws VisADException {
        Object[] types = new RealType[num];
        Arrays.fill(types, RealType.Generic);
        return new RealTupleType((RealType[])types);
    }

    @Override
    public boolean isMissing() {
        return this.doubles == null;
    }

    @Override
    public Data getComponent(int i) throws VisADException, RemoteException {
        if (this.components == null) {
            this.components = new Data[this.getDimension()];
        }
        if (0 <= i && i < this.getDimension()) {
            if (this.components[i] == null) {
                this.components[i] = this.getComponentInner(i);
                if (this.components[i] != null) {
                    ((DataImpl)this.components[i]).setParent(this);
                }
            }
            return this.components[i];
        }
        throw new TypeException("Tuple: component index out of range: " + i);
    }

    private Data getComponentInner(int i) throws VisADException, RemoteException {
        if (this.doubles != null) {
            if (this.prototypes != null) {
                return ((Real)this.prototypes[i]).cloneButValue(this.doubles[i]);
            }
            if (this.units == null || this.units[i] == null) {
                return new Real((RealType)this.tt.getComponent(i), this.doubles[i]);
            }
            return new Real((RealType)this.tt.getComponent(i), this.doubles[i], this.units[i]);
        }
        return null;
    }

    @Override
    public Data[] getComponents(boolean copy) {
        try {
            if (this.components == null) {
                this.components = new Data[this.getDimension()];
            }
            for (int i = 0; i < this.getDimension(); ++i) {
                this.components[i] = this.getComponent(i);
            }
            return this.components;
        }
        catch (Exception exc) {
            throw new IllegalStateException("Error making component array:" + exc);
        }
    }

    @Override
    public Unit[] getTupleUnits() {
        return Unit.copyUnitsArray(this.units);
    }

    @Override
    public double[] getValues() {
        if (this.doubles == null) {
            return null;
        }
        return (double[])this.doubles.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleTuple)) {
            return false;
        }
        DoubleTuple that = (DoubleTuple)obj;
        return Arrays.equals(this.doubles, that.doubles) && this.tt.equals(that.tt) && Arrays.equals(this.units, that.units);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        if (this.doubles != null) {
            hashCode ^= this.doubles.hashCode();
        }
        return hashCode ^= this.tt.hashCode();
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        int b = 10;
        Real w = new Real(b);
        Real[] reals1 = new Real[]{new Real(1.0), new Real(2.0), new Real(3.0)};
        DoubleTuple rt1 = new DoubleTuple(new double[]{1.0, 2.0, 3.0});
        DoubleTuple rt2 = new DoubleTuple(new double[]{6.0, 5.0, 4.0});
        System.out.println("rt1 = " + rt1 + "\nrt2 = " + rt2);
        System.out.println("rt1 + rt2 = " + rt1.add(rt2));
        System.out.println("rt1 - rt2 = " + rt1.subtract(rt2));
        System.out.println("rt1 * rt2 = " + rt1.multiply(rt2));
        System.out.println("rt1 / rt2 = " + rt1.divide(rt2));
        System.out.println("sqrt(rt1) = " + rt1.sqrt());
        System.out.println("rt1 + w = " + rt1.add(w));
        System.out.println("rt1 - w = " + rt1.subtract(w));
        System.out.println("rt1 * w = " + rt1.multiply(w));
        System.out.println("rt1 / w = " + rt1.divide(w));
        System.out.println("w + rt2 = " + w.add(rt2));
        System.out.println("w - rt2 = " + w.subtract(rt2));
        System.out.println("w * rt2 = " + w.multiply(rt2));
        System.out.println("w / rt2 = " + w.divide(rt2));
        RealTupleType tt = RealTupleType.LatitudeLongitudeAltitude;
        Unit foot = CommonUnit.meter.scale(0.3048);
        try {
            foot = Parser.parse("foot");
        }
        catch (ParseException pe) {
            // empty catch block
        }
        DoubleTuple one = new DoubleTuple(tt, new double[]{40.5, -105.0, 5338.0}, new Unit[]{CommonUnit.degree, CommonUnit.degree, foot});
        System.out.println("one = " + one.toString());
        DataUtility.isSerializable(one, true);
        Util.printArray("one.values", one.getValues());
        Util.printArray("one.units", one.getTupleUnits());
        System.out.println("one.cs = " + one.getCoordinateSystem());
        DoubleTuple two = new DoubleTuple(tt, new double[]{45.0, -75.0, 400.0});
        System.out.println("two = " + two.toString());
        System.out.println("one - two = " + one.subtract(two));
        System.out.println("one + two = " + one.add(two));
    }
}

