/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.text.ChoiceFormat;
import java.util.Arrays;
import java.util.Vector;
import visad.BaseUnit;
import visad.Factor;
import visad.LogarithmicUnit;
import visad.OffsetUnit;
import visad.PromiscuousUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class DerivedUnit
extends Unit
implements Serializable {
    private static final long serialVersionUID = 1L;
    Factor[] factors;
    private static AddPow addPow = new AddPow();
    private static SubPow subPow = new SubPow();

    public DerivedUnit() {
        this(new BaseUnit[0], new int[0], "");
    }

    public DerivedUnit(String identifier) {
        this(new BaseUnit[0], new int[0], identifier);
    }

    public DerivedUnit(BaseUnit baseUnit) {
        this(new BaseUnit[]{baseUnit}, new int[]{1}, baseUnit.getIdentifier());
    }

    public DerivedUnit(BaseUnit[] baseUnits, int[] powers) {
        this(DerivedUnit.newFactors(baseUnits, powers), baseUnits.length == 1 ? baseUnits[0].getIdentifier() : null);
    }

    public DerivedUnit(BaseUnit[] baseUnits, int[] powers, String identifier) {
        this(DerivedUnit.newFactors(baseUnits, powers), identifier);
    }

    protected static Factor[] newFactors(BaseUnit[] baseUnits, int[] powers) {
        Factor[] factors = new Factor[baseUnits.length];
        for (int i = 0; i < baseUnits.length; ++i) {
            factors[i] = new Factor(baseUnits[i], powers[i]);
        }
        return factors;
    }

    public DerivedUnit(DerivedUnit that, String identifier) {
        this(that.factors, identifier);
    }

    private DerivedUnit(Factor[] facts) {
        this(facts, (String)null);
    }

    private DerivedUnit(Factor[] facts, String identifier) {
        super(identifier);
        Factor fact;
        int i;
        int n = 0;
        for (i = 0; i < facts.length; ++i) {
            fact = facts[i];
            if (fact == null || fact.power == 0) continue;
            ++n;
        }
        this.factors = new Factor[n];
        n = 0;
        for (i = 0; i < facts.length; ++i) {
            fact = facts[i];
            if (fact == null || fact.power == 0) continue;
            this.factors[n++] = fact;
        }
    }

    @Override
    public boolean isDimensionless() {
        for (int i = 0; i < this.factors.length; ++i) {
            if (this.factors[i].power == 0 || this.factors[i].baseUnit.isDimensionless()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Unit protectedClone(String identifier) {
        return new DerivedUnit(this, identifier);
    }

    @Override
    public Unit scale(double amount) throws UnitException {
        return ScaledUnit.getInstance(amount, this);
    }

    @Override
    public Unit shift(double offset) throws UnitException {
        return OffsetUnit.getInstance(offset, this);
    }

    @Override
    public Unit log(double base) {
        return LogarithmicUnit.getInstance(base, this);
    }

    @Override
    public Unit pow(int power) {
        DerivedUnit result;
        if (power == 1) {
            result = this;
        } else {
            Factor[] newFactors = new Factor[this.factors.length];
            for (int i = 0; i < this.factors.length; ++i) {
                Factor factor = this.factors[i];
                newFactors[i] = new Factor(factor.baseUnit, factor.power * power);
            }
            result = new DerivedUnit(newFactors);
        }
        return result;
    }

    @Override
    public Unit root(int root) throws IllegalArgumentException {
        DerivedUnit result;
        if (root == 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ".root(int): zero root");
        }
        if (root == 1) {
            result = this;
        } else {
            Factor[] newFactors = new Factor[this.factors.length];
            for (int i = 0; i < this.factors.length; ++i) {
                Factor factor = this.factors[i];
                if (factor.power % root != 0) {
                    throw new IllegalArgumentException(this.getClass().getName() + ".root(int): " + "Non-integral resulting dimension");
                }
                newFactors[i] = new Factor(factor.baseUnit, factor.power / root);
            }
            result = new DerivedUnit(newFactors);
        }
        return result;
    }

    @Override
    public Unit pow(double power) throws IllegalArgumentException {
        Unit result;
        if (this.factors.length == 0) {
            result = this;
        } else if (Math.abs(power) > 1.0) {
            double intVal = Math.rint(power);
            if (power < ChoiceFormat.previousDouble(intVal) || power > ChoiceFormat.nextDouble(intVal)) {
                throw new IllegalArgumentException(this.getClass().getName() + ".pow(double): " + "Non-integral power");
            }
            result = this.pow((int)intVal);
        } else {
            double root = 1.0 / power;
            double intVal = Math.rint(root);
            if (root < ChoiceFormat.previousDouble(intVal) || root > ChoiceFormat.nextDouble(intVal)) {
                throw new IllegalArgumentException(this.getClass().getName() + ".pow(double): " + "Non-integral reciprocal power");
            }
            result = this.root((int)intVal);
        }
        return result;
    }

    @Override
    public String getDefinition() {
        String definition;
        if (this.factors == null) {
            definition = "<unconstructed DerivedUnit>";
        } else {
            StringBuffer buf = new StringBuffer(80);
            for (int i = 0; i < this.factors.length; ++i) {
                if (this.factors[i].power == 1) {
                    buf.append(this.factors[i].baseUnit.toString() + ".");
                    continue;
                }
                if (this.factors[i].power == 0) continue;
                buf.append(this.factors[i].baseUnit.toString() + this.factors[i].power + ".");
            }
            if (buf.length() > 0) {
                buf.setLength(buf.length() - 1);
            }
            definition = buf.toString();
        }
        return definition;
    }

    private static void myAssert(boolean assertion) {
        if (!assertion) {
            throw new AssertionError();
        }
    }

    private static void myAssert(Unit have, Unit expect) {
        if (!have.equals(expect)) {
            throw new AssertionError((Object)(have.toString() + " != " + expect));
        }
    }

    private static void myAssert(double have, double expect) {
        if (have != expect) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    private static void myAssert(double[] have, double[] expect) {
        if (!Arrays.equals(have, expect)) {
            throw new AssertionError((Object)("" + have + " != " + expect));
        }
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit meter = SI.meter;
        BaseUnit second = SI.second;
        DerivedUnit speed = new DerivedUnit(new BaseUnit[]{meter, second}, new int[]{1, -1});
        Unit speed2 = speed.pow(2);
        DerivedUnit.myAssert(!speed.equals(meter));
        DerivedUnit.myAssert(!speed.equals(second));
        DerivedUnit.myAssert(!speed.isConvertible(meter));
        DerivedUnit.myAssert(!speed.isConvertible(second));
        DerivedUnit.myAssert(speed, meter.divide(second));
        DerivedUnit.myAssert(!speed.equals(speed2));
        DerivedUnit.myAssert(!speed.isConvertible(speed2));
        DerivedUnit.myAssert(speed, speed2.sqrt());
        DerivedUnit.myAssert(speed, speed2.root(2));
        DerivedUnit.myAssert(speed.pow(2.0 + Math.ulp(2.0)), speed2);
        DerivedUnit.myAssert(speed2.pow(1.0 / (2.0 + Math.ulp(2.0))), speed);
        DerivedUnit.myAssert(meter.divide(speed), second);
        DerivedUnit.myAssert(speed.divide(meter), second.pow(-1));
        DerivedUnit.myAssert(speed.toThis(5.0, (Unit)speed), 5.0);
        DerivedUnit.myAssert(speed.toThat(5.0, (Unit)speed), 5.0);
        double[] values = new double[]{1.0, 2.0};
        DerivedUnit.myAssert(speed.toThis(values, speed), values);
        DerivedUnit.myAssert(speed.toThat(values, speed), values);
        DerivedUnit joule = (DerivedUnit)speed.pow(2).multiply(SI.kilogram);
        DerivedUnit.myAssert(joule.equals(joule));
        DerivedUnit.myAssert(joule.isConvertible(joule));
        DerivedUnit.myAssert(!joule.equals(meter));
        DerivedUnit.myAssert(!joule.isConvertible(meter));
        System.out.println("Checking exceptions:");
        try {
            speed.toThis(5.0, (Unit)joule);
            throw new AssertionError();
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
            try {
                System.out.println("speed.pow(2+2*ULP)=\"" + speed.pow(ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(2.0))) + "\"");
                throw new AssertionError();
            }
            catch (IllegalArgumentException e2) {
                System.out.println(e2.getMessage());
                try {
                    System.out.println("speed2.pow(1/(2+2*ULP))=\"" + speed2.pow(1.0 / ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(2.0))) + "\"");
                    throw new AssertionError();
                }
                catch (IllegalArgumentException e3) {
                    System.out.println(e3.getMessage());
                    System.out.println("Done");
                    return;
                }
            }
        }
    }

    private Vector[] common(DerivedUnit that) {
        Vector[] vector = new Vector[3];
        int max = this.factors.length + that.factors.length;
        vector[0] = new Vector(max);
        vector[1] = new Vector(max);
        vector[2] = new Vector(max);
        for (int i = 0; i < this.factors.length; ++i) {
            int j;
            if (this.factors[i].power == 0 || this.factors[i].baseUnit.isDimensionless()) continue;
            for (j = 0; j < that.factors.length; ++j) {
                if (that.factors[j].power == 0 || !this.factors[i].baseUnit.equals(that.factors[j].baseUnit)) continue;
                vector[2].addElement(new Factor[]{this.factors[i], that.factors[j]});
                break;
            }
            if (j != that.factors.length) continue;
            vector[0].addElement(this.factors[i]);
        }
        for (int j = 0; j < that.factors.length; ++j) {
            int i;
            if (that.factors[j].power == 0 || that.factors[j].baseUnit.isDimensionless()) continue;
            for (i = 0; !(i >= this.factors.length || this.factors[i].power != 0 && this.factors[i].baseUnit.equals(that.factors[j].baseUnit)); ++i) {
            }
            if (i != this.factors.length) continue;
            vector[1].addElement(that.factors[j]);
        }
        return vector;
    }

    @Override
    public Unit multiply(Unit that) throws UnitException {
        return that instanceof DerivedUnit ? this.multiply((DerivedUnit)that) : that.multiply(this);
    }

    public Unit multiply(DerivedUnit that) {
        return addPow.multOp(this, that);
    }

    @Override
    public Unit divide(Unit that) throws UnitException {
        return that instanceof DerivedUnit ? this.divide((DerivedUnit)that) : that.divideInto(this);
    }

    Unit divide(DerivedUnit that) {
        return subPow.multOp(this, that);
    }

    @Override
    protected Unit divideInto(Unit that) throws UnitException {
        return that.divide(this);
    }

    boolean sameDimensionality(DerivedUnit that) {
        Vector[] comm = this.common(that);
        if (comm[0].size() != 0 || comm[1].size() != 0) {
            return false;
        }
        int n2 = comm[2].size();
        for (int i = 0; i < n2; ++i) {
            Factor[] factors = (Factor[])comm[2].elementAt(i);
            if (factors[0].power == factors[1].power) continue;
            return false;
        }
        return true;
    }

    boolean reciprocalDimensionality(DerivedUnit that) {
        Vector[] comm = this.common(that);
        if (comm[0].size() != 0 || comm[1].size() != 0) {
            return false;
        }
        int n2 = comm[2].size();
        for (int i = 0; i < n2; ++i) {
            Factor[] factors = (Factor[])comm[2].elementAt(i);
            if (factors[0].power == -factors[1].power) continue;
            return false;
        }
        return true;
    }

    @Override
    public double[] toThis(double[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public float[] toThis(float[] values, Unit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    @Override
    public double[] toThis(double[] values, Unit that, boolean copy) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            double[] newValues = copy ? (double[])values.clone() : values;
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThis(values, (DerivedUnit)that, copy) : that.toThat(values, (Unit)this);
    }

    @Override
    public float[] toThis(float[] values, Unit that, boolean copy) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            float[] newValues = copy ? (float[])values.clone() : values;
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThis(values, (DerivedUnit)that, copy) : that.toThat(values, (Unit)this);
    }

    double[] toThis(double[] values, DerivedUnit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    float[] toThis(float[] values, DerivedUnit that) throws UnitException {
        return this.toThis(values, that, true);
    }

    double[] toThis(double[] values, DerivedUnit that, boolean copy) throws UnitException {
        double[] newValues;
        if (this.sameDimensionality(that)) {
            newValues = copy ? (double[])values.clone() : values;
        } else if (this.reciprocalDimensionality(that)) {
            newValues = copy ? (double[])values.clone() : values;
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = values[i] == values[i] ? 1.0 / values[i] : Double.NaN;
            }
        } else {
            throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
        }
        return newValues;
    }

    float[] toThis(float[] values, DerivedUnit that, boolean copy) throws UnitException {
        float[] newValues;
        if (this.sameDimensionality(that)) {
            newValues = copy ? (float[])values.clone() : values;
        } else if (this.reciprocalDimensionality(that)) {
            newValues = copy ? (float[])values.clone() : values;
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = 1.0f / values[i];
                newValues[i] = values[i] == values[i] ? 1.0f / values[i] : Float.NaN;
            }
        } else {
            throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
        }
        return newValues;
    }

    @Override
    public double[] toThat(double[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    @Override
    public float[] toThat(float[] values, Unit that) throws UnitException {
        return this.toThat(values, that, true);
    }

    double[] toThat(double[] values, DerivedUnit that) throws UnitException {
        return that.toThis(values, this, true);
    }

    float[] toThat(float[] values, DerivedUnit that) throws UnitException {
        return that.toThis(values, this, true);
    }

    @Override
    public double[] toThat(double[] values, Unit that, boolean copy) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            double[] newValues = copy ? (double[])values.clone() : values;
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThat(values, (DerivedUnit)that, copy) : that.toThis(values, (Unit)this, copy);
    }

    @Override
    public float[] toThat(float[] values, Unit that, boolean copy) throws UnitException {
        if (that instanceof PromiscuousUnit) {
            float[] newValues = copy ? (float[])values.clone() : values;
            return newValues;
        }
        return that instanceof DerivedUnit ? this.toThat(values, (DerivedUnit)that, copy) : that.toThis(values, (Unit)this, copy);
    }

    double[] toThat(double[] values, DerivedUnit that, boolean copy) throws UnitException {
        return that.toThis(values, this, copy);
    }

    float[] toThat(float[] values, DerivedUnit that, boolean copy) throws UnitException {
        return that.toThis(values, this, copy);
    }

    @Override
    public boolean isConvertible(Unit unit) {
        DerivedUnit that;
        boolean isConvertible = unit == null ? false : (unit instanceof DerivedUnit ? this.sameDimensionality(that = (DerivedUnit)unit) || this.reciprocalDimensionality(that) : unit.isConvertible(this));
        return isConvertible;
    }

    @Override
    public boolean equals(Unit unit) {
        int j;
        if (this == unit) {
            return true;
        }
        if (!(unit instanceof DerivedUnit)) {
            return unit == null ? false : unit.equals(this);
        }
        int n = this.factors.length;
        if (n != ((DerivedUnit)unit).factors.length) {
            return false;
        }
        boolean[] mark = new boolean[n];
        for (j = 0; j < n; ++j) {
            mark[j] = false;
        }
        block1: for (int i = 0; i < n; ++i) {
            for (int j2 = 0; j2 < n; ++j2) {
                if (mark[j2] || !this.factors[i].equals(((DerivedUnit)unit).factors[j2])) continue;
                mark[j2] = true;
                continue block1;
            }
        }
        for (j = 0; j < n; ++j) {
            if (mark[j]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            for (int i = 0; i < this.factors.length; ++i) {
                this.hashCode ^= this.factors[i].hashCode();
            }
        }
        return this.hashCode;
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        return this;
    }

    private static final class SubPow
    extends Op {
        private SubPow() {
        }

        @Override
        protected Factor op(Factor factor) {
            return new Factor(factor.baseUnit, -factor.power);
        }

        @Override
        protected Factor op(Factor f1, Factor f2) {
            return new Factor(f1.baseUnit, f1.power - f2.power);
        }
    }

    private static final class AddPow
    extends Op {
        private AddPow() {
        }

        @Override
        protected Factor op(Factor factor) {
            return factor;
        }

        @Override
        protected Factor op(Factor f1, Factor f2) {
            return new Factor(f1.baseUnit, f1.power + f2.power);
        }
    }

    static abstract class Op {
        Op() {
        }

        public DerivedUnit multOp(DerivedUnit d1, DerivedUnit d2) {
            int i;
            Vector[] comm = d1.common(d2);
            int n0 = comm[0].size();
            int n1 = comm[1].size();
            int n2 = comm[2].size();
            Factor[] factors = new Factor[n0 + n1 + n2];
            int k = 0;
            for (i = 0; i < n0; ++i) {
                factors[k++] = (Factor)comm[0].elementAt(i);
            }
            for (i = 0; i < n1; ++i) {
                factors[k++] = this.op((Factor)comm[1].elementAt(i));
            }
            for (i = 0; i < n2; ++i) {
                Factor[] facts = (Factor[])comm[2].elementAt(i);
                factors[k++] = this.op(facts[0], facts[1]);
            }
            return new DerivedUnit(factors);
        }

        protected abstract Factor op(Factor var1);

        protected abstract Factor op(Factor var1, Factor var2);
    }
}

