/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Vector;
import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public class CartesianProductCoordinateSystem
extends CoordinateSystem {
    private CoordinateSystem[] csArray;

    public CartesianProductCoordinateSystem(CoordinateSystem a, CoordinateSystem b) throws VisADException {
        this(new CoordinateSystem[]{a, b});
    }

    public CartesianProductCoordinateSystem(CoordinateSystem[] csArray) throws VisADException {
        super(CartesianProductCoordinateSystem.getProductReference(csArray), CartesianProductCoordinateSystem.getProductUnits(csArray));
        this.csArray = csArray;
    }

    public CoordinateSystem[] getCoordinateSystems() {
        return this.csArray;
    }

    public CoordinateSystem getCoordinateSystem(int index) {
        return this.csArray[index];
    }

    static RealTupleType getProductReference(CoordinateSystem[] csArray) throws VisADException {
        if (csArray == null) {
            throw new VisADException("CoordinateSystem array can't be null");
        }
        if (csArray.length < 2) {
            throw new VisADException("CoordinateSystem array must have more than one element");
        }
        Vector<RealType> typeVector = new Vector<RealType>();
        for (int i = 0; i < csArray.length; ++i) {
            CoordinateSystem cs = csArray[i];
            if (cs == null) {
                throw new VisADException("CoordinateSystem array can't have null members " + i);
            }
            RealType[] reals = cs.getReference().getRealComponents();
            for (int j = 0; j < reals.length; ++j) {
                typeVector.add(reals[j]);
            }
        }
        return new RealTupleType(typeVector.toArray(new RealType[typeVector.size()]));
    }

    static Unit[] getProductUnits(CoordinateSystem[] csArray) throws VisADException {
        if (csArray == null) {
            throw new VisADException("CoordinateSystem array can't be null");
        }
        if (csArray.length < 2) {
            throw new VisADException("CoordinateSystem array must have more than one element");
        }
        Vector<Unit> unitVector = new Vector<Unit>();
        for (int i = 0; i < csArray.length; ++i) {
            Unit[] units = csArray[i].getCoordinateSystemUnits();
            for (int j = 0; j < units.length; ++j) {
                unitVector.add(units[j]);
            }
        }
        return unitVector.toArray(new Unit[unitVector.size()]);
    }

    @Override
    public double[][] toReference(double[][] input) throws VisADException {
        if (input.length != this.getDimension() || input == null) {
            throw new VisADException("input has wrong dimension");
        }
        int numElements = input[0].length;
        double[][] output = new double[this.getDimension()][];
        int pointer = 0;
        for (int i = 0; i < this.csArray.length; ++i) {
            int j;
            int dimension = this.csArray[i].getDimension();
            Object temp = new double[dimension][];
            for (j = 0; j < dimension; ++j) {
                temp[j] = input[pointer + j];
            }
            temp = this.csArray[i].toReference((double[][])temp);
            for (j = 0; j < dimension; ++j) {
                output[pointer + j] = temp[j];
            }
            pointer += dimension;
        }
        return output;
    }

    @Override
    public double[][] fromReference(double[][] refTuple) throws VisADException {
        if (refTuple.length != this.getDimension() || refTuple == null) {
            throw new VisADException("refTuple has wrong dimension");
        }
        int numElements = refTuple[0].length;
        double[][] output = new double[this.getDimension()][];
        int pointer = 0;
        for (int i = 0; i < this.csArray.length; ++i) {
            int j;
            int dimension = this.csArray[i].getDimension();
            Object temp = new double[dimension][];
            for (j = 0; j < dimension; ++j) {
                temp[j] = refTuple[pointer + j];
            }
            temp = this.csArray[i].fromReference((double[][])temp);
            for (j = 0; j < dimension; ++j) {
                output[pointer + j] = temp[j];
            }
            pointer += dimension;
        }
        return output;
    }

    @Override
    public float[][] toReference(float[][] input) throws VisADException {
        if (input.length != this.getDimension() || input == null) {
            throw new VisADException("input has wrong dimension");
        }
        int numElements = input[0].length;
        float[][] output = new float[this.getDimension()][];
        int pointer = 0;
        for (int i = 0; i < this.csArray.length; ++i) {
            int j;
            int dimension = this.csArray[i].getDimension();
            Object temp = new float[dimension][];
            for (j = 0; j < dimension; ++j) {
                temp[j] = input[pointer + j];
            }
            temp = this.csArray[i].toReference((float[][])temp);
            for (j = 0; j < dimension; ++j) {
                output[pointer + j] = temp[j];
            }
            pointer += dimension;
        }
        return output;
    }

    @Override
    public float[][] fromReference(float[][] refTuple) throws VisADException {
        if (refTuple.length != this.getDimension() || refTuple == null) {
            throw new VisADException("refTuple has wrong dimension");
        }
        int numElements = refTuple[0].length;
        float[][] output = new float[this.getDimension()][];
        int pointer = 0;
        for (int i = 0; i < this.csArray.length; ++i) {
            int j;
            int dimension = this.csArray[i].getDimension();
            Object temp = new float[dimension][];
            for (j = 0; j < dimension; ++j) {
                temp[j] = refTuple[pointer + j];
            }
            temp = this.csArray[i].fromReference((float[][])temp);
            for (j = 0; j < dimension; ++j) {
                output[pointer + j] = temp[j];
            }
            pointer += dimension;
        }
        return output;
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof CartesianProductCoordinateSystem) {
            int n = this.csArray.length;
            CoordinateSystem[] ocsa = ((CartesianProductCoordinateSystem)o).csArray;
            if (n != ocsa.length) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.csArray[i].equals(ocsa[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

