/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.Calibrator;
import edu.wisc.ssec.mcidas.CalibratorException;
import edu.wisc.ssec.mcidas.McIDASUtil;

public class CalibratorMsg
implements Calibrator {
    private static final int C1W3 = 0;
    private static final int C2W = 1;
    private static final int ALPHA = 2;
    private static final int BETA = 3;
    private static final int GAIN = 4;
    private static final int OFFSET = 5;
    private static final int FMT_SIZE = 17;
    private static final int BAND_SIZE = 103;
    private static final int HDR_SIZE = 4;
    private static final String HEADER = "MSGT";
    private final float[] bandCoefs = new float[]{21.21f, 23.24f, 19.77f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 22.39f};
    private final double[][] planckCoefs;
    private byte[] calBytes;
    private int curCalType = 1;

    public CalibratorMsg(int[] cal) throws CalibratorException {
        int[] calBlock = (int[])cal.clone();
        this.calBytes = this.calIntsToBytes(calBlock);
        String msgt = new String(this.calBytes, 0, 4);
        if (!msgt.equals(HEADER)) {
            McIDASUtil.flip(calBlock, 0, calBlock.length - 1);
            this.calBytes = this.calIntsToBytes(calBlock);
            msgt = new String(this.calBytes, 0, 4);
            if (!msgt.equals(HEADER)) {
                throw new IllegalArgumentException("Invalid calibration block header: " + msgt);
            }
        }
        this.planckCoefs = this.getCalCoefs();
    }

    public CalibratorMsg(double[][] coefs) throws CalibratorException {
        this.planckCoefs = coefs;
    }

    @Override
    public int setCalType(int calType) {
        if (calType < 1 || calType > 5) {
            return -1;
        }
        this.curCalType = calType;
        return 0;
    }

    @Override
    public float[] calibrate(float[] input, int band, int calTypeOut) {
        if (calTypeOut == this.curCalType || calTypeOut == -1) {
            return (float[])input.clone();
        }
        float[] output = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = this.calibrate(input[i], band, calTypeOut);
        }
        return output;
    }

    @Override
    public float calibrate(float inputPixel, int band, int calTypeOut) {
        float pxl;
        if (calTypeOut == this.curCalType || calTypeOut == -1) {
            return inputPixel;
        }
        switch (this.curCalType) {
            case 3: {
                throw new UnsupportedOperationException("Calibration from reflectance not implemented");
            }
            case 4: {
                throw new UnsupportedOperationException("Calibration from temperature not implemented");
            }
            case 5: {
                throw new UnsupportedOperationException("Calibration from brightness not implemented");
            }
            case 2: {
                throw new UnsupportedOperationException("Calibration from radiance not implemented");
            }
            case 1: {
                pxl = this.calibrateFromRaw(inputPixel, band, calTypeOut);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown calibration type");
            }
        }
        return pxl;
    }

    public float calibrateFromRaw(float inputPixel, int band, int calTypeOut) {
        double pxl;
        block22: {
            double[] coefs;
            block21: {
                if (calTypeOut == 1 || calTypeOut == -1) {
                    return inputPixel;
                }
                coefs = this.planckCoefs[band - 1];
                pxl = (double)inputPixel * coefs[4] + coefs[5];
                if (pxl < 0.0) {
                    pxl = 0.0;
                }
                if (band >= 4 && band != 12) break block21;
                switch (calTypeOut) {
                    case 4: {
                        pxl = Double.NaN;
                        break block22;
                    }
                    case 2: {
                        break block22;
                    }
                    case 3: {
                        pxl = pxl / (double)this.bandCoefs[band - 1] * 100.0;
                        if (pxl < 0.0) {
                            pxl = 0.0;
                        } else if (pxl > 100.0) {
                            pxl = 100.0;
                        }
                        break block22;
                    }
                    case 5: {
                        pxl = pxl / (double)this.bandCoefs[band - 1] * 100.0;
                        if (pxl < 0.0) {
                            pxl = 0.0;
                        } else if (pxl > 100.0) {
                            pxl = 100.0;
                        }
                        pxl = Math.sqrt(pxl) * 25.5;
                        break block22;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown calibration type: " + calTypeOut);
                    }
                }
            }
            switch (calTypeOut) {
                case 4: {
                    if (!(pxl > 0.0)) break;
                    pxl = (coefs[1] / Math.log(1.0 + coefs[0] / pxl) - coefs[3]) / coefs[2];
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    pxl = Double.NaN;
                    break;
                }
                case 5: {
                    if (pxl > 0.0) {
                        pxl = (coefs[1] / Math.log(1.0 + coefs[0] / pxl) - coefs[3]) / coefs[2];
                        pxl = this.greyScale(pxl);
                        break;
                    }
                    pxl = 255.0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported calibration type: " + calTypeOut);
                }
            }
        }
        return (float)pxl;
    }

    private double greyScale(double val) {
        int tempLim = 242;
        int c1 = 418;
        int c2 = 660;
        double ret = val < 242.0 ? Math.min(418.0 - val, 255.0) : Math.max(660.0 - 2.0 * val, 0.0);
        return ret;
    }

    private double[][] getCalCoefs() throws CalibratorException {
        double[][] coefs = new double[12][6];
        for (int i = 0; i < coefs.length; ++i) {
            int bandOffset = i * 104 + 4;
            String[] strVals = this.getBandVals(new String(this.calBytes, bandOffset, 103));
            try {
                coefs[i][0] = Double.parseDouble(strVals[0]);
                coefs[i][1] = Double.parseDouble(strVals[1]);
                coefs[i][2] = Double.parseDouble(strVals[2]);
                coefs[i][3] = Double.parseDouble(strVals[3]);
                coefs[i][4] = Double.parseDouble(strVals[4]);
                coefs[i][5] = Double.parseDouble(strVals[5]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new CalibratorException("Unable to parse values from calibration block for band " + (i + 1), e);
            }
        }
        return coefs;
    }

    private String[] getBandVals(String line) {
        String[] strVals = new String[6];
        int i = 0;
        int j = 0;
        while (i < strVals.length) {
            strVals[i] = line.substring(j, j + 17);
            ++i;
            j += 17;
        }
        return strVals;
    }

    private byte[] calIntsToBytes(int[] orig) {
        byte[] bites = new byte[orig.length * 4];
        int j = 0;
        for (int i = 0; i < orig.length; ++i) {
            bites[j++] = (byte)(orig[i] & 0xFF);
            bites[j++] = (byte)(orig[i] >> 8 & 0xFF);
            bites[j++] = (byte)(orig[i] >> 16 & 0xFF);
            bites[j++] = (byte)(orig[i] >> 24 & 0xFF);
        }
        return bites;
    }
}

