/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AncillaryData;
import edu.wisc.ssec.mcidas.CalibratorGvar;
import java.io.DataInputStream;
import java.io.IOException;

public class CalibratorGvarG15
extends CalibratorGvar {
    protected static float[] imager15FK1 = new float[]{0.0f, 200750.0f, 42330.0f, 9766.8f, 5088.2f};
    protected static float[] sounder15FK1 = new float[]{3731.8f, 4002.2f, 4265.6f, 4684.9f, 4981.7f, 5833.2f, 6816.8f, 8993.7f, 13075.0f, 28886.0f, 34356.0f, 42758.0f, 124880.0f, 128320.0f, 135200.0f, 169620.0f, 188730.0f, 227910.0f};
    protected static float[] imager15FK2 = new float[]{0.0f, 3689.0f, 2195.7f, 1346.6f, 1083.6f};
    protected static float[] sounder15FK2 = new float[]{977.22f, 1000.3f, 1021.8f, 1054.2f, 1076.0f, 1134.1f, 1194.6f, 1310.2f, 1484.2f, 1933.1f, 2048.1f, 2203.0f, 3149.1f, 3177.7f, 3233.5f, 3487.5f, 3613.8f, 3848.3f};
    protected static float[] imager15TC1 = new float[]{0.0f, 1.59091f, 3.75399f, 0.38176f, 0.08671f};
    protected static float[] sounder15TC1 = new float[]{0.00909f, 0.00998f, 0.01021f, 0.01327f, 0.01318f, 0.04219f, 0.11811f, 0.11003f, 0.0389f, 0.13744f, 0.27731f, 0.17079f, 0.01809f, 0.01782f, 0.01976f, 0.05217f, 0.05275f, 0.29972f};
    protected static float[] imager15TC2 = new float[]{0.0f, 0.99777f, 0.99156f, 0.9987f, 0.99963f};
    protected static float[] sounder15TC2 = new float[]{0.99996f, 0.99995f, 0.99995f, 0.99994f, 0.99994f, 0.99983f, 0.99955f, 0.99962f, 0.99988f, 0.99965f, 0.99933f, 0.99961f, 0.99997f, 0.99997f, 0.99997f, 0.99992f, 0.99992f, 0.99959f};

    public CalibratorGvarG15(DataInputStream dis, AncillaryData ad, int[] cb) throws IOException {
        super(dis, ad, cb);
    }

    public CalibratorGvarG15(int sensorId, int[] cb) {
        super(sensorId, cb);
    }

    @Override
    public float radToTemp(float inVal, int band, int sId) {
        float outVal;
        if (sId % 2 == 0) {
            double expn = (double)(imager15FK1[band - 1] / inVal) + 1.0;
            double temp = (double)imager15FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)imager15TC1[band - 1]) / (double)imager15TC2[band - 1]);
        } else {
            double expn = (double)(sounder15FK1[band - 1] / inVal) + 1.0;
            double temp = (double)sounder15FK2[band - 1] / Math.log(expn);
            outVal = (float)((temp - (double)sounder15TC1[band - 1]) / (double)sounder15TC2[band - 1]);
        }
        return outVal;
    }
}

