/*
 * Decompiled with CFR 0.152.
 */
package dods.dap.Server;

import dods.dap.BaseType;
import dods.dap.BaseTypePrimitiveVector;
import dods.dap.DArray;
import dods.dap.DArrayDimension;
import dods.dap.DSequence;
import dods.dap.NoSuchVariableException;
import dods.dap.PrimitiveVector;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.InvalidOperatorException;
import dods.dap.Server.InvalidParameterException;
import dods.dap.Server.RegExpException;
import dods.dap.Server.RelOps;
import dods.dap.Server.SBHException;
import dods.dap.Server.SDODSException;
import dods.dap.Server.ServerArrayMethods;
import dods.dap.Server.ServerMethods;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class SDArray
extends DArray
implements ServerArrayMethods,
RelOps {
    private boolean Project = false;
    private boolean Synthesized = false;
    private boolean ReadMe = false;

    public SDArray() {
    }

    public SDArray(String n) {
        super(n);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        if (constrained && !this.Project) {
            return;
        }
        super.printDecl(os, space, print_semi, constrained);
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.Project) {
            return;
        }
        PrimitiveVector pv = this.getPrimitiveVector();
        if (pv instanceof BaseTypePrimitiveVector) {
            ServerMethods sm;
            BaseTypePrimitiveVector vals = (BaseTypePrimitiveVector)pv;
            if (print_decl_p) {
                this.printDecl(os, space, false, true);
                os.print(" = ");
            }
            os.print("{ ");
            int len = vals.getLength();
            for (int i = 0; i < len - 1; ++i) {
                sm = (ServerMethods)((Object)vals.getValue(i));
                if (!sm.isProject()) continue;
                ((BaseType)((Object)sm)).printVal(os, "", false);
                os.print(", ");
            }
            if (len > 0 && (sm = (ServerMethods)((Object)vals.getValue(len - 1))).isProject()) {
                ((BaseType)((Object)sm)).printVal(os, "", false);
            }
            os.print("}");
            if (print_decl_p) {
                os.println(";");
            }
        } else {
            super.printVal(os, space, print_decl_p);
        }
    }

    public void appendDim(int size, String name) {
        super.appendDim(size, name);
    }

    public final void appendDim(int size) {
        this.appendDim(size, null);
    }

    public void setProject(boolean state, boolean all) {
        this.Project = state;
        PrimitiveVector vals = this.getPrimitiveVector();
        ((ServerMethods)((Object)vals.getTemplate())).setProject(state, all);
    }

    public void setProject(boolean state) {
        this.setProject(state, true);
    }

    public boolean isProject() {
        return this.Project;
    }

    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDArray!");
    }

    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDArray!");
    }

    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDArray!");
    }

    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDArray!");
    }

    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDArray!");
    }

    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDArray!");
    }

    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDArray!");
    }

    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    public boolean isSynthesized() {
        return this.Synthesized;
    }

    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    public boolean isRead() {
        return this.ReadMe;
    }

    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, SDODSException, IOException {
        PrimitiveVector vals = this.getPrimitiveVector();
        if (!this.isRead()) {
            this.read(dataset, specialO);
        }
        if (vals.getTemplate() instanceof DSequence || ce.evalClauses(specialO)) {
            int length = vals.getLength();
            sink.writeInt(length);
            if (vals instanceof BaseTypePrimitiveVector) {
                for (int i = 0; i < length; ++i) {
                    ServerMethods sm = (ServerMethods)((Object)((BaseTypePrimitiveVector)vals).getValue(i));
                    sm.serialize(dataset, sink, ce, specialO);
                }
            } else {
                sink.writeInt(length);
                vals.externalize(sink);
            }
        }
    }

    public void setProjection(int dimension, int start, int stride, int stop) throws InvalidParameterException {
        DArrayDimension d = this.getDimension(dimension);
        d.setProjection(start, stride, stop);
    }

    public int getStart(int dimension) throws InvalidParameterException {
        DArrayDimension d = this.getDimension(dimension);
        return d.getStart();
    }

    public int getStride(int dimension) throws InvalidParameterException {
        DArrayDimension d = this.getDimension(dimension);
        return d.getStride();
    }

    public int getStop(int dimension) throws InvalidParameterException {
        DArrayDimension d = this.getDimension(dimension);
        return d.getStop();
    }
}

