/* Generated By:JavaCC: Do not edit this line. UnitParser.java */
package visad.data.units;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Calendar;
import java.util.TimeZone;

import visad.DerivedUnit;
import visad.SI;
import visad.Unit;
import visad.UnitException;

/**
 * A class for parsing string unit specifications.
 * 
 * Instances are thread-compatible but not thread-safe.
 */
public class UnitParser implements UnitParserConstants {
    /**
     * The units database.
     */
    protected static UnitsDB    unitsDB         = null;

    static {
        try {
            unitsDB = DefaultUnitsDB.instance();
        }
        catch (final UnitException e) {
        }
    }

    /**
     * The canonical time unit.
     */
    protected static final Unit SECOND          = SI.second;

    /**
     * The Julian day number of the (artificial) time origin.
     */
    protected static final long julianDayOrigin = UnitParser.julianDay(2001, 1,
                                                        1);

    /**
     * The dimensionless unit one.
     */
    private static final Unit   ONE             = new DerivedUnit();

    /**
     * Compute the Julian day number of a date.
     */
    public static long julianDay(int year, final int month, final int day) {
        final long igreg = 15 + 31 * (10 + (12 * 1582));
        int iy; // signed, origin-0 year
        int ja; // Julian century
        int jm; // Julian month
        int jy; // Julian year
        long julday; // returned Julian day number

        /*
         * Because there is no 0 BC or 0 AD, assume the user wants the start of
         * the common era if they specify year 0.
         */
        if (year == 0) {
            year = 1;
        }

        iy = year;
        if (year < 0) {
            iy++;
        }
        if (month > 2) {
            jy = iy;
            jm = month + 1;
        }
        else {
            jy = iy - 1;
            jm = month + 13;

        }

        julday = day + (int) (30.6001 * jm);
        if (jy >= 0) {
            julday += 365 * jy;
            julday += 0.25 * jy;
        }
        else {
            double xi = 365.25 * jy;

            if ((int) xi != xi) {
                xi -= 1;
            }
            julday += (int) xi;
        }
        julday += 1720995;

        if (day + (31 * (month + (12 * iy))) >= igreg) {
            ja = jy / 100;
            julday -= ja;
            julday += 2;
            julday += ja / 4;
        }

        return julday;
    }

    /**
     * Encode a timestamp as a double value in units of seconds.
     */
    public static double encodeTimestamp(final int year, final int month,
            final int day, final int hour, final int minute,
            final float second, final int zone) {
        return (julianDay(year, month, day) - julianDayOrigin) * 86400.0
                + (hour * 60 + minute - zone) * 60 + second;
    }

    private static void myAssert(final UnitParser parser, final String spec,
            final Unit expect) throws UnitException, ParseException {
        if (!parser.parse(spec).equals(expect)) {
            throw new AssertionError("Got \"" + spec + "; expected \"" + expect
                    + "\"");
        }
    }

    /**
     * Parses a string unit specification.
     * 
     * @param spec
     *            The unit specification.
     * @return A {@link Unit} corresponding to {@code spec}.
     * @throws NullPointerException
     *             if {@code spec} is {@code null}.
     * @throws ParseException
     *             if a parsing error occurred.
     * @throws UnitException
     *             if the string specifies an invalid unit operation.
     */
    public Unit parse(final String spec) throws ParseException, UnitException {
        ReInit(new ByteArrayInputStream(spec.getBytes()));
        return unitSpec();
    }

    /**
     * Test this class.
     */
    public static void main(final String[] args) throws Exception {
        final UnitParser parser = new UnitParser(System.in);
        final LineNumberReader lineInput = new LineNumberReader(
                new InputStreamReader(System.in));
        final Unit s = unitsDB.get("s");
        final Unit m = unitsDB.get("m");
        final Unit kg = unitsDB.get("kg");
        final Unit w = unitsDB.get("W");
        final Unit epoch = s.shift(encodeTimestamp(1970, 1, 1, 0, 0, 0f, 0));

        myAssert(parser, "m m", m.multiply(m));
        myAssert(parser, "m.m", m.multiply(m));
        myAssert(parser, "(m)(m)", m.pow(2));
        myAssert(parser, "m/s/s", m.divide(s).divide(s));
        myAssert(parser, "m2", m.pow(2));
        myAssert(parser, "m2.s", m.pow(2).multiply(s));
        myAssert(parser, "m2/s", m.pow(2).divide(s));
        myAssert(parser, "m^2/s", m.pow(2).divide(s));
        myAssert(parser, "m s @ 5", m.multiply(s).shift(5));
        myAssert(parser, "m2 s @ 5", m.pow(2).multiply(s).shift(5));
        myAssert(parser, "m2 s-1 @ 5", m.pow(2).divide(s).shift(5));
        myAssert(parser, "m s from 5", m.multiply(s).shift(5));
        myAssert(parser, "m s kg @ 5", m.multiply(s).multiply(kg).shift(5));
        myAssert(parser, "s@19700101", epoch);
        myAssert(parser, "s@19700101T000000", epoch);
        myAssert(parser, "s@19700101T000000.00", epoch);
        myAssert(parser, "s @ 1970-01-01T00:00:00.00", epoch);
        myAssert(parser, "s @ 1970-01-01 00:00:00.00", epoch);
        myAssert(parser, "s @ 1970-01-01T00:00:00.00 -12", s
                .shift(encodeTimestamp(1970, 1, 1, 12, 0, 0f, 0)));
        myAssert(parser, "s @ 1970-01-01T00:00:00.00 -12", s
                .shift(encodeTimestamp(1970, 1, 1, 0, 0, 0f, -12 * 60)));
        myAssert(parser, "lg(re: 1)", ONE.log(10));
        myAssert(parser, "0.1 lg(re 1 mW)", w.scale(1e-3).log(10).scale(0.1));
        myAssert(parser, "m", m);
        myAssert(parser, "2 m s", m.multiply(s).scale(2));
        myAssert(parser, "3.14 m.s", m.multiply(s).scale(3.14));
        myAssert(parser, "1e9 (m)", m.scale(1e9));
        myAssert(parser, "(m s)2", m.multiply(s).pow(2));
        myAssert(parser, "m2.s-1", m.pow(2).divide(s));
        myAssert(parser, "m2 s^-1", m.pow(2).divide(s));
        myAssert(parser, "(m/s)2", m.divide(s).pow(2));
        myAssert(parser, "m2/s-1", m.pow(2).divide(s.pow(-1)));
        myAssert(parser, "m2/s^-1", m.pow(2).divide(s.pow(-1)));
        myAssert(parser, ".5 m/(.25 s)2", m.scale(.5).divide(
                s.scale(.25).pow(2)));
        myAssert(parser, "m.m-1.m", m.multiply(m.pow(-1)).multiply(m));
        myAssert(parser, "2.0 m 1/2 s-1*(m/s^1)^-1 (1e9 m-1)(1e9 s-1)-1.m/s", m
                .scale(2).scale(1. / 2.).multiply(s.pow(-1)).multiply(
                        m.divide(s.pow(1)).pow(-1)).multiply(
                        m.pow(-1).scale(1e9)).multiply(
                        s.pow(-1).scale(1e9).pow(-1)).multiply(m).divide(s));
        myAssert(parser, "m/km", m.divide(m.scale(1e3)));

        for (;;) {
            System.out.print("Enter a unit specification or ^D to quit: ");

            String spec = lineInput.readLine();
            if (spec == null) {
                break;
            }

            spec = spec.trim();

            if (spec.length() > 0) {
                parser.ReInit(new ByteArrayInputStream(spec.getBytes()));

                try {
                    final Unit unit = parser.unitSpec();
                    System.out.println("unit = " + unit);
                    System.out.println("definition = " + unit.getDefinition());
                }
                catch (final ParseException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        System.out.println("");
    }

    final public Unit unitSpec() throws ParseException, UnitException {
        Unit unit = ONE;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
        case MINUS:
        case UINT:
        case LPAREN:
        case PERIOD:
        case SYMBOL:
        case T:
        case NAME:
        case LB:
        case LN:
        case LG:
            unit = shiftExpr();
            break;
        default:
            jj_la1[0] = jj_gen;
            ;
        }
        jj_consume_token(0);
        {
            if (true) {
                return unit;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Unit shiftExpr() throws ParseException, UnitException {
        Unit unit;
        double origin;
        unit = productExpr();
        if (jj_2_1(2)) {
            jj_consume_token(SHIFT);
            if (Unit.canConvert(unit, SECOND)) {
                origin = timeOriginExpr();
                unit = unit.shift(unit.toThis(origin, SECOND));
            }
            else {
                origin = number();
                if (origin != 0) {
                    unit = unit.shift(origin);
                }
            }
        }
        else {
            ;
        }
        {
            if (true) {
                return unit;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Unit productExpr() throws ParseException, UnitException {
        Unit unit, unit2;
        unit = powerExpr();
        label_1: while (true) {
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case SP:
            case PLUS:
            case MINUS:
            case UINT:
            case LPAREN:
            case PERIOD:
            case STAR:
            case DIVIDE:
            case SYMBOL:
            case T:
            case NAME:
            case LB:
            case LN:
            case LG:
                ;
                break;
            default:
                jj_la1[1] = jj_gen;
                break label_1;
            }
            if (jj_2_2(2)) {
                jj_consume_token(DIVIDE);
                unit2 = powerExpr();
                unit = unit.divide(unit2);
            }
            else {
                switch ((jj_ntk == -1)
                        ? jj_ntk()
                        : jj_ntk) {
                case SP:
                case PLUS:
                case MINUS:
                case UINT:
                case LPAREN:
                case PERIOD:
                case STAR:
                case SYMBOL:
                case T:
                case NAME:
                case LB:
                case LN:
                case LG:
                    switch ((jj_ntk == -1)
                            ? jj_ntk()
                            : jj_ntk) {
                    case SP:
                    case PERIOD:
                    case STAR:
                        switch ((jj_ntk == -1)
                                ? jj_ntk()
                                : jj_ntk) {
                        case PERIOD:
                            jj_consume_token(PERIOD);
                            break;
                        case STAR:
                            jj_consume_token(STAR);
                            break;
                        case SP:
                            jj_consume_token(SP);
                            break;
                        default:
                            jj_la1[2] = jj_gen;
                            jj_consume_token(-1);
                            throw new ParseException();
                        }
                        break;
                    default:
                        jj_la1[3] = jj_gen;
                        ;
                    }
                    unit2 = powerExpr();
                    unit = unit.multiply(unit2);
                    break;
                default:
                    jj_la1[4] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        {
            if (true) {
                return unit;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Unit powerExpr() throws ParseException, UnitException {
        Unit unit;
        int exponent;
        unit = basicExpr();
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
        case MINUS:
        case UINT:
        case RAISE:
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case RAISE:
                jj_consume_token(RAISE);
                break;
            default:
                jj_la1[5] = jj_gen;
                ;
            }
            exponent = integer();
            unit = unit.pow(exponent);
            break;
        default:
            jj_la1[6] = jj_gen;
            ;
        }
        {
            if (true) {
                return unit;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Unit basicExpr() throws ParseException, UnitException {
        Unit unit;
        double number;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
        case MINUS:
        case UINT:
        case PERIOD:
            number = number();
            unit = ONE.scale(number);
            break;
        case SYMBOL:
        case T:
        case NAME:
            unit = unitIdentifier();
            break;
        case LB:
        case LN:
        case LG:
            unit = logExpr();
            break;
        case LPAREN:
            jj_consume_token(LPAREN);
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case SP:
                jj_consume_token(SP);
                break;
            default:
                jj_la1[7] = jj_gen;
                ;
            }
            unit = shiftExpr();
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case SP:
                jj_consume_token(SP);
                break;
            default:
                jj_la1[8] = jj_gen;
                ;
            }
            jj_consume_token(RPAREN);
            break;
        default:
            jj_la1[9] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        {
            if (true) {
                return unit;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Unit unitIdentifier() throws ParseException {
        Token token;
        Unit unit;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case T:
            token = jj_consume_token(T);
            break;
        case NAME:
            token = jj_consume_token(NAME);
            break;
        case SYMBOL:
            token = jj_consume_token(SYMBOL);
            break;
        default:
            jj_la1[10] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        unit = unitsDB.get(token.image);
        if (unit == null) {
            {
                if (true) {
                    throw new NoSuchUnitException("Unit not in database");
                }
            }
        }
        {
            if (true) {
                return unit;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Unit logExpr() throws ParseException, UnitException {
        double base;
        Unit ref;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case LB:
            jj_consume_token(LB);
            base = 2;
            break;
        case LN:
            jj_consume_token(LN);
            base = Math.E;
            break;
        case LG:
            jj_consume_token(LG);
            base = 10;
            break;
        default:
            jj_la1[11] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        ref = productExpr();
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case SP:
            jj_consume_token(SP);
            break;
        default:
            jj_la1[12] = jj_gen;
            ;
        }
        jj_consume_token(RPAREN);
        {
            if (true) {
                return ref.log(base);
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public double number() throws ParseException {
        double number;
        if (jj_2_3(3)) {
            number = real();
        }
        else {
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case PLUS:
            case MINUS:
            case UINT:
                number = integer();
                break;
            default:
                jj_la1[13] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
        {
            if (true) {
                return number;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public double real() throws ParseException {
        int sign = 1;
        double tenFactor = 1;
        double udecimal;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
        case MINUS:
            sign = sign();
            break;
        default:
            jj_la1[14] = jj_gen;
            ;
        }
        if (jj_2_4(2)) {
            udecimal = unsignedDecimal();
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case REAL_EXP:
                tenFactor = tenFactor();
                break;
            default:
                jj_la1[15] = jj_gen;
                ;
            }
        }
        else {
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case UINT:
                udecimal = unsignedInteger();
                tenFactor = tenFactor();
                break;
            default:
                jj_la1[16] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
        {
            if (true) {
                return sign * udecimal * tenFactor;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public int sign() throws ParseException {
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
            jj_consume_token(PLUS);
            {
                if (true) {
                    return 1;
                }
            }
            break;
        case MINUS:
            jj_consume_token(MINUS);
            {
                if (true) {
                    return -1;
                }
            }
            break;
        default:
            jj_la1[17] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public double unsignedDecimal() throws ParseException {
        int integer = 0;
        Token token;
        double fraction = 0;
        if (jj_2_5(3)) {
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case UINT:
                integer = unsignedInteger();
                break;
            default:
                jj_la1[18] = jj_gen;
                ;
            }
            jj_consume_token(PERIOD);
            token = jj_consume_token(UINT);
            fraction = Double.valueOf("." + token.image);
        }
        else {
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case UINT:
                integer = unsignedInteger();
                jj_consume_token(PERIOD);
                break;
            default:
                jj_la1[19] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
        {
            if (true) {
                return integer + fraction;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public double tenFactor() throws ParseException {
        Token token;
        token = jj_consume_token(REAL_EXP);
        {
            if (true) {
                return Double.valueOf("1" + token.image);
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public int integer() throws ParseException {
        int magnitude;
        int sign = 1;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
        case MINUS:
            sign = sign();
            break;
        default:
            jj_la1[20] = jj_gen;
            ;
        }
        magnitude = unsignedInteger();
        {
            if (true) {
                return sign * magnitude;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public int unsignedInteger() throws ParseException {
        Token token;
        token = jj_consume_token(UINT);
        {
            if (true) {
                return Integer.valueOf(token.image);
            }
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * See <http://www.cl.cam.ac.uk/~mgk25/iso-time.html> for a discussion of
     * the relevant timestamp format or lookup "ISO 8601".
     */
    final public double timeOriginExpr() throws ParseException {
        Calendar calendar;
        calendar = dateExpr();
        if (jj_2_7(2)) {
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case T:
                jj_consume_token(T);
                break;
            case SP:
                jj_consume_token(SP);
                break;
            default:
                jj_la1[21] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            clockExpr(calendar);
            if (jj_2_6(2)) {
                switch ((jj_ntk == -1)
                        ? jj_ntk()
                        : jj_ntk) {
                case SP:
                    jj_consume_token(SP);
                    break;
                default:
                    jj_la1[22] = jj_gen;
                    ;
                }
                zoneExpr(calendar);
            }
            else {
                ;
            }
        }
        else {
            ;
        }
        {
            if (true) {
                return encodeTimestamp(calendar.get(Calendar.YEAR), calendar
                        .get(Calendar.MONTH) + 1, calendar
                        .get(Calendar.DAY_OF_MONTH), calendar
                        .get(Calendar.HOUR_OF_DAY), calendar
                        .get(Calendar.MINUTE), (float) (calendar
                        .get(Calendar.SECOND) + calendar
                        .get(Calendar.MILLISECOND) / 1e3), calendar
                        .get(Calendar.ZONE_OFFSET)
                        / (1000 * 60));
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Calendar dateExpr() throws ParseException {
        int sign = 1;
        int year;
        int month = 1;
        int day = 1;
        boolean packed = true;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
        case MINUS:
            sign = sign();
            break;
        default:
            jj_la1[23] = jj_gen;
            ;
        }
        year = unsignedInteger();
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case MINUS:
            jj_consume_token(MINUS);
            month = unsignedInteger();
            packed = false;
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case MINUS:
                jj_consume_token(MINUS);
                day = unsignedInteger();
                break;
            default:
                jj_la1[24] = jj_gen;
                ;
            }
            break;
        default:
            jj_la1[25] = jj_gen;
            ;
        }
        if (packed) {
            if (year >= 10000101) {
                day = year % 100;
                year /= 100;
            }
            if (year >= 100001) {
                month = year % 100;
                year /= 100;
            }
            if (sign < 0) {
                year = -year;
            }
        }
        if (month < 1 || month > 12) {
            if (true) {
                throw new ParseException("invalid month in timestamp");
            }
        }
        if (day < 1 || day > 31) {
            if (true) {
                throw new ParseException("invalid day in timestamp");
            }
        }
        final Calendar calendar = Calendar.getInstance(TimeZone
                .getTimeZone("UTC"));
        calendar.clear();
        calendar.set(year, month - 1, day);
        {
            if (true) {
                return calendar;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Calendar clockExpr(final Calendar calendar)
            throws ParseException {
        double hour;
        int minute = 0;
        double seconds = 0;
        boolean packed = true;
        if (jj_2_8(2)) {
            hour = unsignedDecimal();
        }
        else {
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case UINT:
                hour = unsignedInteger();
                break;
            default:
                jj_la1[26] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case COLON:
            jj_consume_token(COLON);
            minute = unsignedInteger();
            packed = false;
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case COLON:
                jj_consume_token(COLON);
                if (jj_2_9(2)) {
                    seconds = unsignedDecimal();
                }
                else {
                    switch ((jj_ntk == -1)
                            ? jj_ntk()
                            : jj_ntk) {
                    case UINT:
                        seconds = unsignedInteger();
                        break;
                    default:
                        jj_la1[27] = jj_gen;
                        jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                break;
            default:
                jj_la1[28] = jj_gen;
                ;
            }
            break;
        default:
            jj_la1[29] = jj_gen;
            ;
        }
        if (packed) {
            if (hour >= 100000) {
                seconds = hour % 100;
                hour /= 100;
            }
            if (hour >= 1000) {
                minute = (int) (hour % 100);
                hour /= 100;
            }
        }
        if (hour < 0 || hour > 23) {
            if (true) {
                throw new ParseException("invalid hour in timestamp");
            }
        }
        if (minute < 0 || minute > 59) {
            if (true) {
                throw new ParseException("invalid minute in timestamp");
            }
        }
        if (seconds < 0 || seconds > 61) {
            if (true) {
                throw new ParseException("invalid seconds in timestamp");
            }
        }
        calendar.set(Calendar.HOUR_OF_DAY, (int) Math.round(hour));
        calendar.set(Calendar.MINUTE, minute);
        final int s = (int) seconds;
        calendar.set(Calendar.SECOND, s);
        final int ms = (int) ((seconds - s) * 1000);
        calendar.set(Calendar.MILLISECOND, ms);
        {
            if (true) {
                return calendar;
            }
        }
        throw new Error("Missing return statement in function");
    }

    final public Calendar zoneExpr(final Calendar calendar)
            throws ParseException {
        int sign = 1;
        int zoneHour;
        int zoneMinute = 0;
        Token token;
        TimeZone timeZone;
        switch ((jj_ntk == -1)
                ? jj_ntk()
                : jj_ntk) {
        case PLUS:
        case MINUS:
        case UINT:
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case PLUS:
            case MINUS:
                sign = sign();
                break;
            default:
                jj_la1[30] = jj_gen;
                ;
            }
            zoneHour = unsignedInteger();
            switch ((jj_ntk == -1)
                    ? jj_ntk()
                    : jj_ntk) {
            case COLON:
            case UINT:
                switch ((jj_ntk == -1)
                        ? jj_ntk()
                        : jj_ntk) {
                case COLON:
                    jj_consume_token(COLON);
                    break;
                default:
                    jj_la1[31] = jj_gen;
                    ;
                }
                zoneMinute = unsignedInteger();
                break;
            default:
                jj_la1[32] = jj_gen;
                ;
            }
            if (zoneHour >= 100) {
                zoneMinute += zoneHour % 100;
                zoneHour /= 100;
            }
            if (zoneHour > 23 || zoneMinute > 59) {
                {
                    if (true) {
                        throw new ParseException(
                                "invalid time-zone in timestamp");
                    }
                }
            }
            timeZone = TimeZone.getDefault();
            timeZone.setRawOffset(sign * (zoneHour * 60 + zoneMinute) * 60
                    * 1000);
            break;
        case NAME:
            token = jj_consume_token(NAME);
            timeZone = TimeZone.getTimeZone(token.image);
            break;
        default:
            jj_la1[33] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        calendar.setTimeZone(timeZone);
        {
            if (true) {
                return calendar;
            }
        }
        throw new Error("Missing return statement in function");
    }

    private boolean jj_2_1(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(0, xla);
        }
    }

    private boolean jj_2_2(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(1, xla);
        }
    }

    private boolean jj_2_3(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_3();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(2, xla);
        }
    }

    private boolean jj_2_4(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_4();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(3, xla);
        }
    }

    private boolean jj_2_5(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_5();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(4, xla);
        }
    }

    private boolean jj_2_6(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_6();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(5, xla);
        }
    }

    private boolean jj_2_7(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_7();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(6, xla);
        }
    }

    private boolean jj_2_8(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_8();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(7, xla);
        }
    }

    private boolean jj_2_9(final int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_9();
        }
        catch (final LookaheadSuccess ls) {
            return true;
        }
        finally {
            jj_save(8, xla);
        }
    }

    private boolean jj_3R_33() {
        if (jj_scan_token(LG)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_35() {
        if (jj_3R_20()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_32() {
        if (jj_scan_token(LN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_34() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_35()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_12()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_14() {
        if (jj_scan_token(NAME)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_2() {
        if (jj_scan_token(DIVIDE)) {
            return true;
        }
        if (jj_3R_2()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_31() {
        if (jj_scan_token(LB)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_27() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_31()) {
            jj_scanpos = xsp;
            if (jj_3R_32()) {
                jj_scanpos = xsp;
                if (jj_3R_33()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_22() {
        if (jj_scan_token(REAL_EXP)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_24() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(4)) {
            jj_scanpos = xsp;
        }
        if (jj_3R_12()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_23() {
        if (jj_3R_20()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_13() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_23()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_12()) {
            return true;
        }
        xsp = jj_scanpos;
        if (jj_3R_24()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_11() {
        if (jj_3R_12()) {
            return true;
        }
        if (jj_scan_token(PERIOD)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_5() {
        if (jj_3R_12()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_6() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_13()) {
            jj_scanpos = xsp;
            if (jj_3R_14()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_5()) {
            jj_scanpos = xsp;
        }
        if (jj_scan_token(PERIOD)) {
            return true;
        }
        if (jj_scan_token(UINT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3_1() {
        if (jj_scan_token(SHIFT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_26() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(17)) {
            jj_scanpos = xsp;
            if (jj_scan_token(18)) {
                jj_scanpos = xsp;
                if (jj_scan_token(16)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_4() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_5()) {
            jj_scanpos = xsp;
            if (jj_3R_11()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_19() {
        if (jj_scan_token(LPAREN)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_18() {
        if (jj_3R_27()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_29() {
        if (jj_scan_token(MINUS)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_17() {
        if (jj_3R_26()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_28() {
        if (jj_scan_token(PLUS)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_20() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_28()) {
            jj_scanpos = xsp;
            if (jj_3R_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_16() {
        if (jj_3R_25()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_6() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(1)) {
            jj_scanpos = xsp;
        }
        if (jj_3R_6()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_10() {
        if (jj_3R_12()) {
            return true;
        }
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_21() {
        if (jj_3R_22()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_9() {
        if (jj_3R_4()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_4() {
        if (jj_3R_4()) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_21()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_8() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_16()) {
            jj_scanpos = xsp;
            if (jj_3R_17()) {
                jj_scanpos = xsp;
                if (jj_3R_18()) {
                    jj_scanpos = xsp;
                    if (jj_3R_19()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_scan_token(17)) {
            jj_scanpos = xsp;
            if (jj_scan_token(1)) {
                return true;
            }
        }
        if (jj_3R_7()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_9() {
        if (jj_3R_20()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_3() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3R_9()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3_4()) {
            jj_scanpos = xsp;
            if (jj_3R_10()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_15() {
        if (jj_3R_12()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_30() {
        if (jj_3R_34()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_8() {
        if (jj_3R_4()) {
            return true;
        }
        return false;
    }

    private boolean jj_3_3() {
        if (jj_3R_3()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_2() {
        if (jj_3R_8()) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_12() {
        if (jj_scan_token(UINT)) {
            return true;
        }
        return false;
    }

    private boolean jj_3R_7() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_8()) {
            jj_scanpos = xsp;
            if (jj_3R_15()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_25() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_3()) {
            jj_scanpos = xsp;
            if (jj_3R_30()) {
                return true;
            }
        }
        return false;
    }

    /** Generated Token Manager. */
    public UnitParserTokenManager token_source;
    SimpleCharStream              jj_input_stream;
    /** Current token. */
    public Token                  token;
    /** Next token. */
    public Token                  jj_nt;
    private int                   jj_ntk;
    private Token                 jj_scanpos, jj_lastpos;
    private int                   jj_la;
    private int                   jj_gen;
    final private int[]           jj_la1 = new int[34];
    static private int[]          jj_la1_0;
    static {
        jj_la1_init_0();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[] { 0x3f112c, 0x3f712e, 0x3002, 0x3002, 0x3f312e,
                0x800, 0x82c, 0x2, 0x2, 0x3f112c, 0x70000, 0x380000, 0x2, 0x2c,
                0xc, 0x400, 0x20, 0xc, 0x20, 0x20, 0xc, 0x20002, 0x2, 0xc, 0x8,
                0x8, 0x20, 0x20, 0x10, 0x10, 0xc, 0x10, 0x30, 0x4002c, };
    }

    final private JJCalls[] jj_2_rtns = new JJCalls[9];
    private boolean         jj_rescan = false;
    private int             jj_gc     = 0;

    /** Constructor with InputStream. */
    public UnitParser(final java.io.InputStream stream) {
        this(stream, null);
    }

    /** Constructor with InputStream and supplied encoding */
    public UnitParser(final java.io.InputStream stream, final String encoding) {
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (final java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new UnitParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 34; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Reinitialise. */
    public void ReInit(final java.io.InputStream stream) {
        ReInit(stream, null);
    }

    /** Reinitialise. */
    public void ReInit(final java.io.InputStream stream, final String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (final java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 34; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Constructor. */
    public UnitParser(final java.io.Reader stream) {
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new UnitParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 34; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Reinitialise. */
    public void ReInit(final java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 34; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Constructor with generated Token Manager. */
    public UnitParser(final UnitParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 34; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /** Reinitialise. */
    public void ReInit(final UnitParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 34; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(final int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        }
        else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    static private final class LookaheadSuccess extends java.lang.Error {
    }

    final private LookaheadSuccess jj_ls = new LookaheadSuccess();

    private boolean jj_scan_token(final int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source
                        .getNextToken();
            }
            else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        }
        else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if (jj_la == 0 && jj_scanpos == jj_lastpos) {
            throw jj_ls;
        }
        return false;
    }

    /** Get the next Token. */
    final public Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        }
        else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    /** Get the specific Token. */
    final public Token getToken(final int index) {
        Token t = token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            }
            else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    private int jj_ntk() {
        if ((jj_nt = token.next) == null) {
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        }
        else {
            return (jj_ntk = jj_nt.kind);
        }
    }

    private final java.util.List jj_expentries = new java.util.ArrayList();
    private int[]                jj_expentry;
    private int                  jj_kind       = -1;
    private final int[]          jj_lasttokens = new int[100];
    private int                  jj_endpos;

    private void jj_add_error_token(final int kind, final int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        }
        else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            jj_entries_loop: for (final java.util.Iterator it = jj_expentries
                    .iterator(); it.hasNext();) {
                final int[] oldentry = (int[]) (it.next());
                if (oldentry.length == jj_expentry.length) {
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            continue jj_entries_loop;
                        }
                    }
                    jj_expentries.add(jj_expentry);
                    break jj_entries_loop;
                }
            }
            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    /** Generate ParseException. */
    public ParseException generateParseException() {
        jj_expentries.clear();
        final boolean[] la1tokens = new boolean[23];
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 34; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 23; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        final int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = (int[]) jj_expentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    /** Enable tracing. */
    final public void enable_tracing() {
    }

    /** Disable tracing. */
    final public void disable_tracing() {
    }

    private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 9; i++) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen > jj_gen) {
                        jj_la = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                        case 0:
                            jj_3_1();
                            break;
                        case 1:
                            jj_3_2();
                            break;
                        case 2:
                            jj_3_3();
                            break;
                        case 3:
                            jj_3_4();
                            break;
                        case 4:
                            jj_3_5();
                            break;
                        case 5:
                            jj_3_6();
                            break;
                        case 6:
                            jj_3_7();
                            break;
                        case 7:
                            jj_3_8();
                            break;
                        case 8:
                            jj_3_9();
                            break;
                        }
                    }
                    p = p.next;
                } while (p != null);
            }
            catch (final LookaheadSuccess ls) {
            }
        }
        jj_rescan = false;
    }

    private void jj_save(final int index, final int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {
        int     gen;
        Token   first;
        int     arg;
        JJCalls next;
    }

}
