/*

@(#) $Id: Slider.java,v 1.3 1998/07/30 20:30:05 curtis Exp $

VisAD Utility Library: Widgets for use in building applications with
the VisAD interactive analysis and visualization library
Copyright (C) 1998 Nick Rasmussen
VisAD is Copyright (C) 1996 - 1998 Bill Hibbard, Curtis Rueden, Tom
Rink and Dave Glowacki.
 
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file NOTICE for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

package visad.util;

import java.awt.Panel;
import java.util.Vector;

/**
 * An abstract class which is very similar to java.awt.ScrollBar, except using
 * all floating point values and having an internal name.
 *
 * Although the interface has nothing to do with orientation, a horizontal
 * orientation will be assumed by several other classes
 *
 * @author Nick Rasmussen nick@cae.wisc.edu
 * @version $Revision: 1.3 $, $Date: 1998/07/30 20:30:05 $
 * @since Visad Utility Library v0.7.1
 */
 
 public abstract class Slider extends Panel {
 
 	/** 
	 * The internal name of the slider, accessed through getName()
	 * @see #getName
	 */
 	protected String name;
	
	/** Get the internal name for this slider */
	public String getName() {
		return name;
	}
	
	
	/** Return the minimum value of this slider */
	public abstract float getMinimum();
	
	/** Sets the minimum value for this slider */
	public abstract void setMinimum(float value);
	
	/** Return the maximum value of this slider */
	public abstract float getMaximum();
	
	/** Sets the maximum value of this scrolbar */
	public abstract void setMaximum(float value);
	
	/** Returns the current value of the slider */
	public abstract float getValue();
	
	/** Sets the current value of the slider */
	public abstract void setValue(float value);
	
	
	/** The vector containing the SliderChangeListeners */
	protected Vector listeners = new Vector();
	
	/** Add a SliderChangeListener to the listeners list */
	public synchronized void addSliderChangeListener(SliderChangeListener s) {
		if (!listeners.contains(s)) {
			listeners.addElement(s);
		}
	}
	
	/** Remove a SliderChangeListener from the listeners list */
	public synchronized void removeSliderChangeListener(SliderChangeListener s) {
		if (listeners.contains(s)) {
			listeners.removeElement(s);
		}
	}
	
	/** Notify the ColorChangeListerers that the color widget has changed */
	protected synchronized void notifyListeners(SliderChangeEvent e) {
		for (int i = 0; i < listeners.size(); i++) {
			SliderChangeListener s = (SliderChangeListener) listeners.elementAt(i);
			s.sliderChanged(e);
		}
	}
}
