
      SUBROUTINE DBDTGX_1(TBB, dbdtgx)
c * GOES/I-M derivative of radiance w.r.t. BB-temp in channel K
c   Call 'PFCOGX' before using this or 'PLANGX' or 'BRITGX' or 'SKINGX'
c      T = temperature, deg K
c      K = channel number: 1,...,25
      integer NCHAN
      parameter (NCHAN=18)
      real tbb(NCHAN),dbdtgx(NCHAN)
C      integer neles
      parameter (nk=25,nt=2)
      dimension fk1(nk),fk2(nk),tc(nt,nk)
      data fk1/3756.812,4011.098,4296.867,4681.129,4975.250,
     +          5881.412,6787.444,8873.706,12997.94,28629.32,
     +          34248.30,43114.30,124235.3,128123.5,135148.2,
     + 69167.1,188235.0,225794.4,4.3370456E+07,0.0000000E+00,
     +      4.3370456E+07,199986.2,38792.39,9737.926,6944.639/
      data fk2/979.3953,1001.012,1024.241,1053.906,1075.531,
     +         1137.222,1192.853,1304.327,1481.300,1927.326,
     +         2045.963,2209.151,3143.643,3176.102,3233.118,
     +     3484.364,3610.647,3836.389,22135.17,0.0000000E+00,
     +         22135.17,3684.271,2132.719,1345.366,1201.992/
      data (tc(1,i),i=1,nk)/
     +    1.2336628E-02,1.3267889E-02,1.8560313E-02,
     +    1.5043835E-02,1.6495598E-02,4.7438480E-02,
     +    0.1318361,0.1200001,4.2603634E-02,
     +    0.1505228,0.2742842,0.1446739,
     +    2.2373570E-02,2.2004472E-02,2.1657581E-02,
     +    5.7855226E-02,6.2304594E-02,0.3675149,
     +    0.0000000E+00,0.0000000E+00,0.0000000E+00,
     +    0.6357170,0.6060195,0.3734982,0.2217343/
      data (tc(2,i),i=1,nk)/
     +  0.9999424,0.9999390,0.9999170,0.9999349,0.9999295,
     +  0.9998090,0.9994960,0.9995798,0.9998662,0.9996188,
     +  0.9993366,0.9996705,0.9999632,0.9999637,0.9999648,
     +  0.9999133,0.9999098,0.9994776,1.000000,0.0000000E+00,
     +  1.000000,0.9991093,0.9985816,0.9987274,0.9991590/

C      CALL AD1D(1,NCHAN,TBB,NELES)
C      common/plncgx/wnum(nk),fk1(nk),fk2(nk),tc(nt,nk)
      do k=1,NCHAN
         t=tbb(k)
         tt=tc(1,k)+tc(2,k)*t
         expn=exp(fk2(k)/tt) - 1.
         b=fk1(k)/expn
         bb=b*b
         tt=t*t
         expn=exp(fk2(k)/t)
         q=fk2(k)/fk1(k)
         dbdtgx(k)=q*expn*bb/tt
      enddo !k
      write (6,*) 'noise',dbdtgx
C      CALL ADR1D(2,dbdtgx,NELES)
      return
      end

