/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import ucar.multiarray.Accessor;
import ucar.netcdf.AbstractNetcdf;
import ucar.netcdf.NetcdfRemoteProxy;
import ucar.netcdf.NetcdfService;
import ucar.netcdf.ProtoVariable;

public class RemoteNetcdf
extends AbstractNetcdf {
    private NetcdfRemoteProxy remote;

    public static NetcdfService getNetcdfService(String remoteHostName) throws RemoteException, NotBoundException, MalformedURLException {
        String svcName = "//" + remoteHostName + "/" + "NetcdfService";
        return (NetcdfService)Naming.lookup(svcName);
    }

    public RemoteNetcdf(NetcdfRemoteProxy remote) throws IOException {
        super(remote.getSchema(), false);
        this.remote = remote;
        try {
            super.initHashtable();
        }
        catch (InstantiationException instantiationException) {
            throw new Error();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error();
        }
        catch (InvocationTargetException ite) {
            throw (RuntimeException)ite.getTargetException();
        }
    }

    public RemoteNetcdf(String remoteHostName, String dataSetName) throws IOException, NotBoundException, MalformedURLException {
        this(RemoteNetcdf.getNetcdfService(remoteHostName).lookup(dataSetName));
    }

    protected Accessor ioFactory(ProtoVariable proto) throws InvocationTargetException {
        try {
            return this.remote.getAccessor(proto.getName());
        }
        catch (IOException ee) {
            throw new InvocationTargetException(ee);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: TestNetcdfService nc_name");
            System.exit(1);
        }
        String name = args[0];
        try {
            RemoteNetcdf rnc = new RemoteNetcdf("localhost", name);
            System.out.println(rnc);
        }
        catch (Exception ee) {
            System.out.println(ee);
            System.exit(1);
        }
        System.exit(0);
    }
}

