/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import ucar.multiarray.Accessor;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionSet;
import ucar.netcdf.Netcdf;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.ProtoVariableIterator;
import ucar.netcdf.Schema;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;

public abstract class AbstractNetcdf
implements Netcdf {
    private final Constructor ctor;
    private final Schema delegate;
    private final Hashtable variables;

    protected AbstractNetcdf() {
        this.ctor = AbstractNetcdf.VariableCtor();
        this.delegate = new Schema();
        this.variables = new Hashtable();
    }

    protected AbstractNetcdf(Class varClass) throws NoSuchMethodException {
        this.ctor = varClass.getDeclaredConstructor(AbstractNetcdf.varCtorParameterTypes());
        this.delegate = new Schema();
        this.variables = new Hashtable();
    }

    protected AbstractNetcdf(Schema sc, boolean init) {
        this.ctor = AbstractNetcdf.VariableCtor();
        this.delegate = new Schema(sc);
        this.variables = new Hashtable(this.delegate.size());
        if (init) {
            try {
                this.initHashtable();
            }
            catch (InstantiationException instantiationException) {
                throw new Error();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error();
            }
            catch (InvocationTargetException ite) {
                throw (RuntimeException)ite.getTargetException();
            }
        }
    }

    protected AbstractNetcdf(Schema sc, boolean init, Class varClass) throws NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        this.ctor = varClass.getDeclaredConstructor(AbstractNetcdf.varCtorParameterTypes());
        this.delegate = new Schema(sc);
        this.variables = new Hashtable(this.delegate.size());
        if (init) {
            this.initHashtable();
        }
    }

    public int size() {
        return this.variables.size();
    }

    public VariableIterator iterator() {
        return new 1();
    }

    public Variable get(String name) {
        return (Variable)this.variables.get(name);
    }

    public boolean contains(String name) {
        return this.variables.containsKey(name);
    }

    public boolean contains(Object oo) {
        return this.variables.contains(oo);
    }

    public DimensionSet getDimensions() {
        return this.delegate.getDimensions();
    }

    public AttributeSet getAttributes() {
        return this.delegate.getAttributes();
    }

    public Attribute getAttribute(String name) {
        return this.delegate.getAttribute(name);
    }

    public void toCdl(StringBuffer buf) {
        this.delegate.toCdl(buf);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.toCdl(buf);
        return buf.toString();
    }

    int indexOf(Dimension dim) {
        return this.delegate.indexOf(dim);
    }

    protected abstract Accessor ioFactory(ProtoVariable var1) throws InvocationTargetException;

    protected void putDimension(Dimension dim) {
        this.delegate.putDimension(dim);
    }

    protected void putAttribute(Attribute attr) {
        this.delegate.putAttribute(attr);
    }

    protected void add(ProtoVariable proto, Accessor io) throws InstantiationException, InvocationTargetException, IllegalAccessException {
        this.delegate.put(proto);
        Object[] args = new Object[]{proto, io};
        Variable var = (Variable)this.ctor.newInstance(args);
        this.variables.put(var.getName(), var);
    }

    static final Class[] varCtorParameterTypes() {
        try {
            Class[] parameterTypes = new Class[]{Class.forName("ucar.netcdf.ProtoVariable"), Class.forName("ucar.multiarray.Accessor")};
            return parameterTypes;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("ucar.netcdf implementation error");
        }
    }

    protected void initHashtable() throws InstantiationException, InvocationTargetException, IllegalAccessException {
        ProtoVariableIterator iter = this.delegate.iterator();
        while (iter.hasNext()) {
            ProtoVariable proto = iter.next();
            Accessor io = this.ioFactory(proto);
            Object[] args = new Object[]{proto, io};
            Variable var = (Variable)this.ctor.newInstance(args);
            if (this.variables.put(var.getName(), var) == null) continue;
            throw new IllegalArgumentException("Duplicate variable name");
        }
    }

    private static Constructor VariableCtor() {
        try {
            Class<?> vc = Class.forName("ucar.netcdf.Variable");
            return vc.getDeclaredConstructor(AbstractNetcdf.varCtorParameterTypes());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Error();
        }
    }

    private final class 1
    implements VariableIterator {
        final ProtoVariableIterator iter;

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Variable next() {
            return (Variable)AbstractNetcdf.this.variables.get(this.iter.next().getName());
        }

        /* synthetic */ 1() {
            this.iter = AbstractNetcdf.this.delegate.iterator();
        }
    }
}

