/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;

public class ScalarMultiArray
implements MultiArray {
    private final Class componentType;
    private Object obj;

    public ScalarMultiArray(Class theComponentType) {
        this.componentType = theComponentType;
    }

    public ScalarMultiArray(Class theComponentType, Object value) {
        this.componentType = theComponentType;
        this.set(null, value);
    }

    public ScalarMultiArray(Object value) {
        this.componentType = value.getClass();
        this.obj = value;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public int getRank() {
        return 0;
    }

    public int[] getLengths() {
        int[] lengths = new int[]{};
        return lengths;
    }

    public boolean isUnlimited() {
        return false;
    }

    public boolean isScalar() {
        return true;
    }

    public Object get(int[] index) {
        return this.obj;
    }

    public char getChar(int[] index) {
        return ((Character)this.obj).charValue();
    }

    public boolean getBoolean(int[] index) {
        return (Boolean)this.obj;
    }

    public byte getByte(int[] index) {
        return ((Number)this.obj).byteValue();
    }

    public short getShort(int[] index) {
        return ((Number)this.obj).shortValue();
    }

    public int getInt(int[] index) {
        return ((Number)this.obj).intValue();
    }

    public long getLong(int[] index) {
        return ((Number)this.obj).longValue();
    }

    public float getFloat(int[] index) {
        return ((Number)this.obj).floatValue();
    }

    public double getDouble(int[] index) {
        return ((Number)this.obj).doubleValue();
    }

    public void set(int[] index, Object value) {
        Class<?> xcls = value.getClass();
        if (this.componentType.isPrimitive()) {
            Method tValueMethod;
            try {
                if (this.componentType == (Class)xcls.getDeclaredField("TYPE").get(value)) {
                    this.obj = value;
                    return;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            try {
                tValueMethod = xcls.getMethod(String.valueOf(this.componentType.getName()) + "Value", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException();
            }
            try {
                this.obj = tValueMethod.invoke(value, new Object[0]);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error();
            }
            catch (InvocationTargetException ite) {
                throw (RuntimeException)ite.getTargetException();
            }
        }
        if (!this.componentType.isAssignableFrom(xcls)) {
            throw new IllegalArgumentException();
        }
        this.obj = value;
    }

    public void setBoolean(int[] index, boolean value) {
        this.set(index, new Boolean(value));
    }

    public void setChar(int[] index, char value) {
        this.set(index, new Character(value));
    }

    public void setByte(int[] index, byte value) {
        this.set(index, new Byte(value));
    }

    public void setShort(int[] index, short value) {
        this.set(index, new Short(value));
    }

    public void setInt(int[] index, int value) {
        this.set(index, new Integer(value));
    }

    public void setLong(int[] index, long value) {
        this.set(index, new Long(value));
    }

    public void setFloat(int[] index, float value) {
        this.set(index, new Float(value));
    }

    public void setDouble(int[] index, double value) {
        this.set(index, new Double(value));
    }

    public MultiArray copyout(int[] origin, int[] shape) {
        if (origin != null && origin.length != 0 || shape != null && shape.length != 0) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        try {
            return new MultiArrayImpl(this);
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public void copyin(int[] origin, MultiArray src) throws IOException {
        if (origin != null && origin.length != 0 || src.getRank() != 0) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nonarg = new int[]{};
        this.set(nonarg, src.get(nonarg));
    }

    public Object toArray() {
        return this.obj;
    }

    public Object toArray(Object oo, int[] origin, int[] shape) {
        if (oo.getClass().isAssignableFrom(this.componentType)) {
            return this.obj;
        }
        throw new IllegalArgumentException();
    }
}

