/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class FlattenMap
extends ConcreteIndexMap {
    private int position_;

    public FlattenMap(int position) {
        this.init(new IMap(), new LengthsMap());
        this.position_ = position;
    }

    public FlattenMap(ConcreteIndexMap prev, int position) {
        this.link(prev, new IMap(), new LengthsMap());
        this.position_ = position;
    }

    public static void main(String[] args) {
        int[] shape = new int[]{32, 48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        int ii = 0;
        while (ii < size) {
            Array.setInt(delegate.storage, ii, ii);
            ++ii;
        }
        FlattenMap im = new FlattenMap(1);
        MultiArrayProxy ma = new MultiArrayProxy(delegate, im);
        try {
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[2]));
            int[] nArray = new int[2];
            nArray[1] = 1;
            System.out.println(ma.getInt(nArray));
            int[] nArray2 = new int[2];
            nArray2[1] = 63;
            System.out.println(ma.getInt(nArray2));
            int[] nArray3 = new int[2];
            nArray3[1] = 64;
            System.out.println(ma.getInt(nArray3));
            int[] nArray4 = new int[2];
            nArray4[1] = 3071;
            System.out.println(ma.getInt(nArray4));
            int[] nArray5 = new int[2];
            nArray5[0] = 1;
            System.out.println(ma.getInt(nArray5));
        }
        catch (IOException iOException) {}
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private int length_;
        private int value_;

        public synchronized int get(int key) {
            if (key < FlattenMap.this.position_) {
                return super.get(key);
            }
            if (key == FlattenMap.this.position_) {
                this.length_ = ((LengthsMap)FlattenMap.this.lengthsMap_).superGet(key + 1);
                int got = super.get(key);
                this.value_ = got % this.length_;
                return got / this.length_;
            }
            if (key == FlattenMap.this.position_ + 1) {
                return this.value_;
            }
            return super.get(key - 1);
        }

        public synchronized int size() {
            return super.size() + 1;
        }

        IMap() {
            FlattenMap.this = FlattenMap.this;
        }
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        public synchronized int get(int key) {
            if (key < FlattenMap.this.position_) {
                return super.get(key);
            }
            if (key == FlattenMap.this.position_) {
                return super.get(key) * super.get(key + 1);
            }
            return super.get(key + 1);
        }

        public synchronized int size() {
            return super.size() - 1;
        }

        int superGet(int key) {
            return super.get(key);
        }

        LengthsMap() {
            FlattenMap.this = FlattenMap.this;
        }
    }
}

