/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

class SensorData {
    private DataInputStream dis;
    private AncillaryData ad;
    private int dw;
    private int nb;
    private int ps;

    public SensorData(DataInputStream dataInputStream, AncillaryData ancillaryData) {
        this.dis = dataInputStream;
        this.ad = ancillaryData;
        this.dw = this.ad.getDataWidth();
        this.nb = this.ad.getNumBands();
        this.ps = this.ad.getPrefixSize();
    }

    public float[] nextLine(float[] fArray) throws IOException {
        int n = 0;
        while (n < this.ps) {
            byte by = this.dis.readByte();
            ++n;
        }
        switch (this.dw) {
            case 1: {
                int n2 = 0;
                while (n2 < this.ad.getNumElements() * this.ad.getNumBands()) {
                    fArray[n2] = this.dis.readByte();
                    ++n2;
                }
                break;
            }
            case 4: {
                int n3 = 0;
                while (n3 < this.ad.getNumElements() * this.ad.getNumBands()) {
                    fArray[n3] = this.dis.readInt();
                    ++n3;
                }
                break;
            }
            default: {
                int n4 = 0;
                while (n4 < this.ad.getNumElements() * this.ad.getNumBands()) {
                    fArray[n4] = this.dis.readShort() & 0xFFFF;
                    ++n4;
                }
                break block0;
            }
        }
        return fArray;
    }
}

