/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

class Sensor {
    private static final int GOES_8_IMAGER = 70;
    private static final int GOES_9_IMAGER = 72;
    private static final int GOES_10_IMAGER = 74;
    private static final int GOES_8_SOUNDER = 71;
    private static final int GOES_9_SOUNDER = 73;
    private static final int GOES_10_SOUNDER = 75;
    private Calibrator cal;
    private Navigator nav;
    private int sensorId = -1;

    public Sensor(DataInputStream dataInputStream, AncillaryData ancillaryData) throws IOException {
        this.sensorId = ancillaryData.getSensorId();
        switch (this.sensorId) {
            case 70: 
            case 71: {
                System.out.println("making GOES 8 cal, nav objects...");
                try {
                    this.nav = new NavigatorGvar(dataInputStream, ancillaryData);
                }
                catch (NavigatorGvarException navigatorGvarException) {
                    this.nav = null;
                    System.out.println(navigatorGvarException);
                }
                this.cal = new CalibratorGvarG8(dataInputStream, ancillaryData);
                return;
            }
            case 72: 
            case 73: {
                System.out.println("making GOES 9 cal, nav objects...");
                try {
                    this.nav = new NavigatorGvar(dataInputStream, ancillaryData);
                }
                catch (NavigatorGvarException navigatorGvarException) {
                    this.nav = null;
                    System.out.println(navigatorGvarException);
                }
                this.cal = new CalibratorGvarG9(dataInputStream, ancillaryData);
                return;
            }
            case 74: 
            case 75: {
                System.out.println("making GOES 10 cal, nav objects...");
                try {
                    this.nav = new NavigatorGvar(dataInputStream, ancillaryData);
                }
                catch (NavigatorGvarException navigatorGvarException) {
                    this.nav = null;
                    System.out.println(navigatorGvarException);
                }
                this.cal = new CalibratorGvarG10(dataInputStream, ancillaryData);
                return;
            }
        }
    }

    public Calibrator getC() {
        return this.cal;
    }

    public Navigator getN() {
        return this.nav;
    }
}

