/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

class CalibratorGvar
implements Calibrator {
    protected static final int NUM_BANDS_IMAGER = 5;
    protected static final int NUM_BANDS_SOUNDER = 18;
    protected static final int NUM_VIS_DETECTORS = 8;
    protected static final int NUM_IR_DETECTORS = 2;
    protected static final int NUM_IR_BANDS = 4;
    public static final int CAL_NONE = -1;
    public static final int CAL_MIN = 1;
    public static final int CAL_RAW = 1;
    public static final int CAL_RAD = 2;
    public static final int CAL_ALB = 3;
    public static final int CAL_TEMP = 4;
    public static final int CAL_BRIT = 5;
    public static final int CAL_MAX = 5;
    protected static int curCalType;
    protected float[] visBiasCoef = new float[8];
    protected float[] visGain1Coef = new float[8];
    protected float[] visGain2Coef = new float[8];
    protected float visRadToAlb;
    protected float[][] irBiasCoef = new float[2][4];
    protected float[][] irGainCoef = new float[2][4];
    protected float[] sBiasCoef = new float[18];
    protected float[] sGainCoef = new float[18];
    private static float gain;
    private static float bias;
    private static float scale;
    private static int bandNum;
    private static int sid;

    public CalibratorGvar(DataInputStream dataInputStream, AncillaryData ancillaryData) throws IOException {
        sid = ancillaryData.getSensorId();
        int n = 0;
        if (ancillaryData.getCalOffset() > 0) {
            n = ancillaryData.getDataOffset() - ancillaryData.getCalOffset();
        }
        if (n == 0) {
            return;
        }
        if (sid % 2 == 0) {
            int n2 = 0;
            while (n2 < 8) {
                this.visBiasCoef[n2] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
                ++n2;
            }
            int n3 = 0;
            while (n3 < 8) {
                this.visGain1Coef[n3] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
                ++n3;
            }
            int n4 = 0;
            while (n4 < 8) {
                this.visGain2Coef[n4] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
                ++n4;
            }
            this.visRadToAlb = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
            int n5 = 0;
            while (n5 < 4) {
                this.irBiasCoef[0][(n5 + 2) % 4] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
                ++n5;
            }
            int n6 = 0;
            while (n6 < 4) {
                this.irBiasCoef[1][(n6 + 2) % 4] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
                ++n6;
            }
            int n7 = 0;
            while (n7 < 4) {
                this.irGainCoef[0][(n7 + 2) % 4] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
                ++n7;
            }
            int n8 = 0;
            while (n8 < 4) {
                this.irGainCoef[1][(n8 + 2) % 4] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
                ++n8;
            }
            int n9 = 0;
            while (n9 < 87) {
                dataInputStream.readInt();
                ++n9;
            }
            return;
        }
        int n10 = 0;
        while (n10 < 4) {
            this.visBiasCoef[n10] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
            ++n10;
        }
        int n11 = 0;
        while (n11 < 4) {
            this.visGain1Coef[n11] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
            ++n11;
        }
        int n12 = 0;
        while (n12 < 4) {
            this.visGain2Coef[n12] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
            ++n12;
        }
        this.visRadToAlb = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
        int n13 = 0;
        while (n13 < 18) {
            this.sBiasCoef[n13] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
            ++n13;
        }
        int n14 = 0;
        while (n14 < 18) {
            this.sGainCoef[n14] = (float)CalibratorGvar.GouldToNative(dataInputStream.readInt());
            ++n14;
        }
        int n15 = 0;
        while (n15 < 79) {
            dataInputStream.readInt();
            ++n15;
        }
    }

    public int setCalType(int n) {
        if (n < 1 || n > 5) {
            return -1;
        }
        curCalType = n;
        return 0;
    }

    public float[] calibrate(float[] fArray, int n, int n2) {
        float[] fArray2 = new float[fArray.length];
        int n3 = 0;
        while (n3 < fArray.length) {
            fArray2[n3] = this.calibrate(fArray[n3], n, n2);
            ++n3;
        }
        return fArray2;
    }

    public float calibrate(float f, int n, int n2) {
        float f2 = 0.0f;
        if (n != bandNum) {
            bandNum = n;
            if (sid % 2 == 0) {
                if (n == 1) {
                    gain = this.visGain1Coef[0];
                    bias = this.visBiasCoef[0];
                } else {
                    gain = this.irGainCoef[0][n - 2];
                    bias = this.irBiasCoef[0][n - 2];
                }
                scale = 32.0f;
            } else {
                gain = this.sGainCoef[n - 1];
                bias = this.sBiasCoef[n - 1];
                scale = 1.0f;
            }
        }
        switch (curCalType) {
            case 1: {
                f2 = f / scale;
                f2 = (f2 - bias) / gain;
                if (n2 == 2 || n2 != 4) break;
                break;
            }
            case 2: {
                f2 = f;
                break;
            }
            case 3: {
                f2 = f;
                break;
            }
            case 4: {
                f2 = f;
                break;
            }
            case 5: {
                f2 = f;
                break;
            }
        }
        return f2;
    }

    public static double GouldToNative(int n) {
        int n2;
        int n3 = n & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 16 & 0xFF;
        int n6 = 1;
        if ((n & Integer.MIN_VALUE) != 0) {
            n6 = -1;
            n = -n;
        }
        if ((n2 = (n & 0x7F000000) >> 24) == 0) {
            n2 = 64;
        }
        float f = n3 + n4 * 256 + n5 * 65536;
        f = Math.abs(f);
        double d = f;
        double d2 = Math.pow(16.0, 70 - n2);
        double d3 = d / d2;
        return d3 *= (double)n6;
    }

    static {
        scale = 1.0f;
    }
}

