/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class AreaFile {
    public static final int AD_STATUS = 0;
    public static final int AD_VERSION = 1;
    public static final int AD_SENSORID = 2;
    public static final int AD_IMGDATE = 3;
    public static final int AD_IMGTIME = 4;
    public static final int AD_STLINE = 5;
    public static final int AD_STELEM = 6;
    public static final int AD_NUMLINES = 8;
    public static final int AD_NUMELEMS = 9;
    public static final int AD_DATAWIDTH = 10;
    public static final int AD_LINERES = 11;
    public static final int AD_ELEMRES = 12;
    public static final int AD_NUMBANDS = 13;
    public static final int AD_PFXSIZE = 14;
    public static final int AD_PROJNUM = 15;
    public static final int AD_CRDATE = 16;
    public static final int AD_CRTIME = 17;
    public static final int AD_BANDMAP = 18;
    public static final int AD_DATAOFFSET = 33;
    public static final int AD_NAVOFFSET = 34;
    public static final int AD_VALCODE = 35;
    public static final int AD_STARTSCAN = 47;
    public static final int AD_DOCLENGTH = 48;
    public static final int AD_CALLENGTH = 49;
    public static final int AD_LEVLENGTH = 50;
    public static final int AD_SRCTYPE = 51;
    public static final int AD_CALTYPE = 52;
    public static final int AD_AVGSMPFLAG = 53;
    public static final int AD_CALOFFSET = 62;
    private boolean flipwords;
    private boolean fileok;
    private DataInputStream af;
    private int status;
    private int navLoc;
    private int calLoc;
    private int auxLoc;
    private int datLoc;
    private int navbytes;
    private int calbytes;
    private int auxbytes;
    private int linePrefixLength;
    private int lineDataLength;
    private int lineLength;
    private int numberLines;
    private final int McMISSING = -2139062144;
    private long position;
    private int skipByteCount;
    private long newPosition;
    private URL url;
    int[] dir;
    int[] nav;
    int[] cal;
    final int DMSP = 1145918032;
    final int GVAR = 1196835154;
    final int POES = 1414091343;

    public AreaFile(String string) throws AreaFileException {
        try {
            this.af = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 2048));
        }
        catch (IOException iOException) {
            this.fileok = false;
            throw new AreaFileException("Error opening AreaFile: " + iOException);
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public AreaFile(String string, Applet applet) throws AreaFileException {
        try {
            this.url = new URL(applet.getDocumentBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        try {
            this.af = new DataInputStream(this.url.openStream());
        }
        catch (IOException iOException) {
            this.fileok = false;
            throw new AreaFileException("Error opening AreaFile:" + iOException);
        }
        this.fileok = true;
        this.position = 0L;
        this.readMetaData();
    }

    public void readMetaData() throws AreaFileException {
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile directory");
        }
        this.dir = new int[64];
        int n = 0;
        while (n < 64) {
            try {
                this.dir[n] = this.af.readInt();
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error reading AreaFile directory:" + iOException);
            }
            ++n;
        }
        this.position += 256L;
        if (this.dir[1] > 255) {
            this.flip(this.dir, 0, 19);
            if ((this.dir[20] & 0xFFFF) == 0) {
                this.flip(this.dir, 20, 20);
            }
            this.flip(this.dir, 21, 23);
            this.flip(this.dir, 32, 50);
            this.flip(this.dir, 53, 55);
            this.flip(this.dir, 57, 63);
            this.flipwords = true;
        }
        this.navLoc = this.dir[34];
        this.calLoc = this.dir[62];
        this.auxLoc = this.dir[59];
        this.datLoc = this.dir[33];
        this.linePrefixLength = this.dir[48] + this.dir[49] + this.dir[50];
        if (this.dir[35] != 0) {
            this.linePrefixLength += 4;
        }
        this.lineDataLength = this.dir[13] * this.dir[9] * this.dir[10];
        this.lineLength = this.linePrefixLength + this.lineDataLength;
        this.numberLines = this.dir[8];
        if (this.datLoc > 0 && this.datLoc != -2139062144) {
            this.navbytes = this.datLoc - this.navLoc;
            this.calbytes = this.datLoc - this.calLoc;
            this.auxbytes = this.datLoc - this.auxLoc;
        }
        if (this.auxLoc > 0 && this.auxLoc != -2139062144) {
            this.navbytes = this.auxLoc - this.navLoc;
            this.calbytes = this.auxLoc - this.calLoc;
        }
        if (this.calLoc > 0 && this.calLoc != -2139062144) {
            this.navbytes = this.calLoc - this.navLoc;
        }
        if (this.navLoc > 0 && this.navbytes > 0) {
            this.nav = new int[this.navbytes / 4];
            this.newPosition = this.navLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + iOException);
            }
            n = 0;
            while (n < this.navbytes / 4) {
                try {
                    this.nav[n] = this.af.readInt();
                }
                catch (IOException iOException) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile navigation:" + iOException);
                }
                ++n;
            }
            if (this.flipwords) {
                this.flipnav(this.nav);
            }
            this.position = this.navLoc + this.navbytes;
        }
        if (this.calLoc > 0 && this.calbytes > 0) {
            this.cal = new int[this.calbytes / 4];
            this.newPosition = this.calLoc;
            this.skipByteCount = (int)(this.newPosition - this.position);
            try {
                this.af.skipBytes(this.skipByteCount);
            }
            catch (IOException iOException) {
                this.status = -1;
                throw new AreaFileException("Error skipping AreaFile bytes: " + iOException);
            }
            n = 0;
            while (n < this.calbytes / 4) {
                try {
                    this.cal[n] = this.af.readInt();
                }
                catch (IOException iOException) {
                    this.status = -1;
                    throw new AreaFileException("Error reading AreaFile calibration:" + iOException);
                }
                ++n;
            }
            this.position = this.calLoc + this.calbytes;
        }
        this.status = 1;
    }

    public int[] getDir() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile directory");
        }
        return this.dir;
    }

    public int[] getNav() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile navigation");
        }
        if (this.navLoc <= 0 || this.navLoc == -2139062144) {
            throw new AreaFileException("Error reading AreaFile navigation");
        }
        return this.nav;
    }

    public int[] getCal() throws AreaFileException {
        if (this.status <= 0) {
            throw new AreaFileException("Error reading AreaFile calibration");
        }
        if (this.navLoc <= 0 || this.navLoc == -2139062144) {
            throw new AreaFileException("Error reading AreaFile calibration");
        }
        return this.cal;
    }

    /*
     * Unable to fully structure code
     */
    public int[][] getData(int var1_1, int var2_2, int var3_3, int var4_4) throws AreaFileException {
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile data");
        }
        var7_5 = new int[var3_3][var4_4];
        var5_6 = 0;
        block4: while (var5_6 < var3_3) {
            block16: {
                if (var5_6 + var1_1 < 0) {
                    var6_7 = 0;
                    while (var6_7 < var4_4) {
                        var7_5[var5_6][var6_7] = 0;
                        ++var6_7;
                    }
                    break;
                }
                try {
                    this.newPosition = this.datLoc + (var5_6 + var1_1) * this.lineLength;
                    this.skipByteCount = (int)(this.newPosition - this.position);
                    this.af.skipBytes(this.skipByteCount);
                    break block16;
                }
                catch (IOException v0) {
                    var6_7 = 0;
                    ** while (var6_7 < var4_4)
                }
lbl-1000:
                // 1 sources

                {
                    var7_5[var5_6][var6_7] = 0;
                    ++var6_7;
                    continue;
lbl25:
                    // 1 sources

                    break block4;
                }
            }
            var6_7 = 0;
            while (var6_7 < var4_4) {
                if (var6_7 > this.lineDataLength) {
                    var7_5[var5_6][var6_7] = 0;
                } else {
                    try {
                        if (this.dir[10] == 1) {
                            var7_5[var5_6][var6_7] = this.af.readByte();
                            if (var7_5[var5_6][var6_7] < 0) {
                                v1 = var7_5[var5_6];
                                v2 = var6_7;
                                v1[v2] = v1[v2] + 256;
                            }
                            ++this.position;
                        }
                        if (this.dir[10] == 2) {
                            var7_5[var5_6][var6_7] = this.af.readShort();
                            this.position += 2L;
                        }
                        if (this.dir[10] == 4) {
                            var7_5[var5_6][var6_7] = this.af.readInt();
                            this.position += 4L;
                        }
                    }
                    catch (IOException v3) {
                        var7_5[var5_6][var6_7] = 0;
                    }
                }
                ++var6_7;
            }
            ++var5_6;
        }
        return var7_5;
    }

    /*
     * Unable to fully structure code
     */
    public byte[][] getDataBytes(int var1_1, int var2_2, int var3_3, int var4_4) throws AreaFileException {
        if (!this.fileok) {
            throw new AreaFileException("Error reading AreaFile data");
        }
        var7_5 = this.dir[10];
        if (var7_5 < 1) {
            var7_5 = 1;
        }
        var8_6 = new byte[var3_3][var4_4];
        var9_7 = new byte[var7_5 * var4_4];
        var10_8 = new DataInputStream(new ByteArrayInputStream(var9_7));
        var10_8.mark(0);
        var5_9 = 0;
        block2: while (var5_9 < var3_3) {
            block14: {
                if (var5_9 + var1_1 < 0 || var5_9 + var1_1 > this.numberLines) {
                    var6_10 = 0;
                    while (var6_10 < var4_4) {
                        var8_6[var5_9][var6_10] = 0;
                        ++var6_10;
                    }
                    break;
                }
                try {
                    this.newPosition = this.datLoc + (var5_9 + var1_1) * this.lineLength;
                    this.skipByteCount = (int)(this.newPosition - this.position);
                    this.af.skipBytes(this.skipByteCount);
                    this.position = this.newPosition + (long)var9_7.length;
                    this.af.readFully(var9_7);
                    var10_8.reset();
                    var6_10 = 0;
                    while (var6_10 < var4_4) {
                        if (var6_10 > this.lineDataLength) {
                            var8_6[var5_9][var6_10] = 0;
                        } else {
                            if (var7_5 == 1) {
                                var8_6[var5_9][var6_10] = var9_7[var6_10];
                            }
                            if (var7_5 == 2) {
                                var8_6[var5_9][var6_10] = (byte)var10_8.readShort();
                            }
                            if (var7_5 == 4) {
                                var8_6[var5_9][var6_10] = (byte)var10_8.readInt();
                            }
                        }
                        ++var6_10;
                    }
                    break block14;
                }
                catch (IOException v0) {
                    var6_10 = 0;
                    ** while (var6_10 < var4_4)
                }
lbl-1000:
                // 1 sources

                {
                    var8_6[var5_9][var6_10] = 0;
                    ++var6_10;
                    continue;
lbl47:
                    // 1 sources

                    break block2;
                }
            }
            ++var5_9;
        }
        return var8_6;
    }

    private void flip(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            int n4 = nArray[n3];
            nArray[n3] = n4 >>> 24 & 0xFF | n4 >>> 8 & 0xFF00 | (n4 & 0xFF) << 24 | (n4 & 0xFF00) << 8;
            ++n3;
        }
    }

    private void flipnav(int[] nArray) {
        if (nArray[0] == 1196835154) {
            this.flip(nArray, 2, 126);
            this.flip(nArray, 129, 254);
            this.flip(nArray, 257, 382);
            this.flip(nArray, 385, 510);
            this.flip(nArray, 513, 638);
            return;
        }
        if (nArray[0] == 1145918032) {
            this.flip(nArray, 1, 43);
            this.flip(nArray, 45, 51);
            return;
        }
        if (nArray[0] == 1414091343) {
            this.flip(nArray, 1, 119);
            return;
        }
        this.flip(nArray, 1, nArray.length - 1);
    }
}

