#ifndef MESA_WGL_H
#define MESA_WGL_H

#ifndef GL_H
#	include <GL/gl.h>
#endif

WINGDIAPI BOOL WINAPI
wglCopyContext(HGLRC hglrcSrc,HGLRC hglrcDst,UINT mask);

WINGDIAPI HGLRC WINAPI
wglCreateContext(HDC hdc);

WINGDIAPI BOOL WINAPI
wglDeleteContext(HGLRC hglrc);

WINGDIAPI HGLRC WINAPI
wglCreateLayerContext(HDC hdc,int iLayerPlane);

WINGDIAPI HGLRC WINAPI
wglGetCurrentContext(VOID);

WINGDIAPI HDC WINAPI
wglGetCurrentDC(VOID);

WINGDIAPI BOOL WINAPI
wglMakeCurrent(HDC hdc,HGLRC hglrc);

WINGDIAPI BOOL WINAPI
wglShareLists(HGLRC hglrc1,HGLRC hglrc2);

WINGDIAPI BOOL WINAPI
wglUseFontBitmapsA(HDC hdc,DWORD first,DWORD count,DWORD listBase);

WINGDIAPI BOOL WINAPI
wglUseFontBitmapsW(HDC hdc,DWORD first,DWORD count,DWORD listBase);

WINGDIAPI BOOL WINAPI
wglUseFontOutlinesA(HDC hdc,DWORD first,DWORD count,
					DWORD listBase,FLOAT deviation,
					FLOAT extrusion,int format,
					LPGLYPHMETRICSFLOAT lpgmf);

WINGDIAPI BOOL WINAPI
wglUseFontOutlinesW(HDC hdc,DWORD first,DWORD count,
					DWORD listBase,FLOAT deviation,
					FLOAT extrusion,int format,
					LPGLYPHMETRICSFLOAT lpgmf);

WINGDIAPI BOOL WINAPI
wglDescribeLayerPlane(HDC hdc,int iPixelFormat,
					  int iLayerPlane,UINT nBytes,
					  LPLAYERPLANEDESCRIPTOR plpd);

WINGDIAPI int WINAPI
wglSetLayerPaletteEntries(HDC hdc,int iLayerPlane,
						  int iStart,int cEntries,
						  CONST COLORREF *pcr);

WINGDIAPI int WINAPI
wglGetLayerPaletteEntries(HDC hdc,int iLayerPlane,
						  int iStart,int cEntries,
						  COLORREF *pcr);

WINGDIAPI BOOL WINAPI
wglRealizeLayerPalette(HDC hdc,int iLayerPlane,BOOL bRealize);

WINGDIAPI BOOL WINAPI
wglSwapLayerBuffers(HDC hdc,UINT fuPlanes);

WINGDIAPI int WINAPI
wglChoosePixelFormat(HDC hdc,
					 CONST PIXELFORMATDESCRIPTOR *ppfd);

WINGDIAPI int WINAPI
wglDescribePixelFormat(HDC hdc,int iPixelFormat,UINT nBytes,
					   LPPIXELFORMATDESCRIPTOR ppfd);

WINGDIAPI PROC WINAPI
wglGetProcAddress(LPCSTR lpszProc);

WINGDIAPI int WINAPI
wglGetPixelFormat(HDC hdc);

WINGDIAPI BOOL WINAPI
wglSetPixelFormat(HDC hdc,int iPixelFormat,
				  PIXELFORMATDESCRIPTOR *ppfd);

WINGDIAPI BOOL WINAPI
wglSwapBuffers(HDC hdc);

#endif /* MESA_WGL_H */
