/* vi:set ts=8 sts=8 sw=8:
 *
 * VIM - Vi IMproved	by Bram Moolenaar
 *			Visual Workshop integration by Gordon Prieur
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */


#ifndef NBDEBUG_H
#define NBDEBUG_H

#ifdef NBDEBUG

#ifndef ASSERT
#define ASSERT(c) \
    if (!(c)) { \
	fprintf(stderr, "Assertion failed: line %d, file %s\n", \
		__LINE__, __FILE__); \
	fflush(stderr); \
	abort(); \
    }
#endif

#define nbdebug(a) nbdbg##a

#define NB_TRACE		0x00000001
#define NB_TRACE_VERBOSE	0x00000002
#define NB_TRACE_COLONCMD	0x00000004
#define NB_DEBUG_ALL		0xffffffff

#define NBDLEVEL(flags)		(nb_debug != NULL && (nb_dlevel & (flags)))

#define NBDEBUG_TRACE	1
//#define NBDEBUG_SENSE	2

typedef enum {
		WT_ENV = 1,		/* look for env var if set */
		WT_WAIT,		/* look for ~/.gvimwait if set */
		WT_STOP			/* look for ~/.gvimstop if set */
} WtWait;


void		 nbdbg(char *, ...);
void		 nbtrace(char *, ...);

void nbdebug_wait __ARGS((u_int wait_flags, char *wait_var, u_int wait_secs));
void nbdebug_log_init __ARGS((char *log_var, char *level_var));

extern FILE	*nb_debug;
extern u_int	 nb_dlevel;		/* nb_debug verbosity level */

# else		/* not NBDEBUG */

#ifndef ASSERT
# define ASSERT(c)
#endif

/*
 * The following 2 stubs are needed because a macro cannot be used because of
 * the variable number of arguments.
 */

void
nbdbg(
	char		*fmt,
	...)
{
}


void
nbtrace(
	char		*fmt,
	...)
{
}

#endif /* NBDEBUG */
#endif /* NBDEBUG_H */
