" Vim syntax file
" Language:	Fvwm{1,2} configuration file
" Maintainer:	Haakon Riiser <hakonrk@fys.uio.no>
" Last change:	1998 Nov 6

" Bugs:
"   Given that I have no decent reference for the syntax of the
"   configuration files, I'd say a lot.

" Clear old syntax defs
syn clear

" Fvwm configuration files are case insensitive
syn case ignore

set iskeyword=_,-,+,a-z,A-Z,48-57

" Read system colors from the color database (rgb.txt)
if exists("rgb_file")
    " We don't want any hit-return prompts, so we make sure that
    " &shortmess is set to `O'
    let __fvwm_oldshm = &shortmess
    set shortmess=O

    " And we set &report to a huge number, so that no hit-return prompts
    " will be given
    let __fvwm_oldreport = &report
    set report=10000

    " Append the color database to the fvwm configuration, and read the
    " colors from this buffer
    let __fvwm_i = line("$") + 1
    exe "$r" rgb_file
    let __fvwm_lastline = line("$")
    while __fvwm_i <= __fvwm_lastline
	let __fvwm_s = matchstr(getline(__fvwm_i), '^\s*\d\+\s\+\d\+\s\+\d\+\s\+\h.*$')
	if __fvwm_s != ""
	    exe "syn keyword fvwmColors ".substitute(__fvwm_s, '^\s*\d\+\s\+\d\+\s\+\d\+\s\+\(\h.*\)$', '\1', "")
	endif
	let __fvwm_i = __fvwm_i + 1
    endwhile

    " Remove the appended data
    undo

    " Goto first line again
    1

    " and restore the old values of the variables
    let &shortmess = __fvwm_oldshm
    let &report = __fvwm_oldreport
    unlet __fvwm_i __fvwm_s __fvwm_lastline __fvwm_oldshm __fvwm_oldreport
endif
" done reading colors

syn match fvwmArguments	    "\w\s\+\w\+\s\+\w\+\s\+\w\+"ms=s+1 contained
syn match fvwmComment	    "^#.*$"
syn match fvwmDimension	    "\<\d\+\(x\d\+\)\=\>"
syn match fvwmEnvVar	    "\${\=\w\+}\="
syn match fvwmKeyDef	    "^\s*Key\s\+\w\+\s\+\w\+\s\+\w\+" contains=fvwmArguments
syn match fvwmModule	    "^\*\w\+"
syn match fvwmMouseDef	    "^\s*Mouse\s\+\w\+\s\+\w\+\s\+\w\+" contains=fvwmArguments
syn match fvwmNumber	    "\(+\|-\)\d\+\(+\|-\)\d\+\>"
syn match fvwmNumber	    "\<\(+\|-\)\d\+\>"
syn match fvwmNumber	    "\<\d\+\>"
syn match fvwmPath	    "Path\s.*"lc=4 contains=fvwmEnvVar
syn match fvwmRGBValue	    "#\x\{3}"
syn match fvwmRGBValue	    "#\x\{6}"
syn match fvwmRGBValue	    "#\x\{9}"
syn match fvwmRGBValue	    "#\x\{12}"
syn match fvwmRGBValue	    "rgb:\x\{1,4}/\x\{1,4}/\x\{1,4}"
syn match fvwmShortcutKey   "&."hs=s+1 contained
syn match fvwmSpecial	    "[,!@/]"
syn match fvwmDelimiter	    "[\[\]()]"
syn match fvwmString	    "'.\{-}'" contains=fvwmExec
syn match fvwmString	    "`.\{-}`" contains=fvwmExec
syn match fvwmString	    '".\{-}"' contains=fvwmExec

if bufname("%") =~ ".*fvwmrc.*"
    " Fvwm1 functions
    syn keyword fvwmFunctions	CirculateDown CirculateUp EndFunction
    syn keyword fvwmFunctions	EndPopup TogglePage Warp

    " Fvwm1 commands
    syn keyword fvwmKeywords	AppsBackingStore AutoRaise BackingStore
    syn keyword fvwmKeywords	BoundaryWidth CenterOnCirculate
    syn keyword fvwmKeywords	CirculateSkipIcons Cursor
    syn keyword fvwmKeywords	DecorateTransients DeskTopScale
    syn keyword fvwmKeywords	DontMoveOff Font HiBackColor
    syn keyword fvwmKeywords	HiForeColor MenuBackColor MenuForeColor
    syn keyword fvwmKeywords	MWMFunctionHints MWMHintOverride
    syn keyword fvwmKeywords	MWMMenus NoBoundaryWidth OpaqueMove
    syn keyword fvwmKeywords	MenuStippleColor MWMBorders MWMDecorHints
    syn keyword fvwmKeywords	OpaqueResize Pager PagerBackColor
    syn keyword fvwmKeywords	PagerFont PagerForeColor PagingDefault
    syn keyword fvwmKeywords	SaveUnders StdBackColor StdForeColor
    syn keyword fvwmKeywords	StickyBackColor StickyForeColor
    syn keyword fvwmKeywords	StickyIcons StubbornIconPlacement
    syn keyword fvwmKeywords	StubbornIcons StubbornPlacement
    syn keyword fvwmKeywords	SuppressIcons
elseif bufname("%") =~ ".*fvwm2rc.*"
    syn match fvwmMenuIcon	"%.\{-}%" contained
    syn match fvwmMenuIcon	"\*.\{-}\*" contained

    " Fvwm2 functions
    syn keyword fvwmFunctions	Current Destroy DestroyDecor DestroyFunc
    syn keyword fvwmFunctions	DestroyMenu DestroyModuleConfig Echo
    syn keyword fvwmFunctions	FlipFocus KillModule Menu Next None
    syn keyword fvwmFunctions	PipeRead Prev Read Recapture RefreshWindow
    syn keyword fvwmFunctions	SendToModule

    " Fvwm2 keywords
    syn keyword fvwmKeywords	Active ActiveDown ActivePlacement ActiveUp
    syn keyword fvwmKeywords	AddButtonStyle AddTitleStyle AddToDecor
    syn keyword fvwmKeywords	AddToFunc All BackColor
    syn keyword fvwmKeywords	BorderStyle Bottom Centered ChangeDecor
    syn keyword fvwmKeywords	CirculateSkipIcon ColormapFocus
    syn keyword fvwmKeywords	CursorStyle DecorateTransient
    syn keyword fvwmKeywords	Default DumbPlacement ExecUseShell
    syn keyword fvwmKeywords	Flat FocusFollowsMouse FollowsFocus
    syn keyword fvwmKeywords	FollowsMouse ForeColor FvwmBorder
    syn keyword fvwmKeywords	GlobalOpts Height HGradient HiddenHandles
    syn keyword fvwmKeywords	HilightColor HintOverride Inactive
    syn keyword fvwmKeywords	Left LeftJustified MenuStyle MiniIcon
    syn keyword fvwmKeywords	MouseFocus MWMBorder MWMButtons
    syn keyword fvwmKeywords	MWMDecor MWMDecorMax MWMDecorMenu
    syn keyword fvwmKeywords	MWMDecorMin MWMFunctions NakedTransient
    syn keyword fvwmKeywords	NoDecorHint NoFuncHint NoIcon NoInsets
    syn keyword fvwmKeywords	NoLenience NoOLDecor NoOverride
    syn keyword fvwmKeywords	OLDecor OpaqueMoveSize Raised Reset
    syn keyword fvwmKeywords	Right RightJustified ShowMapping Simple
    syn keyword fvwmKeywords	SkipMapping Slippery SlipperyIcon Solid
    syn keyword fvwmKeywords	StickyIcon Sunk TiledPixmap TitleStyle
    syn keyword fvwmKeywords	Top UpdateDecor UseBorderStyle UseDecor
    syn keyword fvwmKeywords	UsePPosition UseStyle UseTitleStyle Vector
    syn keyword fvwmKeywords	VGradient Width WindowId WindowListHit

    syn match   fvwmMenuString	'".\{-}"' contains=fvwmExec,fvwmShortcutKey,fvwmMenuIcon contained
    syn region  fvwmMenu	matchgroup=fvwmKeywords start="^\s*AddToMenu\>" end="^\s*[^#+]"me=e-1 end="^$" contains=ALLBUT,fvwmMenu,fvwmString
endif

" Functions common in Fvwm{1,2}
syn keyword fvwmCommonFuncs	Beep Close CursorMove Delete Desk Destroy
syn keyword fvwmCommonFuncs	Focus Function GotoPage Iconify Lower
syn keyword fvwmCommonFuncs	Maximize Module Move Nop Popup Quit Raise
syn keyword fvwmCommonFuncs	RaiseLower Refresh Resize Restart Scroll
syn keyword fvwmCommonFuncs	Stick Title Wait WindowList WindowsDesk
syn keyword fvwmCommonFuncs	WindowShade

" Keywords common in Fvwm{1,2}
syn keyword fvwmCommonKeywords	BorderWidth Button ButtonStyle
syn keyword fvwmCommonKeywords	CirculateHit CirculateSkip ClickTime
syn keyword fvwmCommonKeywords	ClickToFocus Color DeskTopSize
syn keyword fvwmCommonKeywords	EdgeResistance EdgeScroll Handles
syn keyword fvwmCommonKeywords	HandleWidth Icon IconBox IconFont Font
syn keyword fvwmCommonKeywords	IconPath IconTitle Lenience ModulePath
syn keyword fvwmCommonKeywords	MWMButtons NoBorder NoButton NoHandles
syn keyword fvwmCommonKeywords	NoIconTitle NoPPosition NoTitle PixmapPath
syn keyword fvwmCommonKeywords	RandomPlacement SloppyFocus SmartPlacement
syn keyword fvwmCommonKeywords	StartIconic StartNormal StartsAnyWhere
syn keyword fvwmCommonKeywords	StartsOnDesk StaysOnTop StaysPut Sticky
syn keyword fvwmCommonKeywords	Style WindowFont WindowListSkip XORvalue

syn keyword fvwmExec		Exec

if !exists("did_fvwm_syntax_inits")
    let did_fvwm_syntax_inits = 1
    hi link fvwmArguments	Constant
    hi link fvwmComment		Comment
    hi link fvwmCommonFuncs	Function
    hi link fvwmCommonKeywords	Statement
    hi link fvwmDelimiter	Delimiter
    hi link fvwmDimension	Number
    hi link fvwmEnvVar		Macro
    hi link fvwmExec		Function
    hi link fvwmFunctions	Function
    hi link fvwmKeyDef		Statement
    hi link fvwmKeywords	Keyword
    hi link fvwmMenu		NONE
    hi link fvwmMenuIcon	Comment
    hi link fvwmMenuString	String
    hi link fvwmModule		Macro
    hi link fvwmMouseDef	Statement
    hi link fvwmNumber		Number
    hi link fvwmPath		String
    hi link fvwmRGBValue	Type
    hi link fvwmShortcutKey	SpecialChar
    hi link fvwmSpecial		Special
    hi link fvwmString		String

    if exists("rgb_file")
	hi link fvwmColors	Type
    endif
endif

let b:current_syntax = "fvwm"
" vim: sts=4 sw=4 ts=8
