" Vim syntax file
" Language:	Vim 5.4h script
" Maintainer:	Dr. Charles E. Campbell, Jr. <cec@gryphon.gsfc.nasa.gov>
" Last Change:	April 28, 1999
" Version:	5.4h-03

" Remove old syntax
syn clear

syn keyword vimTodo contained	COMBAK	NOT	RELEASED	TODO

" regular vim commands
syn keyword vimCommand contained	N[ext]	com[mand]	inorea[bbrev]	pc[lose]	sta[g]
syn keyword vimCommand contained	P[rint]	comc[lear]	inoreme	pe[rl]	start[insert]
syn keyword vimCommand contained	X	con[tinue]	inoremenu	perld[o]	stj[ump]
syn keyword vimCommand contained	a[ppend]	conf[irm]	is[earch]	po[p]	sts[elect]
syn keyword vimCommand contained	ab[breviate]	cp[revious]	isp[lit]	pp[op]	sun[hide]
syn keyword vimCommand contained	abc[lear]	cq[uit]	iu[nmap]	pre[serve]	sus[pend]
syn keyword vimCommand contained	al[l]	cr[ewind]	iuna[bbrev]	prev[ious]	sv[iew]
syn keyword vimCommand contained	am	cu[nmap]	iunme	promptf[ind]	sy[ntax]
syn keyword vimCommand contained	amenu	cuna[bbrev]	iunmenu	promptr[epl]	syncbind
syn keyword vimCommand contained	an	cunme	j[oin]	ptN[ext]	syntax
syn keyword vimCommand contained	anoremenu	cunmenu	ju[mps]	pta[g]	t
syn keyword vimCommand contained	ar[gs]	d[elete]	k	ptj[ump]	tN[ext]
syn keyword vimCommand contained	argu[ment]	delc[ommand]	l[ist]	ptl[ast]	ta[g]
syn keyword vimCommand contained	as[cii]	delf[unction]	la[st]	ptn[ext]	tags
syn keyword vimCommand contained	au[tocmd]	di[splay]	le[ft]	ptp[revious]	tc[l]
syn keyword vimCommand contained	aug[roup]	dig[raphs]	let	ptr[ewind]	tcld[o]
syn keyword vimCommand contained	aun	display	ls	pts[elect]	tclf[ile]
syn keyword vimCommand contained	aunmenu	dj[ump]	m[ove]	pu[t]	te[aroff]
syn keyword vimCommand contained	autocmd	dl[ist]	ma[rk]	pw[d]	tj[ump]
syn keyword vimCommand contained	bN[ext]	do[autocmd]	mak[e]	py[thon]	tl[ast]
syn keyword vimCommand contained	b[uffer]	doautoa[ll]	map	pyf[ile]	tm[enu]
syn keyword vimCommand contained	ba[ll]	ds[earch]	mapc[lear]	q[uit]	tn[ext]
syn keyword vimCommand contained	bad[d]	dsp[lit]	marks	qa[ll]	tp[revious]
syn keyword vimCommand contained	bd[elete]	e[dit]	me	r[ead]	tr[ewind]
syn keyword vimCommand contained	be[have]	ec[ho]	menu	rec[over]	ts[elect]
syn keyword vimCommand contained	bl[ast]	echoh[l]	mk[exrc]	red[o]	tu[nmenu]
syn keyword vimCommand contained	bm[odified]	echon	mks[ession]	redi[r]	u[ndo]
syn keyword vimCommand contained	bn[ext]	el[se]	mkv[imrc]	reg[isters]	una[bbreviate]
syn keyword vimCommand contained	bp[revious]	elsei[f]	mod[e]	res[ize]	unh[ide]
syn keyword vimCommand contained	br[ewind]	eme	n[ext]	ret[ab]	unl[et]
syn keyword vimCommand contained	brea[k]	emenu	new	retu[rn]	unm[ap]
syn keyword vimCommand contained	bro[wse]	en[dif]	nm[ap]	rew[ind]	unme
syn keyword vimCommand contained	buffers	endf[unction]	nmapc[lear]	ri[ght]	unmenu
syn keyword vimCommand contained	bun[load]	endw[hile]	nme	rv[iminfo]	v[global]
syn keyword vimCommand contained	cN[ext]	ex	nmenu	sN[ext]	ve[rsion]
syn keyword vimCommand contained	c[hange]	exe[cute]	nn[oremap]	s[ubstitute]	vi[sual]
syn keyword vimCommand contained	ca[bbrev]	exi[t]	nnoreme	sa[rgument]	vie[w]
syn keyword vimCommand contained	cabc[lear]	f[ile]	nnoremenu	sal[l]	vm[ap]
syn keyword vimCommand contained	cal[l]	files	no[remap]	sbN[ext]	vmapc[lear]
syn keyword vimCommand contained	cc	fin[d]	noh[lsearch]	sb[uffer]	vme
syn keyword vimCommand contained	cd	fix[del]	norea[bbrev]	sba[ll]	vmenu
syn keyword vimCommand contained	ce[nter]	fu[nction]	noreme	sbl[ast]	vn[oremap]
syn keyword vimCommand contained	cf[ile]	g[lobal]	noremenu	sbm[odified]	vnoreme
syn keyword vimCommand contained	chd[ir]	go[to]	norm[al]	sbn[ext]	vnoremenu
syn keyword vimCommand contained	che[ckpath]	gr[ep]	nu[mber]	sbp[revious]	vu[nmap]
syn keyword vimCommand contained	cl[ist]	h[elp]	nun[map]	sbr[ewind]	vunme
syn keyword vimCommand contained	cla[st]	helpf[ind]	nunme	se[t]	vunmenu
syn keyword vimCommand contained	clo[se]	hi[ghlight]	nunmenu	sf[ind]	wN[ext]
syn keyword vimCommand contained	cm[ap]	hid[e]	o[pen]	sh[ell]	w[rite]
syn keyword vimCommand contained	cmapc[lear]	his[tory]	om[ap]	si[malt]	wa[ll]
syn keyword vimCommand contained	cme	i[nsert]	omapc[lear]	sl[eep]	wh[ile]
syn keyword vimCommand contained	cmenu	ia[bbrev]	ome	sla[st]	winp[os]
syn keyword vimCommand contained	cn[ext]	iabc[lear]	omenu	sm[agic]	wn[ext]
syn keyword vimCommand contained	cnew[er]	if	on[ly]	sn[ext]	wp[revous]
syn keyword vimCommand contained	cnf[ile]	ij[ump]	ono[remap]	sno[magic]	wq
syn keyword vimCommand contained	cno[remap]	il[ist]	onoreme	so[urce]	wqa[ll]
syn keyword vimCommand contained	cnorea[bbrev]	im[ap]	onoremenu	sp[lit]	wv[iminfo]
syn keyword vimCommand contained	cnoreme	imapc[lear]	ou[nmap]	spr[evious]	x[it]
syn keyword vimCommand contained	cnoremenu	ime	ounme	sr[ewind]	xa[ll]
syn keyword vimCommand contained	co[py]	imenu	ounmenu	st[op]	y[ank]
syn keyword vimCommand contained	col[der]	ino[remap]	p[rint]
syn match   vimCommand contained	"z[-+^.=]"

" All vimCommands are contained by vimIsCommands.
syn match vimIsCommand	"^\s*[a-zA-Z]\+"		transparent contains=vimCommand
syn match vimIsCommand	"[:|]\s*[a-zA-Z]\+"	transparent contains=vimCommand

" vimOptions are caught only when contained in a vimSet
syn keyword vimOption contained	ai	errorbells	laststatus	scroll	tbs
syn keyword vimOption contained	akm	errorfile	lazyredraw	scrollbind	term
syn keyword vimOption contained	al	errorformat	lbr	scrolljump	terse
syn keyword vimOption contained	aleph	esckeys	lcs	scrolloff	textauto
syn keyword vimOption contained	allowrevins	et	linebreak	scrollopt	textmode
syn keyword vimOption contained	altkeymap	eventignore	lines	scs	textwidth
syn keyword vimOption contained	ari	ex	lisp	sect	tf
syn keyword vimOption contained	autoindent	expandtab	list	sections	tildeop
syn keyword vimOption contained	autowrite	exrc	listchars	secure	timeout
syn keyword vimOption contained	aw	fe	lmap	sel	timeoutlen
syn keyword vimOption contained	background	ff	ls	selection	title
syn keyword vimOption contained	backspace	ffs	lz	selectmode	titlelen
syn keyword vimOption contained	backup	fileencoding	magic	sessionoptions	titleold
syn keyword vimOption contained	backupdir	fileformat	makeef	sft	titlestring
syn keyword vimOption contained	backupext	fileformats	makeprg	sh	tl
syn keyword vimOption contained	bdir	filetype	mat	shcf	tm
syn keyword vimOption contained	bex	fk	matchpairs	shell	to
syn keyword vimOption contained	bg	fkmap	matchtime	shellcmdflag	toolbar
syn keyword vimOption contained	bin	fo	maxfuncdepth	shellpipe	top
syn keyword vimOption contained	binary	formatoptions	maxmapdepth	shellquote	tr
syn keyword vimOption contained	biosk	formatprg	maxmem	shellredir	ts
syn keyword vimOption contained	bioskey	fp	maxmemtot	shelltype	tsl
syn keyword vimOption contained	bk	ft	mef	shellxquote	ttimeout
syn keyword vimOption contained	breakat	gcr	mfd	shiftround	ttimeoutlen
syn keyword vimOption contained	brk	gd	mh	shiftwidth	ttm
syn keyword vimOption contained	browsedir	gdefault	ml	shm	ttybuiltin
syn keyword vimOption contained	bs	gfm	mls	shortmess	ttyfast
syn keyword vimOption contained	bsdir	gfn	mm	shortname	ttym
syn keyword vimOption contained	cf	go	mmd	showbreak	ttymouse
syn keyword vimOption contained	ch	gp	mmt	showcmd	ttyscroll
syn keyword vimOption contained	cin	grepformat	mod	showfulltag	ttytype
syn keyword vimOption contained	cindent	grepprg	modeline	showmatch	tw
syn keyword vimOption contained	cink	guicursor	modelines	showmode	tx
syn keyword vimOption contained	cinkeys	guifont	modified	shq	uc
syn keyword vimOption contained	cino	guioptions	more	si	ucb
syn keyword vimOption contained	cinoptions	guipty	mouse	sidescroll	ul
syn keyword vimOption contained	cinw	helpfile	mousef	sj	undolevels
syn keyword vimOption contained	cinwords	helpheight	mousefocus	slm	updatecount
syn keyword vimOption contained	cmdheight	hf	mousehide	sm	updatetime
syn keyword vimOption contained	co	hh	mousem	smartcase	useclipboard
syn keyword vimOption contained	columns	hi	mousemodel	smartindent	ut
syn keyword vimOption contained	com	hid	mouset	smarttab	vb
syn keyword vimOption contained	comments	hidden	mousetime	smd	vbs
syn keyword vimOption contained	compatible	highlight	mp	sn	verbose
syn keyword vimOption contained	complete	history	mps	so	vi
syn keyword vimOption contained	confirm	hk	nf	softtabstop	viminfo
syn keyword vimOption contained	consk	hkmap	nrformats	sol	visualbell
syn keyword vimOption contained	conskey	hkmapp	nu	sp	wa
syn keyword vimOption contained	cp	hkp	number	splitbelow	wak
syn keyword vimOption contained	cpo	hl	oft	sr	warn
syn keyword vimOption contained	cpoptions	hls	osfiletype	srr	wb
syn keyword vimOption contained	cpt	hlsearch	pa	ss	wc
syn keyword vimOption contained	cscopeprg	ic	para	ssop	wcm
syn keyword vimOption contained	cscopetag	icon	paragraphs	st	wd
syn keyword vimOption contained	cscopetagorder	iconstring	paste	sta	weirdinvert
syn keyword vimOption contained	cscopeverbose	ignorecase	patchmode	startofline	wh
syn keyword vimOption contained	csprg	im	path	statusline	whichwrap
syn keyword vimOption contained	cst	inc	pm	stl	wig
syn keyword vimOption contained	csto	include	previewheight	sts	wildchar
syn keyword vimOption contained	csverb	incsearch	pvh	su	wildcharm
syn keyword vimOption contained	def	inf	readonly	suffixes	wildignore
syn keyword vimOption contained	define	infercase	remap	sw	wildmenu
syn keyword vimOption contained	dg	insertmode	report	swapfile	wildmode
syn keyword vimOption contained	dict	is	restorescreen	swapsync	wim
syn keyword vimOption contained	dictionary	isf	revins	swb	winaltkeys
syn keyword vimOption contained	digraph	isfname	ri	swf	winheight
syn keyword vimOption contained	dir	isi	rightleft	switchbuf	winminheight
syn keyword vimOption contained	directory	isident	rl	sws	wiv
syn keyword vimOption contained	ea	isk	ro	sxq	wm
syn keyword vimOption contained	eb	iskeyword	rs	syn	wmh
syn keyword vimOption contained	ed	isp	ru	syntax	wmnu
syn keyword vimOption contained	edcompatible	isprint	ruf	ta	wrap
syn keyword vimOption contained	ef	joinspaces	ruler	tabstop	wrapmargin
syn keyword vimOption contained	efm	js	rulerformat	tag	wrapscan
syn keyword vimOption contained	ei	key	sb	tagbsearch	write
syn keyword vimOption contained	ek	keymodel	sbo	taglength	writeany
syn keyword vimOption contained	endofline	keywordprg	sbr	tagrelative	writebackup
syn keyword vimOption contained	eol	km	sc	tags	writedelay
syn keyword vimOption contained	ep	kp	scb	tb	ws
syn keyword vimOption contained	equalalways	langmap	scr	tbi	ww
syn keyword vimOption contained	equalprg

" These are the turn-off setting variants
syn keyword vimOption contained	noai	noedcompatible	noinsertmode	nors	notbs
syn keyword vimOption contained	noakm	noek	nois	noru	noterse
syn keyword vimOption contained	noalkeymap	noendofline	nojoinspaces	noruler	notextauto
syn keyword vimOption contained	noallowrevins	noeol	nojs	nosb	notextmode
syn keyword vimOption contained	noari	noequalalways	nolazyredraw	nosc	notf
syn keyword vimOption contained	noautoindent	noerrorbells	nolbr	noscs	notildeop
syn keyword vimOption contained	noautowrite	noesckeys	nolinebreak	nosecure	notimeout
syn keyword vimOption contained	noaw	noet	nolisp	noshiftround	notitle
syn keyword vimOption contained	nobackup	noex	nolist	noshortname	noto
syn keyword vimOption contained	nobin	noexpandtab	nolz	noshowcmd	notop
syn keyword vimOption contained	nobinary	noexrc	nomagic	noshowmatch	notr
syn keyword vimOption contained	nobiosk	nofk	nomh	noshowmode	nottimeout
syn keyword vimOption contained	nobioskey	nofkmap	noml	nosi	nottybuiltin
syn keyword vimOption contained	nobk	nogd	nomod	nosm	nottyfast
syn keyword vimOption contained	nocf	nogdefault	nomodeline	nosmartcase	notx
syn keyword vimOption contained	nocin	noguipty	nomodified	nosmartindent	noucb
syn keyword vimOption contained	nocindent	nohid	nomore	nosmarttab	nouseclipboard
syn keyword vimOption contained	nocompatible	nohidden	nomousef	nosmd	novb
syn keyword vimOption contained	noconfirm	nohk	nomousefocus	nosn	novisualbell
syn keyword vimOption contained	noconsk	nohkmap	nomousehide	nosol	nowa
syn keyword vimOption contained	noconskey	nohkmapp	nonu	nosplitbelow	nowarn
syn keyword vimOption contained	nocp	nohkp	nonumber	nosr	nowb
syn keyword vimOption contained	nocscopetag	nohls	nopaste	nosta	noweirdinvert
syn keyword vimOption contained	nocscopeverbose	nohlsearch	noreadonly	nostartofline	nowiv
syn keyword vimOption contained	nocst	noic	noremap	noswapfile	nowrap
syn keyword vimOption contained	nocsverb	noicon	norestorescreen	noswf	nowrapscan
syn keyword vimOption contained	nodg	noignorecase	norevins	nota	nowrite
syn keyword vimOption contained	nodigraph	noim	nori	notagbsearch	nowriteany
syn keyword vimOption contained	noea	noincsearch	norightleft	notagrelative	nowritebackup
syn keyword vimOption contained	noeb	noinf	norl	notbi	nows
syn keyword vimOption contained	noed	noinfercase	noro

" termcap codes (which can also be set)
syn keyword vimOption contained	t_AB	t_K4	t_ce	t_k6	t_kl	t_se
syn keyword vimOption contained	t_AF	t_K5	t_cl	t_k7	t_kr	t_so
syn keyword vimOption contained	t_AL	t_RI	t_cm	t_k8	t_ks	t_sr
syn keyword vimOption contained	t_CS	t_Sb	t_cs	t_k9	t_ku	t_te
syn keyword vimOption contained	t_Co	t_Sf	t_da	t_kD	t_le	t_ti
syn keyword vimOption contained	t_DL	t_TE	t_db	t_kI	t_mb	t_ue
syn keyword vimOption contained	t_F1	t_TS	t_dl	t_kN	t_md	t_us
syn keyword vimOption contained	t_F2	t_ZH	t_k1	t_kP	t_me	t_vb
syn keyword vimOption contained	t_IE	t_ZR	t_k2	t_kb	t_mr	t_ve
syn keyword vimOption contained	t_IS	t_al	t_k3	t_kd	t_ms	t_vi
syn keyword vimOption contained	t_K1	t_bc	t_k4	t_ke	t_nd	t_vs
syn keyword vimOption contained	t_K3	t_cd	t_k5	t_kh	t_op	t_xs
syn match   vimOption contained	"t_#4"
syn match   vimOption contained	"t_%1"
syn match   vimOption contained	"t_%i"
syn match   vimOption contained	"t_&8"
syn match   vimOption contained	"t_@7"
syn match   vimOption contained	"t_k;"

" these settings don't actually cause errors in vim, but were supported by vi and don't do anything in vim
syn keyword vimErrSetting contained	hardtabs	w1200	w9600	wi	window
syn keyword vimErrSetting contained	ht	w300

" AutoBuf Events
syn keyword vimAutoEvent contained	BufCreate	BufReadPost	FileAppendPre	FilterReadPre	TermChanged
syn keyword vimAutoEvent contained	BufDelete	BufReadPre	FileChangedShell	FilterWritePost	User
syn keyword vimAutoEvent contained	BufEnter	BufUnload	FileReadPost	FilterWritePre	VimEnter
syn keyword vimAutoEvent contained	BufFilePost	BufWrite	FileReadPre	FocusGained	VimLeave
syn keyword vimAutoEvent contained	BufFilePre	BufWritePost	FileType	FocusLost	VimLeavePre
syn keyword vimAutoEvent contained	BufLeave	BufWritePre	FileWritePost	StdinReadPost	WinEnter
syn keyword vimAutoEvent contained	BufNewFile	CursorHold	FileWritePre	StdinReadPre	WinLeave
syn keyword vimAutoEvent contained	BufRead	FileAppendPost	FilterReadPost	Syntax

" Highlight commonly used Groupnames
syn keyword vimGroup	Comment	Identifier	Keyword	Type	Delimiter
syn keyword vimGroup	Constant	Function	Exception	StorageClass	SpecialComment
syn keyword vimGroup	String	Statement	PreProc	Structure	Debug
syn keyword vimGroup	Character	Conditional	Include	Typedef	Ignore
syn keyword vimGroup	Number	Repeat	Define	Special	Error
syn keyword vimGroup	Boolean	Label	Macro	SpecialChar	Todo
syn keyword vimGroup	Float	Operator	PreCondit	Tag

" Default highlighting groups
syn keyword vimHLGroup	Cursor	Menu	Normal	SpecialKey	Visual
syn keyword vimHLGroup	Directory	ModeMsg	Question	StatusLine	VisualNOS
syn keyword vimHLGroup	ErrorMsg	MoreMsg	Scrollbar	StatusLineNC	WarningMsg
syn keyword vimHLGroup	IncSearch	NonText	Search	Title	WildMenu
syn keyword vimHLGroup	LineNr

" Function Names
syn keyword vimFuncName contained	argc	delete	glob	line2byte	substitute
syn keyword vimFuncName contained	argv	did_filetype	has	localtime	synID
syn keyword vimFuncName contained	browse	escape	histadd	maparg	synIDattr
syn keyword vimFuncName contained	bufexists	exists	histdel	mapcheck	synIDtrans
syn keyword vimFuncName contained	bufloaded	expand	histget	match	system
syn keyword vimFuncName contained	bufname	filereadable	histnr	matchend	tempname
syn keyword vimFuncName contained	bufnr	fnamemodify	hlID	matchstr	virtcol
syn keyword vimFuncName contained	bufwinnr	getcwd	hlexists	nr2char	visualmode
syn keyword vimFuncName contained	byte2line	getftime	hostname	setline	winbufnr
syn keyword vimFuncName contained	char2nr	getline	input	strftime	winheight
syn keyword vimFuncName contained	col	getwinposx	isdirectory	strlen	winnr
syn keyword vimFuncName contained	confirm	getwinposy	line	strpart
syn match   vimFunc     contained	"\I\i*\s*("	contains=vimFuncName

"--- syntax above generated by mkvimvim ---

" Special Vim Highlighting

" Behave!
" =======
syn match   vimBehave	"^\s*\(behave\|behav\|beha\|beh\|be\)" contains=vimCommand skipwhite nextgroup=vimBehaveModel,vimBehaveError
syn match   vimBehave	"[:|]\s*\(behave\|behav\|beha\|beh\|be\)"lc=1 contains=vimCommand skipwhite nextgroup=vimBehaveModel,vimBehaveError
syn keyword vimBehaveModel contained	mswin	xterm
syn match   vimBehaveError contained	"[^ ]\+"

" Functions  Two clusters here have been included to facilitate users' modifications, such as special functions
" =========
syn cluster vimFuncList	contains=vimCommand
syn cluster vimFuncBodyList	contains=vimIsCommand,vimGroup,vimHLGroup,vimFunction,vimFunctionError,vimFuncBody,vimSpecFile,vimConditional,vimOper,vimNumber,vimComment,vimString,vimSubst,vimMark,vimRegister,vimAddress,vimFilter,vimCmplxRepeat,vimComment,vimSet,vimAutoCmd,vimRegion,vimSynLine,vimNotation,vimIsCommand,vimCtrlChar,vimFuncVar
syn match   vimFunction	"\(function\|functio\|functi\|funct\|func\|fun\|fu\)!\=\s\+[A-Z]\w*("me=e-1 contains=@vimFuncList nextgroup=vimFuncBody
syn match   vimFunctionError	"\(function\|functio\|functi\|funct\|func\|fun\|fu\)!\=\s\+[a-z].\{-}("me=e-1     contains=vimCommand   nextgroup=vimFuncBody
syn region  vimFuncBody contained	start=")"	end="\<endf"	contains=@vimFuncBodyList
syn match   vimFuncVar  contained	"a:\(\I\i*\|[0-9]\+\)"

syn keyword vimPattern contained	start	skip	end

" Special Filenames and Modifiers
syn match vimSpecFile	"<\(cword\|cWORD\|[cas]file\)>"	nextgroup=vimSpecFileMod,vimSubst
syn match vimSpecFile	"#\d\+\|[#%]<"		nextgroup=vimSpecFileMod,vimSubst
syn match vimSpecFileMod	"\(:[phtre]\)\+"		contained

" Conditionals
syn match vimConditional	"^\s*\(continue\|continu\|contin\|conti\|cont\|con\)\>"
syn match vimConditional	"^\s*\(endif\|endi\|end\|en\)\>"
syn match vimConditional	"^\s*\(endwhile\|endwhil\|endwhi\|endwh\|endw\)\>"
syn match vimConditional	"^\s*\(while\|whil\|whi\|wh\)\>"
syn match vimConditional	"^\s*break\=\>"
syn match vimConditional	"^\s*else\>"
syn match vimConditional	"^\s*elseif\=\>"
syn match vimConditional	"^\s*if\>"

syn match vimConditional	"[:|]\s*\(continue\|continu\|contin\|conti\|cont\|con\)\>"lc=1
syn match vimConditional	"[:|]\s*\(endif\|endi\|end\|en\)\>"lc=1
syn match vimConditional	"[:|]\s*\(endwhile\|endwhil\|endwhi\|endwh\|endw\)\>"lc=1
syn match vimConditional	"[:|]\s*\(while\|whil\|whi\|wh\)\>"lc=1
syn match vimConditional	"[:|]\s*break\=\>"lc=1
syn match vimConditional	"[:|]\s*else\>"lc=1
syn match vimConditional	"[:|]\s*elseif\=\>"lc=1
syn match vimConditional	"[:|]\s*if\>"lc=1

" Operators
syn match vimOper	"||\|&&\|!=\|>=\|<=\|=\~\|!\~\|>\|<\|+\|-\|=\|\." skipwhite nextgroup=vimString

" User-Specified Commands
syn cluster vimUserCmdList	contains=vimAddress,vimSyntax,vimHighlight,vimAutoCmd,vimCmplxRepeat,vimComment,vimConditional,vimCtrlChar,vimEscapeBrace,vimFilter,vimFunc,vimFunction,vimGroup,vimHLGroup,vimIsCommand,vimIsCommand,vimMark,vimNotation,vimNumber,vimOper,vimRegion,vimRegister,vimSet,vimSetEqual,vimSetString,vimSpecFile,vimString,vimSubst,vimSubstEnd,vimSubstRange,vimSynLine
syn region  vimUserCmd	transparent oneline matchgroup=vimStatement start="^\s*\(command\|comman\|comma\|comm\|com\)" end="$"		contains=vimUserAttrb,@vimUserCmdList
syn region  vimUserCmd	transparent oneline matchgroup=vimStatement start="[:|]\s*\(command\|comman\|comma\|comm\|com\)"hs=s+1 end="$"	contains=vimUserAttrb,@vimUserCmdList
syn match   vimUserAttrb	contained	"-nargs=[01*?+]"		contains=vimUserAttrbKey,vimOper
syn match   vimUserAttrb	contained transparent  "-complete=\(augroup\|buffer\|command\|dir\|event\|file\|help\|highlight\|menu\|option\|tag\|var\)"	contains=vimUserAttrbCmplt,vimOper
syn match   vimUserAttrb	contained	"-range\(=%\|=[0-9]\+\)\="	contains=vimNumber,vimOper,vimUserAttrbKey
syn match   vimUserAttrb	contained	"-count=[0-9]\+"		contains=vimNumber,vimOper,vimUserAttrbKey
syn match   vimUserAttrb	contained	"-bang\|-register"	contains=vimOper,vimUserAttrbKey
syn keyword vimUserAttrbKey	contained	bang	count	range
syn keyword vimUserAttrbKey	contained	complete	nargs	register
syn keyword vimUserAttrbCmplt	contained	augroup	dir	help	menu	tag
syn keyword vimUserAttrbCmplt	contained	buffer	event	highlight	option	var
syn keyword vimUserAttrbCmplt	contained	command	file

" Numbers
" =======
syn match vimNumber	"\<\d\+.\d\+"
syn match vimNumber	"\<\d\+L\="
syn match vimNumber	"-\d\+.\d\+"
syn match vimNumber	"-\d\+L\="
syn match vimNumber	"[[;:]\d\+"lc=1
syn match vimNumber	"0[xX][0-9a-fA-F]\+"
syn match vimNumber	"#[0-9a-fA-F]\+"

" Lower Priority Comments: after some vim commands...
" =======================
syn match  vimComment	+\s"[^\-:.%#=*].*$+lc=1	contains=vimTodo,vimCommentString
syn match  vimComment	+\<endif\s\+".*$+lc=5	contains=vimTodo,vimCommentString
syn match  vimComment	+\<else\s\+".*$+lc=4	contains=vimTodo,vimCommentString
syn match  vimComment	+\s"[^\-:.%#=*].*\\$+lc=1	contains=vimTodo,vimCommentString
syn region vimCommentString	contained oneline start="\s'"ms=s+1	end="'"

" Environment Variables
" =====================
syn match vimEnvvar	"\$\I\i*"
syn match vimEnvvar	"\${\I\i*}"

" Try to catch strings, if nothing else matches (therefore it must precede the others!)
"  vmEscapeBrace handles ["]  []"] (ie. stays as string)
syn region	vimEscapeBrace	oneline contained transparent	start="[^\\]\(\\\\\)*\[\^\=\]\=" skip="\\\\\|\\\]" end="\]"me=e-1
syn match	vimPatSep	contained	"\\[|()]"
syn match	vimNotPatSep	contained	"\\\\"
syn region	vimString	oneline	start=+[^:a-zA-Z>!\\]"+lc=1 skip=+\(\\\\\)*\\"+ end=+"+	contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start=+[^:a-zA-Z>!\\]'+lc=1 skip=+\(\\\\\)*\\'+ end=+'+	contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start=+=!+lc=1	skip=+\(\\\\\)*\\!+ end=+!+		contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start="=+"lc=1	skip="\(\\\\\)*\\+" end="+"		contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start="[^\\]+\s*[^a-zA-Z0-9.]"lc=1 skip="\(\\\\\)*\\+" end="+"	contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn region	vimString	oneline	start="\s/\s*[^a-zA-Z]"lc=1 skip="\(\\\\\)*\\+" end="/"	contains=vimEscapeBrace,vimPatSep,vimNotPatSep
syn match        vimString	contained	+"[^"]*\\$+	skipnl nextgroup=vimStringCont
syn match	vimStringCont	contained	+\(\\\\\|.\)\{-}[^\\]"+

" Substitutions
" =============
syn region	vimSubst	oneline	 start=":\=s/.\{-}" skip="\(\\\\\)*\\/" end="/"	contains=vimPatSep,vimSubstTwoBS,vimSubstRange,vimNotation nextgroup=vimSubstEnd
syn region	vimSubstEnd	contained oneline start="."lc=1	   skip="\(\\\\\)*\\/" end="/"	contains=vimSubstPat,vimSubstTwoBS,vimNotation
syn region	vimSubst	oneline	 start=":\=s?.\{-}" skip="\(\\\\\)*\\?" end="?"	contains=vimPatSep,vimSubstTwoBS,vimSubstRange,vimNotation nextgroup=vimSubstEnd
syn region	vimSubstEnd	contained oneline start="."lc=1	   skip="\(\\\\\)*\\?" end="?"	contains=vimSubstPat,vimSubstTwoBS,vimNotation
syn region	vimSubstRange	contained oneline start="\["	   skip="\(\\\\\)*\\]" end="]"
syn match	vimSubstPat	contained	"\\\d"
syn match	vimSubstTwoBS	contained	"\\\\"

" Marks, Registers, Addresses, Filters
syn match	vimMark	"[!,:]'[a-zA-Z0-9]"lc=1
syn match	vimMark	"'[a-zA-Z0-9][,!]"me=e-1
syn match	vimMark	"'[<>][,!]"me=e-1
syn match	vimMark	"[^a-zA-Z]norm\s'[a-zA-Z0-9]"lc=6
syn match	vimMark	"[^a-zA-Z]normal\s'[a-zA-Z0-9]"lc=8
syn match	vimPlainMark	"'[a-zA-Z0-9]"		contained

syn match	vimRegister	'[^(,;]"[a-zA-Z0-9\-:.%#*=][^a-zA-Z_"]'lc=1
syn match	vimRegister	'[^a-zA-Z]norm\s\+"[a-zA-Z0-9]'lc=6
syn match	vimRegister	'[^a-zA-Z]normal\s\+"[a-zA-Z0-9]'lc=8
syn match	vimPlainRegister	'"[a-zA-Z0-9\-:.%#*=]'	contained

syn match	vimAddress	",\."lc=1
syn match	vimAddress	"[:|][%.]"lc=1
syn match	vimAddress	"<Bar>%"lc=5

syn match	vimFilter	":\s*!"ms=e
syn match	vimFilter	"[^a-zA-Z]!"lc=1

" Complex repeats (:h complex-repeat)
syn match	vimCmplxRepeat	'[^a-zA-Z_/\\]q[0-9a-zA-Z"]'lc=1
syn match	vimCmplxRepeat	'@[0-9a-z".=@:]'

" Set command and associated set-options (vimOptions) with comment
syn region	vimSet		matchgroup=vimCommand start="\s*set\>" end="|\|$"	keepend contains=vimSetEqual,vimOption,vimErrSetting,vimComment,vimSetString
syn region	vimSetEqual	contained	start="="	skip="\(\\\\\)*\\\s" end="[| \t]\|$"me=e-1 contains=vimCtrlChar,vimSetSep,vimNotation
syn region	vimSetString	contained	start=+="+hs=s+1	skip=+\(\\\\\)\\"+   end=+"+	contains=vimCtrlChar
syn match	vimSetSep	contained	"[,:]"

" Autocmd
syn cluster vimAutoCmdCluster	contains=vimAutoCmdOpt,vimAutoEvent,vimComment,vimFilter,vimAuHighlight,vimIsCommand,vimIsCommand2,vimNotation,vimSet,vimSpecFile,vimString,vimAuSyntax
syn match   vimIsCommand2	contained transparent "[ \t<Bar>][a-zA-Z_]\+"lc=1  contains=vimCommand
syn keyword vimAutoCmdOpt	contained	nested
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+^\s*\(autocmd\|au\|doautocmd\|doau\)\>+	end="$" keepend contains=@vimAutoCmdCluster
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+[:|]\s*\(autocmd\|au\|doautocmd\|doau\)\>+	end="$" keepend contains=@vimAutoCmdCluster
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+^\s*\(doautoa\|doautoall\)\>+		end="$" keepend contains=@vimAutoCmdCluster
syn region  vimAutoCmd		matchgroup=vimAutoSet start=+[:|]\s*\(autocmd\|au\|doautocmd\|doau\)\>+lc=1	end="$" keepend contains=@vimAutoCmdCluster

" Echo -- prefer strings!
syn region  vimEcho	oneline	start="\<\(echo\|ech\|ec\)\>"   skip="\(\\\\\)*|" end="$\||" contains=vimCommand,vimString,vimOper
syn region  vimEcho	oneline	start="^\s*\(echo\|ech\|ec\)\>" skip="\(\\\\\)*|" end="$\||" contains=vimCommand,vimString,vimOper

" Syntax
"=======
syn match   vimGroupList	contained	"@\=[^ \t,]*"	contains=vimGroupSpecial,vimPatSep
syn match   vimGroupList	contained	"@\=[^ \t,]*,"	nextgroup=vimGroupList contains=vimGroupSpecial,vimPatSep
syn keyword vimGroupSpecial	contained	ALL	ALLBUT
syn match   vimSynError	contained	"\i\+"
syn match   vimSynError	contained	"\i\+="	nextgroup=vimGroupList
syn match   vimSynContains	contained	"contains="	nextgroup=vimGroupList
syn match   vimSynNextgroup	contained	"nextgroup="	nextgroup=vimGroupList

syn match   vimSyntax	"^\s*\(syntax\|synta\|synt\|syn\|sy\)"	contains=vimCommand skipwhite nextgroup=vimSynType,vimComment
syn match   vimSyntax	"[:|]\s*\(syntax\|synta\|synt\|syn\|sy\)"	contains=vimCommand skipwhite nextgroup=vimSynType,vimComment
syn match   vimAuSyntax	contained	"\s+\(syntax\|synta\|synt\|syn\|sy\)"	contains=vimCommand skipwhite nextgroup=vimSynType,vimComment

" Syntax: case
syn keyword vimSynType		contained	case	skipwhite nextgroup=vimSynCase,vimSynCaseError
syn match   vimSynCaseError	contained	"\i\+"
syn keyword vimSynCase		contained	ignore	match

" Syntax: clear
syn keyword vimSynType		contained	clear	skipwhite nextgroup=vimGroupList

" Syntax: cluster
syn keyword vimSynType		contained	cluster		skipwhite nextgroup=vimClusterName
syn region  vimClusterName	contained	matchgroup=vimGroupName start="\k\+" skip="\(\\\\\)*\\|" end="$\||" contains=vimGroupAdd,vimGroupRem,vimSynContains,vimSynError
syn match   vimGroupAdd		contained	"add="		nextgroup=vimGroupList
syn match   vimGroupRem		contained	"remove="	nextgroup=vimGroupList

" Syntax: include
syn keyword vimSynType		contained	include		skipwhite nextgroup=vimGroupList

" Syntax: keyword
syn keyword vimSynType		contained	keyword		skipwhite nextgroup=vimSynKeyRegion
syn region  vimSynKeyRegion	contained oneline matchgroup=vimGroupName start="\k\+" skip="\(\\\\\)*\\|" end="$\||" contains=vimSynNextgroup,vimSynKeyOpt
syn match   vimSynKeyOpt	contained	"\<\(contained\|transparent\|skipempty\|skipwhite\|skipnl\)\>"

" Syntax: match
syn keyword vimSynType		contained	match	skipwhite nextgroup=vimSynMatchRegion
syn region  vimSynMatchRegion	contained oneline keepend matchgroup=vimGroupName start="\k\+" end="$" contains=vimComment,vimSynContains,vimSynError,vimSynKeyOpt,vimSynNextgroup,vimSynRegPat

" Syntax: off
syn keyword vimSynType		contained	off

" Syntax: region
syn keyword vimSynType		contained	region	skipwhite nextgroup=vimSynRegion
syn region  vimSynRegion	contained oneline matchgroup=vimGroupName start="\k\+" skip="\(\\\\\)*\\|" end="$\||" contains=vimSynContains,vimSynNextgroup,vimSynRegOpt,vimSynReg,vimSynMtchGrp
syn match   vimSynRegOpt	contained	"\<\(contained\|transparent\|skipempty\|skipwhite\|skipnl\|oneline\|keepend\)\>"
syn match   vimSynReg		contained	"\(start\|skip\|end\)="he=e-1	nextgroup=vimSynRegPat
syn match   vimSynMtchGrp	contained	"matchgroup="
syn region  vimSynRegPat	contained oneline	start="!" skip="\(\\\\\)*\\!" end="!" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="%" skip="\(\\\\\)*\\-" end="%" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="'" skip="\(\\\\\)*\\'" end="'" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="+" skip="\(\\\\\)*\\+" end="+" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start="@" skip="\(\\\\\)*\\@" end="@" contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start='"' skip='\(\\\\\)*\\"' end='"' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start='/' skip='\(\\\\\)*\\/' end='/' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start=',' skip='\(\\\\\)*\\,' end=',' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn region  vimSynRegPat	contained oneline	start='\$' skip='\(\\\\\)*\\\$' end='\$' contains=vimPatSep,vimNotPatSep,vimSynPatRange,vimSynNotPatRange nextgroup=vimSynPatMod
syn match   vimSynPatMod	contained	"\(hs\|ms\|me\|hs\|he\|rs\|re\)=[se]\([-+][0-9]\+\)\="
syn match   vimSynPatMod	contained	"\(hs\|ms\|me\|hs\|he\|rs\|re\)=[se]\([-+][0-9]\+\)\=," nextgroup=vimSynPatMod
syn match   vimSynPatMod	contained	"lc=[0-9]\+"
syn match   vimSynPatMod	contained	"lc=[0-9]\+," nextgroup=vimSynPatMod
syn region  vimSynPatRange	contained oneline start="\["	skip="\(\\\\\)*\\]"   end="]"
syn match   vimSynNotPatRange	contained	"\(\\\\\)*\\\["

" Syntax: sync
syn keyword vimSynType		contained	sync	skipwhite nextgroup=vimSyncC,vimSyncLines,vimSyncMatch,vimSyncError,vimSyncLinecont
syn match   vimSyncError	contained	"\i\+"
syn keyword vimSyncC	contained	ccomment	clear
syn keyword vimSyncMatch	contained	match	skipwhite nextgroup=vimSyncGroupName
syn keyword vimSyncLinecont	contained	linecont	skipwhite nextgroup=vimSynRegPat
syn match   vimSyncLines	contained	"\(minlines\|maxlines\|lines\)=" nextgroup=vimNumber
syn match   vimSyncGroupName	contained	"\k\+" skipwhite nextgroup=vimSyncKey
syn match   vimSyncKey		contained	"\<groupthere\|grouphere\>"	skipwhite nextgroup=vimSyncGroup
syn match   vimSyncGroup	contained	"\k\+" skipwhite nextgroup=vimSynRegPat,vimSyncNone
syn keyword vimSyncNone		contained	NONE

" Additional IsCommand stuff, here by reasons of precedence
" ====================
syn match vimIsCommand	"<Bar>\s*[a-zA-Z]\+"	transparent contains=vimCommand,vimNotation

" Highlighting
" ============
syn match   vimHighlight	"^\s*\(highlight\|highligh\|highlig\|highli\|highl\|high\|hig\|hi\)"	skipwhite nextgroup=vimHiLink,vimHiClear,vimHiKeyList,vimComment
syn match   vimHighlight	"[:|]\s*\(highlight\|highligh\|highlig\|highli\|highl\|high\|hig\|hi\)"	skipwhite nextgroup=vimHiLink,vimHiClear,vimHiKeyList,vimComment
syn match   vimAuHighlight	contained	"\s+\(highlight\|highligh\|highlig\|highli\|highl\|high\|hig\|hi\)"	skipwhite nextgroup=vimHiLink,vimHiClear,vimHiKeyList,vimComment

syn match   vimHiGroup	contained	"\i\+"
syn case ignore
syn keyword vimHiAttrib	contained	none bold inverse italic reverse standout underline
syn keyword vimFgBgAttrib	contained	none bg background fg foreground
syn case match
syn match   vimHiAttribList	contained	"\i\+"	contains=vimHiAttrib
syn match   vimHiAttribList	contained	"\i\+,"he=e-1	contains=vimHiAttrib nextgroup=vimHiAttribList,vimHiAttrib
syn case ignore
syn keyword vimHiCtermColor	contained	black	darkcyan	darkred	lightcyan	lightred
syn keyword vimHiCtermColor	contained	blue	darkgray	gray	lightgray	magenta
syn keyword vimHiCtermColor	contained	brown	darkgreen	green	lightgreen	red
syn keyword vimHiCtermColor	contained	cyan	darkgrey	grey	lightgrey	white
syn keyword vimHiCtermColor	contained	darkBlue	darkmagenta	lightblue	lightmagenta	yellow
syn case match
syn match   vimHiFontname	contained	"[a-zA-z\-*]\+"
syn match   vimHiGuiFontname	contained	"'[a-zA-z\-* ]\+'"
syn match   vimHiGuiRgb	contained	"#\x\{6}"
syn match   vimHiCtermError	contained	"[^0-9]\i*"

" Highlighting: hi group key=arg ...
syn cluster vimHiCluster contains=vimHiGroup,vimHiTerm,vimHiCTerm,vimHiStartStop,vimHiCtermFgBg,vimHiGui,vimHiGuiFont,vimHiGuiFgBg,vimHiKeyError
syn region vimHiKeyList	contained oneline start="\i\+" skip="\(\\\\\)*\\|" end="$\||"	contains=@vimHiCluster
syn match  vimHiKeyError	contained	"\i\+="he=e-1
syn match  vimHiTerm	contained	"[tT][eE][rR][mM]="he=e-1			nextgroup=vimHiAttribList
syn match  vimHiStartStop	contained	"\([sS][tT][aA][rR][tT]\|[sS][tT][oO][pP]\)="he=e-1	nextgroup=vimHiTermcap,vimOption
syn match  vimHiCTerm	contained	"[cC][tT][eE][rR][mM]="he=e-1			nextgroup=vimHiAttribList
syn match  vimHiCtermFgBg	contained	"[cC][tT][eE][rR][mM][fFbB][gG]="he=e-1		nextgroup=vimNumber,vimHiCtermColor,vimFgBgAttrib,vimHiCtermError
syn match  vimHiGui	contained	"[gG][uU][iI]="he=e-1			nextgroup=vimHiAttribList
syn match  vimHiGuiFont	contained	"[fF][oO][nN][tT]="he=e-1			nextgroup=vimHiFontname
syn match  vimHiGuiFgBg	contained	"[gG][uU][iI][fFbB][gG]="he=e-1			nextgroup=vimHiGroup,vimHiGuiFontname,vimHiGuiRgb,vimFgBgAttrib
syn match  vimHiTermcap	contained	"\S\+"		contains=vimNotation

" Highlight: clear
syn keyword vimHiClear	contained	clear		nextgroup=vimHiGroup

" Highlight: link
syn region vimHiLink	contained oneline matchgroup=vimCommand start="link" end="$"	contains=vimHiGroup,vimGroup

" Angle-Bracket Notation (tnx to Michael Geddes)
" ======================
syn case ignore
syn match vimNotation	"<\([scam]-\)\{0,4}\(f[0-9]\{1,2}\|[^ \t:]\|cr\|lf\|linefeed\|return\|del\(ete\)\ =\|bs\|backspace\|tab\|esc\|right\|left\|Help\|Undo\|Insert\|Ins\|k\=Home\|k \=End\|kPlus\|kMinus\|kDivide\|kMultiply\|kEnter\|k\=\(page\)\=\(\|down\|up\)\)>" contains=vimBracket
syn match vimNotation	"<\([scam2-4]-\)\{0,4}\(right\|left\|middle\)\(mouse\|drag\|release\)>" contains=vimBracket
syn match vimNotation	"<\(nul\|bar\|bslash\|lt\|space\)>"		contains=vimBracket
syn match vimNotation	'<C-R>[0-9a-z"%#:.\-=]'he=e-1			contains=vimBracket
syn match vimBracket contained	"[<>]"
syn match vimBracket contained	"[<>]"
syn case match

" Control Characters
" ==================
syn match vimCtrlChar	"[--]"

" Ignore leading :
" ================
syn match vimColon	"^\(\s*:\)\+\s*"	nextgroup=vimCommand

" High Priority Comments- beginning of line with optional spaces then "
syn match vimLineComment	+^[ \t:]*".*$+		contains=vimTodo,vimCommentString,vimCommentTitle
syn match vimCommentTitle	"\([A-Z][a-z]*\s*\)\+:"	contained

" Highlighting Settings
" ====================
if !exists("did_vim_syntax_inits")
  let did_vim_syntax_inits = 1

  " The default methods for highlighting.  Can be overridden later
  hi link vimAuHighlight	vimHighlight

  hi link vimAddress	vimMark
  hi link vimAutoCmdOpt	vimOption
  hi link vimAutoSet	vimCommand
  hi link vimBehaveError	vimError
  hi link vimCommentString	vimString
  hi link vimConditional	vimStatement
  hi link vimErrSetting	vimError
  hi link vimFgBgAttrib	vimHiAttrib
  hi link vimFilter	vimOper
  hi link vimFunctionError	vimError
  hi link vimGroupAdd	vimSynOption
  hi link vimGroupRem	vimSynOption
  hi link vimHLGroup	vimGroup
  hi link vimHiAttribList	vimError
  hi link vimHiCTerm	vimHiTerm
  hi link vimHiCtermError	vimError
  hi link vimHiCtermFgBg	vimHiTerm
  hi link vimHiGroup	vimGroupName
  hi link vimHiGui	vimHiTerm
  hi link vimHiGuiFgBg	vimHiTerm
  hi link vimHiGuiFont	vimHiTerm
  hi link vimHiGuiRgb	vimNumber
  hi link vimHiKeyError	vimError
  hi link vimHiStartStop	vimHiTerm
  hi link vimHighlight	vimCommand
  hi link vimKeyCode	vimSpecFile
  hi link vimKeyCodeError	vimError
  hi link vimLineComment	vimComment
  hi link vimNotPatSep	vimString
  hi link vimPlainMark	vimMark
  hi link vimPlainRegister	vimRegister
  hi link vimSetString	vimString
  hi link vimSpecFileMod	vimSpecFile
  hi link vimStringCont	vimString
  hi link vimSynCaseError	vimError
  hi link vimSynContains	vimSynOption
  hi link vimSynKeyOpt	vimSynOption
  hi link vimSynMtchGrp	vimSynOption
  hi link vimSynNextgroup	vimSynOption
  hi link vimSynNotPatRange	vimSynRegPat
  hi link vimSynPatRange	vimString
  hi link vimSynRegOpt	vimSynOption
  hi link vimSynRegPat	vimString
  hi link vimSynType	vimSpecial
  hi link vimSyncGroup	vimGroupName
  hi link vimSyncGroupName	vimGroupName
  hi link vimUserAttrb	vimSpecial
  hi link vimUserAttrbCmplt	vimSpecial
  hi link vimUserAttrbKey	vimOption
  hi link vimUserCmd	vimCommand

  hi link vimAutoEvent	Type
  hi link vimBracket	Delimiter
  hi link vimCmplxRepeat	SpecialChar
  hi link vimCommand	Statement
  hi link vimComment	Comment
  hi link vimCommentTitle	PreProc
  hi link vimCtrlChar	SpecialChar
  hi link vimEnvvar	PreProc
  hi link vimError	Error
  hi link vimFuncName	Function
  hi link vimFuncVar	Identifier
  hi link vimGroup	Type
  hi link vimGroupSpecial	Special
  hi link vimHLMod	PreProc
  hi link vimHiAttrib	PreProc
  hi link vimHiTerm	Type
  hi link vimKeyword	Statement
  hi link vimMark	Number
  hi link vimNotation	Special
  hi link vimNumber	Number
  hi link vimOper	Operator
  hi link vimOption	PreProc
  hi link vimPatSep	SpecialChar
  hi link vimPattern	Type
  hi link vimRegister	SpecialChar
  hi link vimSetSep	Statement
  hi link vimSpecFile	Identifier
  hi link vimSpecial	Type
  hi link vimStatement	Statement
  hi link vimString	String
  hi link vimSubstPat	SpecialChar
  hi link vimSynCase	Type
  hi link vimSynCaseError	Error
  hi link vimSynError	Error
  hi link vimSynOption	Special
  hi link vimSynReg	Type
  hi link vimSyncC	Type
  hi link vimSyncError	Error
  hi link vimSyncKey	Type
  hi link vimSyncNone	Type
  hi link vimTodo	Todo
endif

let b:current_syntax = "vim"

" vim: ts=17
