" Vim syntax file
" Language:	Novell NCF Batch File
" Maintainer:	Jonathan J. Miner <jon.miner@doit.wisc.edu>
" Last change:	Thursday 04 February 1999 08:48 Central Standard Time

" Remove any old syntax stuff hanging around
syn clear

syn case ignore

syn match  NovellComment		"^\ *rem.*$"
syn match  NovellComment		"^\ *;.*$"
syn match  NovellComment		"^\ *#.*$"

syn match NovellPath			"search \(add\|del\)"
syn match NovellServerName		"^file server name .*$"
syn match NovellIPXNet			"^ipx internal net"
syn keyword NovellCommands		set load mount
syn keyword NovellBoolean		on off

" String
syn region  NovellString	start=+"+  end=+"+

syn match NovellNumber			"\<\d\(\d\+\|[A-F]\+\)*\>"

syn match NovellLogins			"^\([Dd]is\|[Ee]n\)able login[s]*"
syn match NovellScript			"[^ ]*\.ncf"


if !exists("did_Novell_syntax_inits")
  let did_Novell_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link NovellCommands		Statement
  hi link NovellLogins			NovellCommands
  hi link NovellString			String
  hi link NovellComment			Comment
  hi link NovellImplicit		Type
  hi link NovellBoolean			Boolean
  hi link NovellScript			Identifier
  hi link NovellNumber			Number
  hi link NovellPath			Constant
  hi link NovellServerName		Special
  hi link NovellIPXNet			NovellServerName

endif

let b:current_syntax = "Novell"

" vim: ts=8
