" Vim syntax file
" Language:     M4
" Maintainer:   Christian Hammesr <ch@lathspell.westend.com>
" Last change:  1998 Oct 15


" Well, I actually even do not know much about m4. This explains why there
" is probably very much missing here, yet !
" But I missed a good hilighting when editing my GNU autoconf/automake
" script, so I wrote this quick and dirty patch.


" remove any old syntax stuff hanging around
syn clear

" define the m4 syntax
syn match   m4delimiter "[()\[\];,]"
syn match   m4operator  "[=|&\*\+\<\>]"
syn match   m4comment   "\(dnl.*\)\|\(#.*\)"
syn match   m4function  "\<[A-Z_]*\>"
syn match   m4number    "[-+]\=\<\d\+\(\.\d*\)\=\>"
syn keyword m4keyword   if then else fi test for in do done
syn keyword m4special   cat rm eval
syn region  m4string    start=+"+ skip=+\\"+ end=+"+
syn region  m4string    start=+`+ skip=+\\'+ end=+'+
syn region  m4string    start=+`+ skip=+\\'+ end=+`+

if !exists("did_m4_syntax_inits")
  let did_m4_syntax_inits = 1
  " The default methods for highlighting.  Can be overridden later
  hi link m4delimiter Delimiter
  hi link m4operator  Operator
  hi link m4comment   Comment
  hi link m4function  Function
  hi link m4number    Number
  hi link m4keyword   Keyword
  hi link m4special   Special
  hi link m4string    String
endif

let b:current_syntax = "m4"

" vim: ts=4
