/* vi:set ts=8 sts=4 sw=4:
 *
 * VIM - Vi IMproved	by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

/*
 * option.h: definition of global variables for settable options
 *
 * EXTERN is only defined in main.c (and vim.h)
 */

#ifndef EXTERN
# define EXTERN extern
# define INIT(x)
#else
# ifndef INIT
#  define INIT(x) x
# endif
#endif

/* default values for p_efm 'errorformat' */
#ifdef AMIGA
# define EFM_DFLT	"%f>%l:%c:%t:%n:%m,%f:%l: %t%*\\D%n: %m,%f %l %t%*\\D%n: %m,%*[^\"]\"%f\"%*\\D%l: %m,%f:%l:%m"
#else
# if defined MSDOS  ||	defined WIN32
#  define EFM_DFLT	"%f(%l) : %t%*\\D%n: %m,%*[^\"]\"%f\"%*\\D%l: %m,%f(%l) : %m,%*[^ ] %f %l: %m,%f:%l:%m"
# else
#  if defined(__EMX__)	/* put most common here (i.e. gcc format) at front */
#   define EFM_DFLT	"%f:%l:%m,%*[^\"]\"%f\"%*\\D%l: %m,\"%f\"%*\\D%l: %m,%f(%l:%c) : %m"
#  else
#   if defined(__QNX__)
#    define EFM_DFLT	"%f(%l):%*[^WE]%t%*\\D%n:%m"
#   else /* Unix, probably */
#define EFM_DFLT	"%*[^\"]\"%f\"%*\\D%l: %m,\"%f\"%*\\D%l: %m,%f:%l:%m,\"%f\"\\, line %l%*\\D%c%*[^ ] %m,%D%*\\a[%*\\d]: Entering directory `%f',%X%*\\a[%*\\d]: Leaving directory `%f',%DMaking %*\\a in %f"
#   endif
#  endif
# endif
#endif

#define GEFM_DFLT	"%f:%l%m,%f  %l%m"

/* default values for b_p_ff 'fileformat' and p_ffs 'fileformats' */
#define FF_DOS		"dos"
#define FF_MAC		"mac"
#define FF_UNIX		"unix"

#ifdef USE_CRNL
# define FF_DFLT	"dos"
# define FFS_DFLT	"dos,unix"
# define FFS_VI		"dos,unix"	/* also autodetect in compatible mode */
# define TA_DFLT	TRUE
#else
# ifdef USE_CR
#  define FF_DFLT	"mac"
#  define FFS_DFLT	"mac,unix,dos"
# else
#  define FF_DFLT	"unix"
#  define FFS_DFLT	"unix,dos"
# endif
# define FFS_VI		""
# define TA_DFLT	FALSE
#endif

#ifdef MULTI_BYTE
#define FE_ANSI		"ansi"
#define FE_UNICODE	"unicode"
#define FE_DBJPN	"japan"
#define FE_DBKOR	"korea"
#define FE_DBCHT	"taiwan"
#define FE_DBCHS	"prc"
#define FE_HEBREW	"hebrew"
#define FE_FARSI	"farsi"

/* default value for 'fileencoding' */
#define FE_DFLT		FE_ANSI
#endif

/* end-of-line style */
#define EOL_UNKNOWN	-1	/* not defined yet */
#define EOL_UNIX	0	/* NL */
#define EOL_DOS		1	/* CR NL */
#define EOL_MAC		2	/* CR */

/* Formatting options for p_fo 'formatoptions' */
#define FO_WRAP		't'
#define FO_WRAP_COMS	'c'
#define FO_RET_COMS	'r'
#define FO_OPEN_COMS	'o'
#define FO_Q_COMS	'q'
#define FO_Q_SECOND	'2'
#define FO_INS_VI	'v'
#define FO_INS_LONG	'l'
#define FO_INS_BLANK	'b'

#define FO_DFLT_VI	"vt"
#define FO_DFLT		"tcq"
#define FO_ALL		"tcroq2vlb,"	/* for do_set() */

/* characters for the p_cpo option: */
#define CPO_ALTREAD	'a'	/* ":read" sets alternate file name */
#define CPO_ALTWRITE	'A'	/* ":write" sets alternate file name */
#define CPO_BAR		'b'	/* "\|" ends a mapping */
#define CPO_BSLASH	'B'	/* backslash in mapping is not special */
#define CPO_SEARCH	'c'
#define CPO_DOTTAG	'd'	/* "./tags" in 'tags' is in current dir */
#define CPO_EXECBUF	'e'
#define CPO_EMPTYREGION	'E'	/* operating on empty region is an error */
#define CPO_FNAMER	'f'	/* set file name for ":r file" */
#define CPO_FNAMEW	'F'	/* set file name for ":w file" */
#define CPO_JOINSP	'j'	/* only use two spaces for join after '.' */
#define CPO_KEYCODE	'k'	/* don't recognize raw key code in mappings */
#define CPO_LITERAL	'l'	/* take char after backslash in [] literal */
#define CPO_LISTWM	'L'	/* 'list' changes wrapmargin */
#define CPO_SHOWMATCH	'm'
#define CPO_LINEOFF	'o'
#define CPO_LISP	'p'	/* 'lisp' indenting */
#define CPO_REDO	'r'
#define CPO_BUFOPT	's'
#define CPO_BUFOPTGLOB	'S'
#define CPO_TAGPAT	't'
#define CPO_UNDO	'u'	/* "u" undoes itself */
#define CPO_CW		'w'	/* "cw" only changes one blank */
#define CPO_FWRITE	'W'	/* "w!" doesn't overwrite readonly files */
#define CPO_ESC		'x'
#define CPO_YANK	'y'
#define CPO_DOLLAR	'$'
#define CPO_FILTER	'!'
#define CPO_MATCH	'%'
#define CPO_STAR	'*'	/* ":*" means ":@" */
#define CPO_SPECI	'<'	/* don't recognize <> in mappings */
#define CPO_DEFAULT	"aABceFs"
#define CPO_ALL		"aAbBcdeEfFjklLmoprsStuwWxy$!%*<"

/* characters for p_ww option: */
#define WW_ALL		"bshl<>[],~"

/* characters for p_mouse option: */
#define MOUSE_NORMAL	'n'		/* use mouse in Normal mode */
#define MOUSE_VISUAL	'v'		/* use mouse in Visual/Select mode */
#define MOUSE_INSERT	'i'		/* use mouse in Insert mode */
#define MOUSE_COMMAND	'c'		/* use mouse in Command-line mode */
#define MOUSE_HELP	'h'		/* use mouse in help buffers */
#define MOUSE_RETURN	'r'		/* use mouse for hit-return message */
#define MOUSE_ASEL	'A'		/* auto-select in Visual mode */
#define MOUSE_A		"nvich"		/* used for 'a' flag */
#define MOUSE_ALL	"anvichrA"	/* all possible characters */

/* characters for p_shm option: */
#define SHM_RO		'r'		/* readonly */
#define SHM_MOD		'm'		/* modified */
#define SHM_FILE	'f'		/* (file 1 of 2) */
#define SHM_LAST	'i'		/* last line incomplete */
#define SHM_TEXT	'x'		/* tx instead of textmode */
#define SHM_LINES	'l'		/* "L" instead of "lines" */
#define SHM_NEW		'n'		/* "[New]" instead of "[New file]" */
#define SHM_WRI		'w'		/* "[w]" instead of "written" */
#define SHM_A		"rmfixlnw"	/* represented by 'a' flag */
#define SHM_WRITE	'W'		/* don't use "written" at all */
#define SHM_TRUNC	't'		/* trunctate message */
#define SHM_OVER	'o'		/* overwrite file messages */
#define SHM_OVERALL	'O'		/* overwrite more messages */
#define SHM_SEARCH	's'		/* no search hit bottom messages */
#define SHM_ATTENTION	'A'		/* no ATTENTION messages */
#define SHM_INTRO	'I'		/* intro messages */
#define SHM_ALL		"rmfixlnwaWtoOsAI" /* all possible flags for 'shm' */

/* characters for p_guioptions: */
#define GO_ASEL		'a'		/* autoselect */
#define GO_BOT		'b'		/* use bottom scrollbar */
#define GO_FORG		'f'		/* start GUI in foreground */
#define GO_GREY		'g'		/* use grey menu items */
#define GO_ICON		'i'		/* use Vim icon */
#define GO_LEFT		'l'		/* use left scrollbar */
#define GO_MENUS	'm'		/* use menu bar */
#define GO_POINTER	'p'		/* pointer enter/leave callbacks */
#define GO_RIGHT	'r'		/* use right scrollbar */
#define GO_TEAROFF	't'		/* add tear-off menu items */
#define GO_TOOLBAR	'T'		/* add toolbar */
#define GO_VERTICAL	'v'		/* vertical toolbar */
#define GO_ALL		"abfgilmprtTv"	/* all possible flags for 'go' */

/* flags for 'comments' option */
#define COM_NEST	'n'		/* comments strings nest */
#define COM_BLANK	'b'		/* needs blank after string */
#define COM_START	's'		/* start of comment */
#define COM_MIDDLE	'm'		/* middle of comment */
#define COM_END		'e'		/* end of comment */
#define COM_FIRST	'f'		/* first line comment only */
#define COM_LEFT	'l'		/* left adjusted */
#define COM_RIGHT	'r'		/* right adjusted */
#define COM_ALL		"nbsmeflr"	/* all flags for 'comments' option */
#define COM_MAX_LEN	50		/* maximum length of a part */

/* flags for 'statusline' option */
#define STL_FILEPATH	'f'		/* path of file in buffer */
#define STL_FULLPATH	'F'		/* full path of file in buffer */
#define STL_FILENAME	't'		/* last part (tail) of file path */
#define STL_COLUMN	'c'		/* column og cursor*/
#define STL_VIRTCOL	'v'		/* virtual column */
#define STL_VIRTCOL_ALT	'V'		/* - with 'if different' display */
#define STL_LINE	'l'		/* line number of cursor */
#define STL_NUMLINES	'L'		/* number of lines in buffer */
#define STL_BUFNO	'n'		/* current buffer number */
#define STL_OFFSET	'o'		/* offset of character under cursor*/
#define STL_OFFSET_X	'O'		/* - in hexadecimal */
#define STL_BYTEVAL	'b'		/* byte value of character */
#define STL_BYTEVAL_X	'B'		/* - in hexadecimal */
#define STL_ROFLAG	'r'		/* readonly flag */
#define STL_ROFLAG_ALT	'R'		/* - other display */
#define STL_HELPFLAG	'h'		/* window is showing a help file */
#define STL_HELPFLAG_ALT 'H'		/* - other display */
#define STL_MODIFIED	'm'		/* modified flag */
#define STL_MODIFIED_ALT 'M'		/* - other display */
#define STL_PERCENTAGE	'p'		/* percentage through file */
#define STL_ALTPERCENT	'P'		/* percentage as TOP BOT ALL or NN% */
#define STL_ARGLISTSTAT	'a'		/* argument list status as (x of y) */
#define STL_VIM_EXPR	'{'		/* start of expression to substitute */
#define STL_MIDDLEMARK	'='		/* separation between left and right */
#define STL_TRUNCMARK	'<'		/* truncation mark if line is too long*/
#define STL_HIGHLIGHT	'*'		/* highlight from (User)1..9 or 0 */
#define STL_ALL		((char_u *) "fFtcvVlLnoObBrRhHmMpPa{")

/* flags used for parsed 'wildmode' */
#define WIM_FULL	1
#define WIM_LONGEST	2
#define WIM_LIST	4

/*
 * The following are actual variabables for the options
 */

#ifdef RIGHTLEFT
EXTERN long	p_aleph;	/* Hebrew 'Aleph' encoding */
#endif
EXTERN int	p_aw;		/* auto-write */
EXTERN long	p_bs;		/* backspace over newlines in insert mode */
EXTERN char_u  *p_bg;		/* window background color: light or dark */
EXTERN int	p_bk;		/* make backups when writing out files */
EXTERN char_u  *p_bdir;		/* list of directory names for backup files */
EXTERN char_u  *p_bex;		/* extension for backup file */
EXTERN char_u  *p_bsdir;	/* 'browsedir' */
#ifdef MSDOS
EXTERN int	p_biosk;	/* Use bioskey() instead of kbhit() */
EXTERN int	p_consk;	/* Use cons_kbhit() instead of kbhit() */
#endif
EXTERN char_u  *p_breakat;	/* characters that can cause a line break */
EXTERN long	p_ch;		/* command line height */
#if defined(GUI_DIALOG) || defined(CON_DIALOG)
EXTERN int	p_confirm;	/* 'confirm' */
#endif
EXTERN int	p_cp;		/* vi-compatible */
EXTERN char_u  *p_cpo;		/* vi-compatible option flags */
#ifdef USE_CSCOPE
EXTERN char_u  *p_csprg;	/* name of cscope program */
EXTERN int	p_cst;		/* always use :cstag instead of :tag command */
EXTERN long	p_csto;		/* cscope/tags search order */
EXTERN int	p_csverbose;	/* cscope verbose messages flag */
#endif
EXTERN char_u  *p_def;		/* Pattern for recognising definitions */
EXTERN char_u  *p_dict;		/* Dictionaries for ^P/^N */
#ifdef DIGRAPHS
EXTERN int	p_dg;		/* enable digraphs */
#endif
EXTERN char_u	*p_dir;		/* list of directories for swap file */
EXTERN int	p_ed;		/* :s is ed compatible */
EXTERN int	p_ea;		/* make windows equal height */
EXTERN char_u	*p_ep;		/* program name for '=' command */
EXTERN int	p_eb;		/* ring bell for errors */
#ifdef QUICKFIX
EXTERN char_u  *p_ef;		/* name of errorfile */
EXTERN char_u  *p_efm;		/* error format */
EXTERN char_u  *p_gefm;		/* error format for grep -n */
#endif
#ifdef AUTOCMD
EXTERN char_u  *p_ei;		/* events ignored for autocommands */
#endif
EXTERN int	p_ek;		/* function keys with ESC in insert mode */
EXTERN int	p_exrc;		/* read .exrc in current dir */
EXTERN char_u  *p_ffs;		/* acceptable file formats */
EXTERN char_u  *p_fp;		/* name of format program */
EXTERN int	p_gd;		/* /g is default for :s */
#ifdef USE_GUI
EXTERN char_u  *p_guifont;	/* GUI font list */
# ifdef USE_FONTSET
EXTERN char_u  *p_guifontset;	/* GUI fontset list */
# endif
EXTERN int	p_guipty;	/* use pseudo pty for external commands */
#endif
#ifdef CURSOR_SHAPE
EXTERN char_u  *p_guicursor;	/* shape settings for cursor */
#endif
#if defined(USE_GUI)
EXTERN char_u  *p_guioptions;	/* Which GUI components? */
#endif
EXTERN char_u  *p_hf;		/* name of help file */
EXTERN long	p_hh;		/* help window height */
EXTERN int	p_hid;		/* buffers can be hidden */
EXTERN char_u  *p_hl;		/* which highlight mode to use */
EXTERN int	p_hls;		/* highlight matches with last search pattern */
EXTERN long	p_hi;		/* command line history size */
#ifdef RIGHTLEFT
EXTERN int	p_hkmap;	/* Hebrew keyboard map */
EXTERN int	p_hkmapp;	/* idem, phonetic */
# ifdef FKMAP
EXTERN int	p_fkmap;	/* Farsi keyboard map */
EXTERN int	p_altkeymap;	/* alternative keyboard map Hebrew/Farsi */
# endif
#endif
#ifdef WANT_TITLE
EXTERN int	p_icon;		/* put file name in icon if possible */
EXTERN char_u  *p_iconstring;	/* icon string */
#endif
EXTERN int	p_ic;		/* ignore case in searches */
EXTERN int	p_is;		/* incremental search */
EXTERN int	p_im;		/* start editing in input mode */
EXTERN char_u  *p_inc;		/* Pattern for including other files */
EXTERN char_u  *p_isf;		/* characters in a file name */
EXTERN char_u  *p_isi;		/* characters in an identifier */
EXTERN char_u  *p_isp;		/* characters that are printable */
EXTERN int	p_js;		/* use two spaces after '.' with Join */
EXTERN char_u  *p_kp;		/* keyword program */
EXTERN char_u  *p_km;		/* 'keymodel' */
#ifdef HAVE_LANGMAP
EXTERN char_u  *p_langmap;	/* mapping for some language */
#endif
EXTERN long	p_ls;		/* last window has status line */
EXTERN char_u  *p_lcs;		/* characters for list mode */

EXTERN int	p_lz;		/* lazy redraw, only when key typed */
EXTERN int	p_magic;	/* use some characters for reg exp */
#ifdef QUICKFIX
EXTERN char_u  *p_mef;		/* name of make errorfile */
EXTERN char_u  *p_mp;		/* program for :make command */
EXTERN char_u  *p_gp;		/* program for :grep command */
#endif
EXTERN long	p_mat;		/* time to show the match of a paren */
EXTERN long	p_mfd;		/* 'maxfuncdepth' */
EXTERN long	p_mmd;		/* 'maxmapdepth' */
EXTERN long	p_mm;		/* maximal amount of memory for buffer */
EXTERN long	p_mmt;		/* maximal amount of memory for Vim */
EXTERN long	p_mls;		/* number of mode lines */
EXTERN char_u  *p_mouse;	/* flags for use of mouse */
#ifdef USE_GUI
EXTERN int	p_mousef;	/* 'mousefocus' */
EXTERN int	p_mh;		/* hide pointer enable */
#endif
EXTERN char_u  *p_mousem;	/* 'mousemodel' */
EXTERN long	p_mouset;	/* mouse double click time */
EXTERN int	p_more;		/* wait when screen full when listing */
EXTERN char_u  *p_para;		/* paragraphs */
EXTERN int	p_paste;	/* paste mode */
EXTERN char_u  *p_pm;		/* patchmode file suffix */
EXTERN char_u  *p_path;		/* path for "]f" and "^Wf" */
EXTERN int	p_remap;	/* remap */
EXTERN long	p_report;	/* minimum number of lines for report */
#ifdef WIN32
EXTERN int	p_rs;		/* restore startup screen upon exit */
#endif
#ifdef RIGHTLEFT
EXTERN int	p_ari;		/* allow CTRL-_ command */
EXTERN int	p_ri;		/* reverse direction of insert */
#endif
EXTERN int	p_ru;		/* show column/line number */
#ifdef STATUSLINE
EXTERN char_u	*p_ruf;		/* custom content of ruler */
#endif
EXTERN long	p_sj;		/* scroll jump size */
EXTERN long	p_so;		/* scroll offset */
#ifdef SCROLLBIND
EXTERN char_u  *p_scbopt;	/* scrollbind options */
#endif
EXTERN char_u  *p_sections;	/* sections */
EXTERN int	p_secure;	/* do .exrc and .vimrc in secure mode */
EXTERN char_u  *p_sel;		/* 'selection' */
EXTERN char_u  *p_slm;		/* 'selectmode' */
#ifdef MKSESSION
EXTERN char_u  *p_sessopt;	/* sessionoptions */
#endif
EXTERN char_u  *p_sh;		/* name of shell to use */
EXTERN char_u  *p_shcf;		/* flag to shell to execute one command */
EXTERN char_u  *p_sp;		/* string for output of make */
EXTERN char_u  *p_shq;		/* quote character(s) for shell */
EXTERN char_u  *p_sxq;		/* quote around redirection for shell */
EXTERN char_u  *p_srr;		/* string for output of filter */
EXTERN long	p_st;		/* type of shell */
#ifdef STATUSLINE
EXTERN char_u  *p_stl;		/* status line content */
#endif
EXTERN int	p_sr;		/* shift round off (for < and >) */
EXTERN char_u  *p_shm;		/* When to use short message */
EXTERN char_u  *p_sbr;		/* string for break of line */
EXTERN int	p_sc;		/* show command in status line */
EXTERN int	p_sft;		/* showfulltag */
EXTERN int	p_sm;		/* showmatch */
EXTERN int	p_smd;		/* show mode */
EXTERN long	p_ss;		/* sideways scrolling offset */
EXTERN int	p_scs;		/* 'smartcase' */
EXTERN int	p_sta;		/* smart-tab for expand-tab */
EXTERN int	p_sb;		/* split window backwards */
EXTERN int	p_sol;		/* Move cursor to start-of-line? */
EXTERN char_u  *p_su;		/* suffixes for wildcard expansion */
EXTERN char_u  *p_sws;		/* swap file syncing */
EXTERN int	p_tbs;		/* tag binary search */
EXTERN long	p_tl;		/* used tag length */
EXTERN int	p_tr;		/* tag file name is relative */
EXTERN char_u  *p_tags;		/* tags search path */
EXTERN int	p_terse;	/* terse messages */
EXTERN int	p_ta;		/* auto textmode detection */
EXTERN int	p_to;		/* tilde is an operator */
EXTERN int	p_timeout;	/* mappings entered within one second */
EXTERN long	p_tm;		/* timeoutlen (msec) */
#ifdef WANT_TITLE
EXTERN int	p_title;	/* set window title if possible */
EXTERN long	p_titlelen;	/* length of window title in % of Columns */
EXTERN char_u  *p_titlestring;	/* window title string */
#endif
EXTERN int	p_ttimeout;	/* key codes entered within one second */
EXTERN long	p_ttm;		/* key code timeoutlen (msec) */
EXTERN int	p_tbi;		/* 'ttybuiltin' use builtin termcap first */
EXTERN int	p_tf;		/* terminal fast I/O */
#ifdef USE_GUI_GTK
EXTERN long	p_toolbar;	/* toolbar style */
#endif
EXTERN long	p_ttyscroll;	/* maximum nr of screen lines for a scroll */
EXTERN char_u  *p_ttym;		/* 'ttymouse', type of mouse */
EXTERN long	p_ul;		/* number of Undo Levels */
EXTERN long	p_uc;		/* update count for swap file */
#ifdef USE_CLIPBOARD
EXTERN int      p_useclip;      /* use clipboard as unnamed register */
#endif
EXTERN long	p_ut;		/* update time for swap file */
#ifdef VIMINFO
EXTERN char_u  *p_viminfo;	/* Parameters for using ~/.viminfo file */
#endif
EXTERN int	p_vb;		/* visual bell only (no beep) */
EXTERN long	p_verbose;	/* verbosity, -V command line argument */
EXTERN int	p_warn;		/* warn for changes at shell command */
#if defined(USE_GUI_WIN32) || defined(USE_GUI_MOTIF) || defined(LINT) || defined (USE_GUI_GTK)
#define HAS_WAK
EXTERN char_u	*p_wak;		/* 'winaltkeys' */
#endif
#ifdef WILDIGNORE
EXTERN char_u  *p_wig;		/* 'wildignore' */
#endif
EXTERN int	p_wiv;		/* inversion of text is weird */
EXTERN char_u  *p_ww;		/* which keys wrap to next/prev line */
EXTERN long	p_wc;		/* character for wildcard exapansion */
EXTERN long	p_wcm;		/* ditto - usable in mappings*/
EXTERN char_u  *p_wim;		/* 'wildmode' */
EXTERN int	p_wmnu;		/* 'wildmenu' */
EXTERN long	p_wh;		/* desired window height */
EXTERN long	p_wmh;		/* minimal window height */
EXTERN int	p_ws;		/* wrap scan */
EXTERN int	p_write;	/* 'write' */
EXTERN int	p_wa;		/* 'writeany' */
EXTERN int	p_wb;		/* 'writebackup' */
EXTERN long	p_wd;		/* write delay for screen output (for tests) */
