/* vi:set ts=8 sts=4 sw=4:
 * VIM - Vi IMproved		by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

#ifndef TEAROFF_H
#define TEAROFF_H

#include <gtk/gtk.h>
#ifdef GTK_HAVE_FEATURES_1_1_0

#include <gdk/gdk.h>
#include <gtk/gtkmenuitem.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif				/* __cplusplus */


#define TYPE_TEAROFF_MENU_ITEM	      (tearoff_menu_item_get_type ())
#define TEAROFF_MENU_ITEM(obj)	      (GTK_CHECK_CAST ((obj), TYPE_TEAROFF_MENU_ITEM, TearoffMenuItem))
#define TEAROFF_MENU_ITEM_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_TEAROFF_MENU_ITEM, TearoffMenuItemClass))
#define IS_TEAROFF_MENU_ITEM(obj)	      (GTK_CHECK_TYPE ((obj), TYPE_TEAROFF_MENU_ITEM))
#define IS_TEAROFF_MENU_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_TEAROFF_MENU_ITEM))


    typedef struct _TearoffMenuItem TearoffMenuItem;
    typedef struct _TearoffMenuItemClass TearoffMenuItemClass;

    struct _TearoffMenuItem {
	GtkMenuItem menu_item;

	guint torn_off:1;
    };

    struct _TearoffMenuItemClass {
	GtkMenuItemClass parent_class;
    };


    GtkType tearoff_menu_item_get_type(void);
    GtkWidget *tearoff_menu_item_new(void);

#ifdef __cplusplus
}

#endif				/* __cplusplus */
#endif	/* GTK_HAVE_FEATURES_1_1_0 */
#endif	/* TEAROFF_H */
