/* vi:set ts=8 sts=4 sw=4:
 * VIM - Vi IMproved		by Bram Moolenaar
 *
 * Do ":help uganda"  in Vim to read copying and usage conditions.
 * Do ":help credits" in Vim to see a list of people who contributed.
 */

/*
 * (C) 1998,1999 by Marcin Dalecki <dalecki@cs.net.pl>
 *
 *	"I'm a one-man software company. If you have anything UNIX, net or
 *	embedded systems related, which seems to cause some serious trouble for
 *	your's in-house developers, maybe we need to talk badly with each other
 *	:-) <dalecki@cs.net.pl> (My native language is polish and I speak
 *	native grade german too. I'm living in Gttingen.de.)
 *	--mdcki"
 *
 * Slightly customized gtk_tearoff_menu_item to get rid of the
 * stiupid "button is torn off state" arrow.
 */

#include <gtk/gtk.h>
#ifdef GTK_HAVE_FEATURES_1_1_0
#include <gtk/gtkmenu.h>
#include <gtk/gtksignal.h>
#include "gui_gtk_to.h"

#define TEAR_LENGTH 5
#define BORDER_SPACING  3

static void tearoff_menu_item_class_init(TearoffMenuItemClass * klass);
static void tearoff_menu_item_init(TearoffMenuItem * tearoff_menu_item);
static void tearoff_menu_item_size_request(GtkWidget * widget,
					   GtkRequisition * requisition);
static void tearoff_menu_item_draw(GtkWidget * widget,
				   GdkRectangle * area);
static gint tearoff_menu_item_expose(GtkWidget * widget,
				     GdkEventExpose * event);
static void tearoff_menu_item_activate(GtkMenuItem * menu_item);
static gint tearoff_menu_item_delete_cb(GtkMenuItem * menu_item,
					GdkEventAny * event);

GtkType tearoff_menu_item_get_type(void)
{
    static GtkType tearoff_menu_item_type = 0;

    if (!tearoff_menu_item_type) {
	GtkTypeInfo tearoff_menu_item_info =
	{
	    "TearoffMenuItem",
	    sizeof(TearoffMenuItem),
	    sizeof(TearoffMenuItemClass),
	    (GtkClassInitFunc) tearoff_menu_item_class_init,
	    (GtkObjectInitFunc) tearoff_menu_item_init,
	/* reserved_1 */ NULL,
	/* reserved_2 */ NULL,
#ifdef GTK_HAVE_FEATURES_1_1_0
	    (GtkClassInitFunc) NULL,
#endif
	};

	tearoff_menu_item_type = gtk_type_unique(gtk_menu_item_get_type(), &tearoff_menu_item_info);
    }
    return tearoff_menu_item_type;
}

GtkWidget * tearoff_menu_item_new(void)
{
    return GTK_WIDGET(gtk_type_new(tearoff_menu_item_get_type()));
}

static void tearoff_menu_item_class_init(TearoffMenuItemClass * klass)
{
    GtkWidgetClass *widget_class;
    GtkMenuItemClass *menu_item_class;

    widget_class = (GtkWidgetClass *) klass;
    menu_item_class = (GtkMenuItemClass *) klass;

    widget_class->draw = tearoff_menu_item_draw;
    widget_class->expose_event = tearoff_menu_item_expose;
    widget_class->size_request = tearoff_menu_item_size_request;

    menu_item_class->activate = tearoff_menu_item_activate;
}

static void tearoff_menu_item_init(TearoffMenuItem * tearoff_menu_item)
{
    tearoff_menu_item->torn_off = FALSE;
}

static void tearoff_menu_item_size_request(GtkWidget * widget,
					   GtkRequisition * requisition)
{
    TearoffMenuItem *tearoff;

    tearoff = TEAROFF_MENU_ITEM(widget);

    requisition->width = (GTK_CONTAINER(widget)->border_width +
			  widget->style->klass->xthickness +
			  BORDER_SPACING) * 2;
    requisition->height = (GTK_CONTAINER(widget)->border_width +
			   widget->style->klass->ythickness) * 2;

    if (tearoff->torn_off) {
	requisition->height = 0;
    } else {
	requisition->height += widget->style->klass->ythickness;
    }
}

static void tearoff_menu_item_paint(GtkWidget * widget,
				    GdkRectangle * area)
{
    GtkMenuItem *menu_item;
    TearoffMenuItem *tearoff_item;
    gint width, height;
    gint x, y;
    gint right_max;

    g_return_if_fail(widget != NULL);
    g_return_if_fail(IS_TEAROFF_MENU_ITEM(widget));

    if (GTK_WIDGET_DRAWABLE(widget)) {
	menu_item = GTK_MENU_ITEM(widget);
	tearoff_item = TEAROFF_MENU_ITEM(widget);

	gtk_style_set_background(widget->style, widget->window, widget->state);
	gdk_window_clear_area(widget->window, area->x, area->y, area->width, area->height);

	x = GTK_CONTAINER(menu_item)->border_width;
	y = GTK_CONTAINER(menu_item)->border_width;
	width = widget->allocation.width - x * 2;
	height = widget->allocation.height - y * 2;
	right_max = x + width;

	if (widget->state == GTK_STATE_PRELIGHT)
	    gtk_draw_shadow(widget->style,
			    widget->window,
			    GTK_STATE_PRELIGHT,
			    GTK_SHADOW_OUT,
			    x, y, width, height);

	if (!tearoff_item->torn_off)
	    while (x < right_max) {
		gtk_draw_hline(widget->style, widget->window, GTK_STATE_NORMAL,
			       x, MIN(x + TEAR_LENGTH, right_max),
		    y + (height - widget->style->klass->ythickness) / 2);
		x += 2 * TEAR_LENGTH;
	    }
    }
}

static void tearoff_menu_item_draw(GtkWidget * widget,
				   GdkRectangle * area)
{
    g_return_if_fail(widget != NULL);
    g_return_if_fail(IS_TEAROFF_MENU_ITEM(widget));
    g_return_if_fail(area != NULL);

    tearoff_menu_item_paint(widget, area);
}

static gint tearoff_menu_item_expose(GtkWidget * widget,
			  GdkEventExpose * event)
{
    g_return_val_if_fail(widget != NULL, FALSE);
    g_return_val_if_fail(IS_TEAROFF_MENU_ITEM(widget), FALSE);
    g_return_val_if_fail(event != NULL, FALSE);

    tearoff_menu_item_paint(widget, &event->area);

    return FALSE;
}

/*ARGSUSED*/
static gint  tearoff_menu_item_delete_cb(GtkMenuItem * menu_item, GdkEventAny * event)
{
    tearoff_menu_item_activate(menu_item);
    return TRUE;
}

static void tearoff_menu_item_activate(GtkMenuItem * menu_item)
{
    TearoffMenuItem *tearoff_menu_item;

    g_return_if_fail(menu_item != NULL);
    g_return_if_fail(IS_TEAROFF_MENU_ITEM(menu_item));

    tearoff_menu_item = TEAROFF_MENU_ITEM(menu_item);
    tearoff_menu_item->torn_off = !tearoff_menu_item->torn_off;

    if (GTK_IS_MENU(GTK_WIDGET(menu_item)->parent)) {
	GtkMenu *menu = GTK_MENU(GTK_WIDGET(menu_item)->parent);
	gboolean need_connect;

	need_connect = (tearoff_menu_item->torn_off && !menu->tearoff_window);

	gtk_menu_set_tearoff_state(GTK_MENU(GTK_WIDGET(menu_item)->parent),
				   tearoff_menu_item->torn_off);

	if (need_connect)
	    gtk_signal_connect_object(GTK_OBJECT(menu->tearoff_window),
				      "delete_event",
			    GTK_SIGNAL_FUNC(tearoff_menu_item_delete_cb),
				      GTK_OBJECT(menu_item));
    }
    gtk_widget_queue_resize(GTK_WIDGET(menu_item));
}
#endif	/* GTK_HAVE_FEATURES_1_1_0 */
