/*****************************************************************************
*   $Id: main.h,v 7.2 1999/01/27 03:47:55 darren Exp $
*
*   Copyright (c) 1998, Darren Hiebert
*
*   This source code is released for free distribution under the terms of the
*   GNU General Public License.
*
*   External interface to main.c
*****************************************************************************/
#ifndef _MAIN_H
#define _MAIN_H

/*============================================================================
=   Include files
============================================================================*/
#include "general.h"

/*============================================================================
=   Data declarations
============================================================================*/
typedef int errorSelection;

enum eErrorTypes { FATAL = 1, WARNING = 2, PERROR = 4 };

/*============================================================================
=   Function prototypes
============================================================================*/
#ifdef NEED_PROTO_MALLOC
extern void *malloc __ARGS((size_t));
extern void *realloc __ARGS((void *ptr, size_t));
#endif

extern void error __ARGS((const errorSelection selection, const char *const format, ...));
extern boolean strequiv __ARGS((const char *const s1, const char *const s2));
extern void *eMalloc __ARGS((const size_t size));
extern void *eRealloc __ARGS((void *const ptr, const size_t size));
extern long unsigned int getFileSize __ARGS((const char *const name));
extern boolean doesFileExist __ARGS((const char *const fileName));
extern void addTotals __ARGS((const unsigned int files, const long unsigned int lines, const long unsigned int bytes));
extern const char *baseFilename __ARGS((const char *const filePath));
extern boolean isAbsolutePath __ARGS((const char *const path));
extern vString *combinePathAndFile __ARGS((const char *const path, const char *const file));
extern const char *getExecutableName __ARGS((void));
extern int main __ARGS((int argc, char **argv));

#endif	/* _MAIN_H */

/* vi:set tabstop=8 shiftwidth=4: */
